/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.lsst.ccs.description.EffectiveNode;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.utilities.structs.UniquePair;

public class ComponentLookupService {
    private final EffectiveNode top;

    public ComponentLookupService(EffectiveNode top) {
        this.top = top;
    }

    public Object getComponentByName(String name) {
        Object res = this.top.getIndirect(name);
        return res;
    }

    public <T> LinkedHashMap<String, T> getChildren(String parentName, Class<T> classFilter) {
        EffectiveNode current = (EffectiveNode)this.top.getNodeByName(parentName);
        ArrayList children = current.getChildren();
        LinkedHashMap<String, Object> mapRes = new LinkedHashMap<String, Object>();
        for (EffectiveNode child : children) {
            Object realValue = child.getRealValue();
            if (classFilter != null && !classFilter.isAssignableFrom(realValue.getClass())) continue;
            Object realChild = realValue;
            String key = child.getKey();
            mapRes.put(key, realChild);
        }
        return mapRes;
    }

    public <T> List<T> listChildren(String parentName, Class<T> klass) {
        return this.getChildren(parentName, klass).values().stream().collect(Collectors.toList());
    }

    public Map.Entry<String, Object> getParent(String componentName) {
        EffectiveNode current = (EffectiveNode)this.top.getNodeByName(componentName);
        EffectiveNode parent = (EffectiveNode)current.getParent();
        if (parent == null) {
            return new UniquePair((Object)"_EDEN_", null);
        }
        String key = parent.getKey();
        Object value = parent.getRealValue();
        return new UniquePair((Object)key, value);
    }

    public String getFullPathFor(String componentName) {
        String parentName = this.getParent(componentName).getKey();
        if ("_EDEN_".equals(parentName)) {
            return componentName;
        }
        return String.valueOf(this.getFullPathFor(parentName)) + "/" + componentName;
    }

    public <T> void proceduralWalk(String startingNodeName, Class<T> klass, Consumer<T> pre, Consumer<T> post) {
        EffectiveNode startFromNode = startingNodeName == null ? this.top : (EffectiveNode)this.top.getNodeByName(startingNodeName);
        startFromNode.proceduralWalk(klass, pre, post);
    }

    public void proceduralNodeWalk(String startingNodeName, Consumer<EffectiveNode> pre, Consumer<EffectiveNode> post) {
        EffectiveNode startFromNode = startingNodeName == null ? this.top : (EffectiveNode)this.top.getNodeByName(startingNodeName);
        startFromNode.proceduralNodeWalk((Consumer)pre, (Consumer)post);
    }

    public <T> void treeWalk(String startingNodeName, Class<T> klass, Function<T, TreeWalkerDiag> func, Consumer<T> post) {
        EffectiveNode startFromNode = startingNodeName == null ? this.top : (EffectiveNode)this.top.getNodeByName(startingNodeName);
        startFromNode.treeWalk(klass, func, post);
    }
}

