/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.modbus;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.modbus.ModbusIO;
import org.lsst.ccs.utilities.conv.Convert;

public class ModbusIONet
implements ModbusIO {
    private Socket sock;
    private InputStream in;
    private OutputStream out;

    @Override
    public void open(String host, int port) throws DriverException {
        try {
            this.sock = new Socket(host, port);
            this.in = this.sock.getInputStream();
            this.out = this.sock.getOutputStream();
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public void close() throws DriverException {
        try {
            this.sock.close();
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public int send(byte[] cmnd, byte[] resp, int timeout) throws DriverException {
        this.write(cmnd);
        int leng = this.read(resp, timeout);
        if (Convert.bytesToShortBE((byte[])resp, (int)0) != Convert.bytesToShortBE((byte[])cmnd, (int)0)) {
            throw new DriverException("Transaction IDs don't match");
        }
        return leng;
    }

    private void write(byte[] command) throws DriverException {
        Convert.shortToBytesBE((short)0, (byte[])command, (int)0);
        Convert.shortToBytesBE((short)0, (byte[])command, (int)2);
        int length = command.length - 6 - 2;
        Convert.shortToBytesBE((short)((short)length), (byte[])command, (int)4);
        try {
            this.out.write(command, 0, command.length - 2);
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    private int read(byte[] buff, int timeout) throws DriverException {
        this.setTimeout(timeout);
        int posn = 0;
        int rqstLeng = 6;
        while (true) {
            if (posn < rqstLeng) {
                if (buff.length < rqstLeng) {
                    throw new DriverException("Read buffer too short");
                }
                try {
                    int leng = this.in.read(buff, posn, rqstLeng - posn);
                    if (leng <= 0) {
                        throw new DriverException("Connection closed");
                    }
                    posn += leng;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    throw new DriverTimeoutException("Read timed out");
                }
                catch (IOException e) {
                    throw new DriverException((Throwable)e);
                }
            }
            if (rqstLeng != 6 || (rqstLeng += Convert.bytesToShortBE((byte[])buff, (int)4)) <= 6) break;
        }
        return posn;
    }

    @Override
    public void flush() throws DriverException {
        try {
            int count = this.in.available();
            if (count > 0) {
                byte[] buff = new byte[count];
                this.in.read(buff, 0, count);
            }
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    private void setTimeout(int timeout) throws DriverException {
        try {
            this.sock.setSoTimeout(timeout);
        }
        catch (SocketException e) {
            throw new DriverException((Throwable)e);
        }
    }
}

