/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class Module
extends Observable
implements Observer,
Configurable,
SignalHandler {
    protected Configurable.Environment environment;
    private static Logger log = Logger.getLogger((String)"org.lsst.ccs.framework");
    protected String name;
    private List<Observable> observables = new ArrayList<Observable>();
    protected int nObserverThreads = 1;
    private PeriodicTask tickPeriodicTask;
    @ConfigurationParameter
    protected int tickMillis = -1;
    ExecutorService exec;

    public Module() {
    }

    public Module(int tickMillis) {
        this.tickMillis = tickMillis;
    }

    public Module(String name, int tickMillis) {
        this.name = name;
        this.tickMillis = tickMillis;
    }

    public Module(String name) {
        this(name, -1);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Configurable.Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(Configurable.Environment environment) {
        this.environment = environment;
        if (this.name == null) {
            this.name = environment.getNameOfComponent();
        }
    }

    public void setObservables(List<Observable> l) {
        this.observables.addAll(l);
    }

    public void listens(Observable ... observs) {
        for (Observable observable : observs) {
            this.observables.add(observable);
        }
    }

    public List<Observable> getObservables() {
        return this.observables;
    }

    @ConfigurationParameterChanger(propertyName="tickMillis")
    public void setTickMillis(int tickMillis) {
        if (this.tickMillis != tickMillis) {
            this.tickMillis = tickMillis;
            if (this.tickPeriodicTask != null) {
                this.tickPeriodicTask.stop();
                if (tickMillis > 0) {
                    this.tickPeriodicTask.setPeriod((long)tickMillis, TimeUnit.MILLISECONDS);
                    this.tickPeriodicTask.start();
                }
            }
        }
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setNObserverThreads(int observerThreads) {
        this.nObserverThreads = observerThreads;
    }

    public int getNObserverThreads() {
        return this.nObserverThreads;
    }

    @Override
    public final void init() {
        this.initModule();
        for (Observable o : this.observables) {
            o.addObserver(this);
        }
        this.exec = Executors.newFixedThreadPool(this.nObserverThreads, new ThreadFactory(){
            int number;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "update-" + this.number++);
            }
        });
    }

    public void initModule() {
    }

    @Override
    public Subsystem getSubsystem() {
        Optional<Subsystem> opt = this.getEnvironment().getSubsystem();
        if (opt.isPresent()) {
            return opt.get();
        }
        return null;
    }

    @Override
    public void postStart() throws HardwareException {
        this.startTicking();
    }

    @Deprecated
    public void startTicking() {
        this.tickPeriodicTask = new PeriodicTask(this.getSubsystem().getScheduler(), () -> this.tick(), true, "tick", Level.SEVERE, (long)this.tickMillis, TimeUnit.MILLISECONDS);
        if (this.tickMillis > 0 && this.tickPeriodicTask != null) {
            this.tickPeriodicTask.start();
        }
    }

    @Override
    public void update(final Observable o, final Object arg) {
        if (!(arg instanceof ValueUpdate)) {
            log.error((Object)("update called with arg not a ValueUpdate: " + arg));
            return;
        }
        this.exec.execute(new Runnable(){

            @Override
            public void run() {
                Module.this.processUpdate(o, (ValueUpdate)arg);
            }
        });
    }

    public void processUpdate(Observable source, ValueUpdate update) {
    }

    public void tick() {
    }

    @Override
    public void shutdownNow() {
        if (this.tickPeriodicTask != null) {
            this.tickPeriodicTask.stop();
        }
        if (this.exec != null) {
            this.exec.shutdownNow();
        }
    }

    @Override
    public TreeWalkerDiag signal(Signal sig) {
        return TreeWalkerDiag.GO;
    }

    @Command(description="will propagate signal to Module and its children ", type=Command.CommandType.SIGNAL)
    public void sendSignal(String signalString) {
        SignalLevel signalLevel = SignalLevel.valueOf(signalString);
        this.getEnvironment().sendSignal(new Signal(signalLevel));
    }

    @Command(description="will propagate signal to Module and its children with  an expected maximum delay", type=Command.CommandType.SIGNAL)
    public void sendSignalWithTimeLimit(String signalString, long expectedMaxDelay) {
        SignalLevel signalLevel = SignalLevel.valueOf(signalString);
        this.getEnvironment().sendSignal(new Signal(signalLevel, expectedMaxDelay));
    }

    @Command(description="publishes a tree of component names", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public TreeBranch<String> getComponentTree() {
        return this.getEnvironment().getComponentTree();
    }

    public class ValueUpdate {
        String name;
        Object value;
        long timeStamp = System.currentTimeMillis();

        public ValueUpdate(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public ValueUpdate(String name, Object value, long tStamp) {
            this.name = name;
            this.value = value;
            this.timeStamp = tStamp;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }
    }
}

