/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor;

import java.io.IOException;
import java.io.Serializable;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.monitor.data.MonMainFullState;
import org.lsst.ccs.subsystem.monitor.data.MonMainState;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.utilities.logging.Logger;

public class MonMain
extends Module
implements HardwareController {
    private final int checkMillis;
    private final Logger sLog;
    private Monitor mon;

    public MonMain(String name, int tickMillis, int checkMillis) {
        super(name, tickMillis);
        this.checkMillis = checkMillis;
        this.sLog = Logger.getLogger((String)"org.lsst.ccs.subsystem.monitor");
    }

    public void initModule() {
        this.mon = new Monitor(this, null, this.sLog);
        this.mon.initConfiguration();
    }

    public TreeWalkerDiag checkHardware() {
        this.mon.initSensors(this.checkMillis);
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() {
        System.out.println("checkStarted was called");
    }

    public void checkStopped() {
        System.out.println("checkStopped was called");
    }

    public void postStart() throws HardwareException {
        this.mon.start();
        super.postStart();
        this.publishState();
        this.mon.publishState();
        this.mon.publishLimits();
        System.out.println("Monitoring test started");
    }

    public void tick() {
        this.mon.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setTickMillis(int value) {
        super.setTickMillis(value);
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current configuration")
    public void saveConfig() throws IOException {
        this.getEnvironment().saveAllChanges();
        this.mon.clearLimitChanges();
        this.mon.publishState();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full generic monitoring state")
    public MonMainFullState getFullState() {
        MonMainState mmState = new MonMainState(this.getTickMillis());
        MonitorFullState monState = this.mon.getFullState();
        return new MonMainFullState(mmState, monState);
    }

    private void publishState() {
        KeyValueData data = new KeyValueData("MonMainState", (Serializable)new MonMainState(this.getTickMillis()));
        this.getSubsystem().publishSubsystemDataOnStatusBus(data);
    }
}

