/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;

public class RefrigState
implements Serializable {
    public static final String KEY = "RefrigState";
    public static final int MAX_COMPRESSORS = 8;
    public static final int POWER_OFF = 0;
    public static final int POWER_ON = 1;
    public static final int POWER_TRIPPED = 2;
    public static final int CONTROL_OFF = 0;
    public static final int CONTROL_ON = 1;
    public static final int CONTROL_AUTO = 2;
    public static final int CONTROL_NONE = 3;
    private static final int NUM_CMPR_POWER_BITS = 2;
    private static final int NUM_HEATER_POWER_BITS = 2;
    private static final int HEATER_POWER_BIT_NUM = 16;
    private static final int NUM_HEATER_CONTROL_BITS = 2;
    private static final int HEATER_CONTROL_BIT_NUM = 18;
    private static final int ALARM_DISABLED_BIT_NUM = 20;
    private int systemState;
    private int numCmprs;
    private int tickMillis;
    private double heaterPower;
    private double loadTemp;
    private static final long serialVersionUID = -8633355441102763997L;

    void setSystemState(int state) {
        this.systemState = state;
    }

    int getSystemState() {
        return this.systemState;
    }

    public void setCmprPowerState(int cmpr, int state) {
        this.setSystemStateBits(2, 2 * cmpr, state);
    }

    public int getCmprPowerState(int cmpr) {
        return this.getSystemStateBits(2, 2 * cmpr);
    }

    public void setHeaterPowerState(int state) {
        this.setSystemStateBits(2, 16, state);
    }

    public int getHeaterPowerState() {
        return this.getSystemStateBits(2, 16);
    }

    public void setHeaterControlState(int state) {
        this.setSystemStateBits(2, 18, state);
    }

    public int getHeaterControlState() {
        return this.getSystemStateBits(2, 18);
    }

    public void setAlarmDisabled(boolean value) {
        this.setSystemStateBit(20, value);
    }

    public boolean isAlarmDisabled() {
        return this.isSystemStateBitSet(20);
    }

    public void setNumCmprs(int value) {
        this.numCmprs = value;
    }

    public int getNumCmprs() {
        return this.numCmprs;
    }

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setHeaterPower(double value) {
        this.heaterPower = value;
    }

    public double getHeaterPower() {
        return this.heaterPower;
    }

    public double getLoadTemp() {
        return this.loadTemp;
    }

    public void setLoadTemp(double value) {
        this.loadTemp = value;
    }

    private void setSystemStateBits(int nBits, int bitNum, int value) {
        int mask = (1 << nBits) - 1;
        this.systemState = this.systemState & ~(mask << bitNum) | (value & mask) << bitNum;
    }

    private int getSystemStateBits(int nBits, int bitNum) {
        return this.systemState >> bitNum & (1 << nBits) - 1;
    }

    private void setSystemStateBit(int bitNum, boolean value) {
        this.systemState = value ? (this.systemState |= 1 << bitNum) : (this.systemState &= ~(1 << bitNum));
    }

    private boolean isSystemStateBitSet(int bitNum) {
        return (this.systemState >> bitNum & 1) != 0;
    }
}

