/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.ConfigurableSubsystem;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.monitor.Channel;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.monitor.MonitorCommands;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.utilities.logging.Logger;

public class Subscale
extends Module
implements HardwareController,
Monitor.AlarmHandler {
    private static final int TICK_INTERVAL = 10000;
    private static final int EVENT_ID_MAIN_POWER = 0;
    private static final int POWER_SET_INTERVAL = 5000;
    private static final String REFRIG = "Refrig";
    private final Logger sLog = Logger.getLogger((String)"org.lsst.ccs.subsystem.refrig");
    private int monMillis = 1000;
    private int checkMillis = 0;
    private String loadPowerDevc;
    private String[] cmprPowerLines;
    private String[] loadPowerLines;
    private String[] alarmDsabChans;
    private String[] loadTempChans;
    private String tempCtrl;
    private boolean coldStart;
    private boolean running;
    private final List<Line> cmprPowerLinesL = new ArrayList<Line>();
    private final List<Line> loadPowerLinesL = new ArrayList<Line>();
    private final List<Channel> alarmDsabChansL = new ArrayList<Channel>();
    private final List<Channel> loadTempChansL = new ArrayList<Channel>();
    private ConfigurableSubsystem subsys;
    private PowerDevice loadPowerDevcD;
    private TempControl tempCtrlC;
    private Monitor mon;
    private int state = 8;
    private double loadTemp;
    private double loadPower;
    private Double startPower = 0.0;

    public Subscale(String name, int tickMillis, int monMillis, int checkMillis, String[] cmprPowerLines, String[] loadPowerLines, String loadPowerDevc, String[] alarmDsabChans, String[] loadTempChans, String tempCtrl) {
        super(name, tickMillis);
        this.monMillis = monMillis;
        this.checkMillis = checkMillis;
        this.cmprPowerLines = cmprPowerLines;
        this.loadPowerLines = loadPowerLines;
        this.loadPowerDevc = loadPowerDevc;
        this.alarmDsabChans = alarmDsabChans;
        this.loadTempChans = loadTempChans;
        this.tempCtrl = tempCtrl;
    }

    public Subscale() {
    }

    public void initModule() {
        Object cmpt;
        this.setName("main");
        if (this.getTickMillis() <= 0) {
            this.setTickMillis(10000);
        }
        this.subsys = (ConfigurableSubsystem)this.getSubsystem();
        String cold = System.getProperty("lsst.ccs.refrig.coldstart", "");
        this.coldStart = cold.equals("true");
        this.loadPowerDevcD = (PowerDevice)((Object)this.getComponent(this.loadPowerDevc, PowerDevice.class));
        for (String chanS : this.cmprPowerLines) {
            cmpt = this.getComponent(chanS, Line.class);
            if (cmpt == null) continue;
            this.cmprPowerLinesL.add((Line)cmpt);
        }
        for (String chanS : this.loadPowerLines) {
            cmpt = this.getComponent(chanS, Line.class);
            if (cmpt == null) continue;
            this.loadPowerLinesL.add((Line)cmpt);
        }
        for (String chanS : this.alarmDsabChans) {
            cmpt = this.getComponent(chanS, Channel.class);
            if (cmpt == null) continue;
            this.alarmDsabChansL.add((Channel)cmpt);
        }
        for (String chanS : this.loadTempChans) {
            cmpt = this.getComponent(chanS, Channel.class);
            if (cmpt == null) continue;
            this.loadTempChansL.add((Channel)cmpt);
        }
        this.tempCtrlC = (TempControl)((Object)this.getComponent(this.tempCtrl, TempControl.class));
        if (this.cmprPowerLinesL.isEmpty()) {
            this.sLog.error((Object)"No valid compressor power lines specified");
        } else if (this.cmprPowerLinesL.size() != this.cmprPowerLines.length) {
            this.sLog.error((Object)"Some compressor power lines are invalid");
        }
        if (this.loadPowerLinesL.isEmpty()) {
            this.sLog.error((Object)"No valid load power lines specified");
        } else if (this.loadPowerLinesL.size() != this.loadPowerLines.length) {
            this.sLog.error((Object)"Some load power lines are invalid");
        }
        if (this.loadPowerDevcD == null) {
            this.sLog.error((Object)"No valid load power device specified");
            this.state |= 0x10;
        }
        if (this.alarmDsabChansL.size() != this.alarmDsabChans.length) {
            this.sLog.error((Object)"Some alarm disable channels are invalid");
        }
        if (this.loadTempChansL.size() != this.loadTempChans.length) {
            this.sLog.error((Object)"Some load temperature channels are invalid");
        }
        if (this.tempCtrlC == null) {
            this.sLog.error((Object)"No valid temperature controller specified");
        }
        this.mon = new Monitor((Module)this, (Monitor.AlarmHandler)this, this.sLog);
        this.mon.initConfiguration();
        this.subsys.addCommandsFromObject((Object)new MonitorCommands(this.mon), "");
        if (this.tempCtrlC != null) {
            this.tempCtrlC.initialize(this.loadTempChansL, this.loadPowerDevcD, this.mon);
        }
    }

    public TreeWalkerDiag checkHardware() {
        for (Line line : this.cmprPowerLinesL) {
            line.setWarm(!this.coldStart);
        }
        for (Line line : this.loadPowerLinesL) {
            line.setWarm(!this.coldStart);
        }
        this.mon.initSensors(this.checkMillis);
        for (Line line : this.cmprPowerLinesL) {
            line.setWarm(false);
        }
        for (Line line : this.loadPowerLinesL) {
            line.setWarm(false);
        }
        this.setMainPowerEnable(this.isCmprPowerOn() ? 1 : (this.isLoadPowerOn() ? -1 : 0));
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() {
        System.out.println("checkStarted was called");
    }

    public void checkStopped() {
        System.out.println("checkStopped was called");
    }

    public void postStart() throws HardwareException {
        this.running = true;
        this.mon.start(this.monMillis);
        this.sLog.info((Object)("Refrigeration subsystem (" + this.subsys.getName() + ") started"));
        this.publishState();
        this.mon.publishState();
        this.mon.publishLimits();
        new Timer("SetPower", true).scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Subscale.this.setLoadPower();
            }
        }, 5000L, 5000L);
        super.postStart();
    }

    public void tick() {
        this.mon.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setTickMillis(int value) {
        super.setTickMillis(value);
        if (this.running) {
            this.publishState();
        }
    }

    public void processAlarm(int event, int parm) {
        switch (parm) {
            case 0: {
                if (event == 0) {
                    if ((this.state & 2) != 0) break;
                    this.state |= 2;
                    this.setMainPowerEnable(0);
                    this.publishState();
                    break;
                }
                if (event != 2 || (this.state & 2) == 0) break;
                this.state &= 0xFFFFFFFD;
                this.publishState();
                break;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the main power enabled state")
    public void setMainPowerEnable(int value) {
        if (value != 0) {
            if ((this.state & 2) == 0) {
                this.state |= 1;
                this.state = value > 0 ? (this.state &= 0xFFFFFFDF) : (this.state |= 0x20);
            }
        } else {
            this.state &= 0xFFFFFFDE;
        }
        this.setMainPower();
        this.setLoadPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the load power enabled state")
    public void setLoadPowerEnable(int value) {
        if (this.loadPowerDevcD != null) {
            this.state = value != 0 ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
            if (value < 0) {
                if (this.tempCtrlC != null) {
                    this.state |= 0x10;
                    this.tempCtrlC.setTemp(this.loadTemp);
                    if ((this.state & 1) != 0) {
                        this.startTempCtrl();
                    }
                }
            } else {
                this.state &= 0xFFFFFFEF;
                this.stopTempCtrl();
                this.setLoadPower();
            }
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the load trip enabled state")
    public void setLoadTripEnable(int value) {
        boolean enable;
        boolean bl = enable = value != 0;
        this.state = enable ? (this.state |= 8) : (this.state &= 0xFFFFFFF7);
        for (Channel chan : this.alarmDsabChansL) {
            chan.enableAlarm(false, enable);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the load power set point")
    public void setLoadPower(double value) {
        this.loadPower = value;
        if (this.startPower != null) {
            this.startPower = this.loadPower;
        }
        this.setLoadPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the load temperature set point")
    public void setLoadTemp(double value) {
        this.loadTemp = value;
        if (this.tempCtrlC != null) {
            this.tempCtrlC.setTemp(this.loadTemp);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current configuration")
    public void saveNamedConfig(String name) throws IOException {
        this.subsys.saveChangesForCategoriesAs(new String[]{"Refrig:" + name});
    }

    @Command(type=Command.CommandType.ACTION, description="Load a named configuration")
    public void loadNamedConfig(String name) throws IOException {
        this.subsys.loadCategories(new String[]{"Refrig:" + name});
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full refrigeration state")
    public RefrigFullState getFullState() {
        RefrigState refgState = new RefrigState(this.state, this.getTickMillis(), this.loadPower, this.loadTemp);
        MonitorFullState monState = this.mon.getFullState();
        return new RefrigFullState(refgState, monState);
    }

    private void publishState() {
        RefrigState rState = new RefrigState(this.state, this.getTickMillis(), this.loadPower, this.loadTemp);
        KeyValueData data = new KeyValueData("RefrigState", (Serializable)rState);
        this.subsys.publishSubsystemDataOnStatusBus(data);
    }

    private void setMainPower() {
        boolean on = (this.state & 1) != 0;
        boolean loadOnly = (this.state & 0x20) != 0;
        for (Line line : this.cmprPowerLinesL) {
            line.set(on & !loadOnly);
        }
        for (Line line : this.loadPowerLinesL) {
            line.set(on);
        }
        if (this.loadPowerDevcD != null) {
            if (on) {
                this.loadPowerDevcD.enable();
                if ((this.state & 0x10) != 0) {
                    this.startTempCtrl();
                }
            } else {
                this.stopTempCtrl();
                this.loadPowerDevcD.disable();
            }
        }
    }

    private void setLoadPower() {
        if (this.loadPowerDevcD == null || !this.loadPowerDevcD.isOnline()) {
            return;
        }
        this.loadPowerDevcD.enableOutput(0, (this.state & 4) != 0);
        if ((this.state & 0x10) == 0) {
            this.loadPowerDevcD.setPower(0, this.loadPower);
            this.startPower = this.loadPower;
        }
    }

    private boolean isCmprPowerOn() {
        if (this.cmprPowerLinesL.isEmpty()) {
            return false;
        }
        for (Line line : this.cmprPowerLinesL) {
            if (line.isSet()) continue;
            return false;
        }
        return true;
    }

    private boolean isLoadPowerOn() {
        if (this.loadPowerLinesL.isEmpty()) {
            return false;
        }
        for (Line line : this.loadPowerLinesL) {
            if (line.isSet()) continue;
            return false;
        }
        return true;
    }

    private void startTempCtrl() {
        if (this.tempCtrlC != null) {
            if (this.startPower == null) {
                this.tempCtrlC.restart();
            } else {
                this.tempCtrlC.start(this.startPower);
                this.startPower = null;
            }
        }
    }

    private void stopTempCtrl() {
        if (this.tempCtrlC != null) {
            this.tempCtrlC.stop();
        }
    }

    private Object getComponent(String name, Class cls) {
        Object cmpt = this.getComponentByName(name);
        if (cmpt != null && !cls.isInstance(cmpt)) {
            cmpt = null;
        }
        return cmpt;
    }
}

