/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.monitor.Control;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.refrig.PlutoDevice;

public class PlutoControl
extends Control {
    private static final int TYPE_BIT = 0;
    private static final int TYPE_REG = 1;
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private final PlutoDevice pDevc;
    private final String sType;
    private final double offset;
    private final double scale;
    private int type;
    private int area;

    public PlutoControl(String desc, int hwChan, String type, double offset, double scale) {
        super(desc, hwChan);
        this.sType = type;
        this.offset = offset;
        this.scale = scale;
        this.pDevc = (PlutoDevice)this.devc;
    }

    protected void configure(Monitor mon, Device devc) {
        int maxChan;
        super.configure(mon, devc);
        Integer iType = null;
        String[] typeFields = this.sType.split(":", -1);
        if (typeFields.length == 2) {
            iType = typeMap.get(typeFields[0].toUpperCase());
        }
        try {
            this.area = Integer.decode(typeFields[1]);
        }
        catch (NumberFormatException e) {
            this.area = -1;
        }
        if (iType == null || this.area < 0 || this.area >= 4) {
            mon.reportConfigError(this.getName(), "type", "has invalid value");
        }
        this.type = iType;
        int n = maxChan = this.type == 0 ? 16 : 2;
        if (this.hwChan >= maxChan) {
            mon.reportConfigError(this.getName(), "hwchan", "has invalid value");
        }
    }

    public void addConfigValues(Map<String, Object> map) {
    }

    public void writeValue(double value) {
        int ival = (int)((value - this.offset) / this.scale);
        if (this.type == 0) {
            this.pDevc.writeBit(this.area, this.hwChan, ival);
        } else {
            this.pDevc.writeRegister(this.area, this.hwChan, ival);
        }
    }

    static {
        typeMap.put("BIT", 0);
        typeMap.put("REG", 1);
    }
}

