/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.mmr.Mmr;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class MMRDevice
extends Device
implements Mmr.Listener {
    static final int CHAN_T0 = 0;
    static final int CHAN_T1 = 1;
    static final int CHAN_P0 = 2;
    static final int CHAN_P1 = 3;
    static final int CHAN_D0 = 4;
    static final int CHAN_D1 = 5;
    static final int CHAN_I = 6;
    static final int N_DEV_CHANS = 7;
    static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private String connType;
    private String ident;
    private int connTypeC;
    private Mmr mmr;
    private final double[] value = new double[7];

    public MMRDevice(String cType, String id) {
        this.connType = cType;
        this.ident = id;
    }

    public MMRDevice() {
    }

    protected void configure(Monitor mon) {
        Integer iConnType;
        super.configure(mon);
        if (this.connType == null) {
            mon.reportConfigError(this.getName(), "connType", "is missing");
        }
        if ((iConnType = typeMap.get(this.connType.toUpperCase())) == null) {
            mon.reportConfigError(this.getName(), "connType", "is invalid: " + this.connType);
        }
        if (this.ident == null) {
            mon.reportConfigError(this.getName(), "ident", "is missing");
        }
        this.connTypeC = iConnType;
        this.fullName = "MMR controller (" + this.ident + ")";
    }

    protected void initialize() {
        if (this.connTypeC < 0) {
            return;
        }
        try {
            if (!this.inited || this.mmr == null) {
                this.mmr = new Mmr();
                this.mmr.addListener((Mmr.Listener)this);
            }
            this.mmr.open(this.connTypeC, this.ident);
            this.setOnline(true);
            this.log.info((Object)("Connected to " + this.fullName));
        }
        catch (Exception e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + e));
            }
        }
        finally {
            this.inited = true;
        }
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 7) {
            this.mon.reportError(name, "hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(int hwChan, int type) {
        return this.online ? this.value[hwChan] : super.readChannel(hwChan, type);
    }

    public void setPowered(boolean on) {
        if (!on) {
            for (int j = 0; j < 7; ++j) {
                this.value[j] = 0.0;
            }
        }
    }

    public void setClosed(Exception e) {
        this.log.error((Object)("MMR controller error: " + e));
        this.setOnline(false);
    }

    public void processData(double[] data) {
        this.value[0] = data[1];
        this.value[1] = data[2];
        this.value[2] = data[3];
        this.value[3] = data[4];
        this.value[4] = data[5];
        this.value[5] = data[6];
        this.value[6] = data[7];
    }

    static {
        typeMap.put("FTDI", 1);
        typeMap.put("SERIAL", 2);
    }
}

