/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.agilent.DL34970;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class DL34970Device
extends Device {
    private static final int BAUD_RATE = 9600;
    private static final String tcTypes = "JKTERSBN";
    private static final Map<String, Ascii.ConnType> cTypeMap = new HashMap<String, Ascii.ConnType>();
    private static final Map<String, Integer> typeMap;
    private static final Map<String, DL34970.TcType> tcMap;
    private String connType;
    private String devcId;
    private int baudRate = 9600;
    private Ascii.ConnType connTypeC;
    private DL34970 dl;
    private int firstChan = 1000;
    private int lastChan = -1;
    private double[] chanValues;
    private boolean reallyOnline;

    public DL34970Device(String connType, String devcId, int baudRate) {
        this.connType = connType;
        this.devcId = devcId;
        this.baudRate = baudRate == 0 ? 9600 : baudRate;
    }

    public DL34970Device() {
    }

    protected void configure(Monitor mon) {
        super.configure(mon);
        if (this.connType == null) {
            mon.reportConfigError(this.getName(), "connType", "is missing");
        }
        this.connTypeC = cTypeMap.get(this.connType);
        if (this.connTypeC == null) {
            mon.reportConfigError(this.getName(), "connType", "is invalid: " + this.connType);
        }
        if (this.devcId == null) {
            mon.reportConfigError(this.getName(), "devcId", "is missing");
        }
        this.fullName = "DL34970 Logger (" + this.devcId + ")";
    }

    protected void initialize() {
        try {
            if (!this.inited || this.dl == null) {
                this.dl = new DL34970();
            }
            this.dl.open(this.connTypeC, this.devcId, this.baudRate);
            this.setOnline(true);
            this.initSensors();
            if (this.online && this.lastChan >= this.firstChan) {
                int[] chans = new int[this.lastChan + 1 - this.firstChan];
                for (int j = 0; j < chans.length; ++j) {
                    chans[j] = j + this.firstChan;
                }
                this.dl.setScanList(chans);
                this.reallyOnline = true;
            }
            this.log.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            if (this.dl != null) {
                this.close();
            }
        }
        finally {
            this.inited = true;
        }
    }

    protected void close() {
        this.reallyOnline = false;
        try {
            this.dl.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        int iSubtype;
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            this.mon.reportError(name, "type", (Object)type);
        }
        int n = iSubtype = subtype.length() == 1 ? tcTypes.indexOf(subtype) : -1;
        if (iSubtype < 0) {
            this.mon.reportError(name, "subtype", (Object)subtype);
        }
        this.firstChan = Math.min(hwChan, this.firstChan);
        this.lastChan = Math.max(hwChan, this.lastChan);
        return new int[]{iType, iSubtype};
    }

    protected void initChannel(int chan, int type, int subtype) {
        if (!this.online) {
            return;
        }
        try {
            if (type == 0) {
                this.dl.configTC(tcMap.get(tcTypes.substring(subtype, subtype + 1)), new int[]{chan});
            }
        }
        catch (DriverException e) {
            this.log.error((Object)("Error configuring " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    protected void readChannelGroup() {
        if (!this.reallyOnline) {
            return;
        }
        try {
            if (this.lastChan >= this.firstChan) {
                this.chanValues = this.dl.readData();
            }
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading data logger: " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    protected double readChannel(int hwChan, int type) {
        if (this.reallyOnline) {
            try {
                return this.chanValues[hwChan - this.firstChan];
            }
            catch (Exception e) {
                this.log.error((Object)("Error reading data logger: " + e));
                this.setOnline(false);
            }
        }
        return super.readChannel(hwChan, type);
    }

    static {
        cTypeMap.put("SERIAL", Ascii.ConnType.SERIAL);
        cTypeMap.put("FTDI", Ascii.ConnType.FTDI);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("TEMP", 0);
        tcMap = new HashMap<String, DL34970.TcType>();
        tcMap.put("J", DL34970.TcType.J);
        tcMap.put("K", DL34970.TcType.K);
        tcMap.put("T", DL34970.TcType.T);
        tcMap.put("E", DL34970.TcType.E);
        tcMap.put("R", DL34970.TcType.R);
        tcMap.put("S", DL34970.TcType.S);
        tcMap.put("B", DL34970.TcType.B);
        tcMap.put("N", DL34970.TcType.N);
    }
}

