import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.Subscale;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.MCCDevice;
import org.lsst.ccs.subsystem.refrig.DcsDevice;
import org.lsst.ccs.subsystem.refrig.WUDevice;
import org.lsst.ccs.subsystem.refrig.GP390Device;
import org.lsst.ccs.subsystem.refrig.DL34970Device;
import org.lsst.ccs.subsystem.refrig.Maq20Device;
import org.lsst.ccs.subsystem.refrig.PlutoDevice;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Channel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig-subscale"]

builder.main (Subscale, tickMillis: 10000, monMillis: 1000, checkMillis: 7500,
              cmprPowerLines: ["CmprLine"] as String[],
              loadPowerLines: ["LoadLine"] as String[],
              loadPowerDevc: "Power",
              alarmDsabChans: ["EvapTemp1"] as String[],
              loadTempChans: ["EvapTemp1"] as String[],
              tempCtrl: "TempCtrl") {

    TempCtrl   (TempControl, gain: 10, timeConst: 1000, smoothTime: 120,
                maxOutput: 100, awGain: 4, basePower: 0, tolerance: 0.05,
                updateTime: 30000)

    MaqCmpr    (Maq20Device, node: "192.168.128.100",
                serial: ["0098704-16", "0100762-06"] as String[])

    PlutoCmpr  (PlutoDevice, node: "192.168.0.100", areas: [1, 1, 1, 2, 1, 3])

    Mod1       (MCCDevice, devName: "TC_AI", serial: "00099707")

    Mod2       (MCCDevice, devName: "TEMP", serial: "018F9BA8")

    Mod3       (MCCDevice, devName: "TEMP", serial: "018F9BAA")

    Vac1       (GP390Device, serial: "AE01BAG1", address: 2)

    Logger     (DL34970Device, connType: "SERIAL", devcId: "/dev/ttyS0")

    Power      (DcsDevice, connType: "FTDI", ident: "A602LIHA")

    WattsCmpr  (WUDevice, serial: "AH02WF20")

    CmprLine   (Line, devcName: "PlutoCmpr", chan: 16)

    LoadLine   (Line, devcName: "Mod1", chan: 0)

    ResetLine  (Line, devcName: "PlutoCmpr", chan: 0)

    AlarmCmpr  (Alarm, description: "Trips off all power", eventParm: 0)

/*
    Chanxxx    (Channel, description: "",
                format: ".2f", units: "", devcName: "xxx, hwChan: 0,
                type: "", subtype: "", offset: 0, scale: 1,
                checkLo: "flag", limitLo: 0.0, dbandLo: 0.0, alarmLo: null,
                checkHi: "flag", limitHi: 0.0, dbandHi: 0.0, alarmHi: null)
*/

    CmprPower  (Channel, description: "Compressor\\Power", units: "Watts",
                devcName: "WattsCmpr", hwChan: 0, type: "POWER",
                checkHi: "alarm", alarmHi: "AlarmCmpr")

    CmpDisPrs  (Channel, description: "Discharge pressure", units: "Psig",
                devcName: "PlutoCmpr", hwChan: 1, type: "ADDREG:0",
		offset: -4.0, scale: 0.1,
                checkHi: "alarm", alarmHi: "AlarmCmpr")

    CmpSucPrs  (Channel, description: "Suction pressure", units: "Psig",
                devcName: "MaqCmpr", hwChan: 5, type: "VOLT:0", subtype: "V5",
		scale: 40.0,
                checkLo: "alarm", alarmLo: "AlarmCmpr")

    CmpDisTmp  (Channel, description: "Discharge temperature", units: "\u00b0C",
                devcName: "MaqCmpr", hwChan: 2, type: "TTC:1", subtype: "T220",
                checkHi: "alarm", alarmHi: "AlarmCmpr")

    CmpSepTmp  (Channel, description: "Separator temperature", units: "\u00b0C",
                devcName: "MaqCmpr", hwChan: 0, type: "TTC:1", subtype: "T220")

    CmpAmbTmp  (Channel, description: "Ambient temperature", units: "\u00b0C",
                devcName: "MaqCmpr", hwChan: 1, type: "TTC:1", subtype: "T220")

    CmprVolts  (Channel, description: "Line voltage", units: "Volts",
                devcName: "WattsCmpr", hwChan: 1, type: "POWER")

    CmprFreq   (Channel, description: "Line frequency", units: "Hz",
                devcName: "WattsCmpr", hwChan: 2, type: "POWER")

    CmpFlowLow (Channel, description: "Water flow low latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 29, type: "GLOBAL:1")

    CmprTempHi (Channel, description: "Temperature high latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 24, type: "GLOBAL:1")

    C3LiqdTmp  (Channel, description: "Heat Exchanger\\C3 liq capillary temperature",
                units: "\u00b0C",
                devcName: "Mod1", hwChan: 0, type: "TEMP", subtype: "TC:T")

    PreC3Tmp   (Channel, description: "Pre C3 temperature", units: "\u00b0C",
                devcName: "Mod2", hwChan: 6, type: "TEMP", subtype: "TC:T")

    PostC3Tmp  (Channel, description: "Post C3 temperature", units: "\u00b0C",
                devcName: "Mod2", hwChan: 7, type: "TEMP", subtype: "TC:T")

    PreC4Tmp   (Channel, description: "Pre C4 temperature", units: "\u00b0C",
                devcName: "Mod1", hwChan: 1, type: "TEMP", subtype: "TC:T")

    PostC4Tmp  (Channel, description: "Post C4 temperature", units: "\u00b0C",
                devcName: "Mod1", hwChan: 2, type: "TEMP", subtype: "TC:T")

    EvapVcrTmp (Channel, description: "Evaporator outlet VCR temp", units: "\u00b0C",
                devcName: "Mod2", hwChan: 5, type: "TEMP", subtype: "TC:T")

    HXRetnTmp  (Channel, description: "Return line temperature", units: "\u00b0C",
                devcName: "Mod1", hwChan: 3, type: "TEMP", subtype: "TC:T")

    AprnAmbTmp (Channel, description: "Ambient temperature", units: "\u00b0C",
                devcName: "Mod2", hwChan: 3, type: "TEMP", subtype: "TC:T")

    HexVapPrs  (Channel, description: "Vapor supply pressure", units: "Psig",
                devcName: "Mod1", hwChan: 5, type: "VOLTS", subtype: "1.25V",
		offset: 4.84, scale: 5000.0,
                checkHi: "alarm", alarmHi: "AlarmCmpr")

    HexLiqPrs  (Channel, description: "Liquid supply pressure", units: "Psig",
                devcName: "Mod1", hwChan: 4, type: "VOLTS", subtype: "1.25V",
		offset: 1.71, scale: 5000.0,
                checkHi: "alarm", alarmHi: "AlarmCmpr")

    HexPrsDiff (Channel, description: "Vapor/liquid delta P", units: "Psi",
                devcName: null, type: "DIFF", subtype: "HexLiqPrs:HexVapPrs",
		checkLo: "none", checkHi: "none")

    HexSucPrs  (Channel, description: "Return pressure", units: "Psig",
                devcName: "Mod1", hwChan: 7, type: "VOLTS", subtype: "1.25V",
		offset: -0.05, scale: 1000.0)

    HexVacuum  (Channel, description: "Vacuum pressure", format: ".3G", units: "Torr",
                devcName: "Vac1", hwChan: 0)

    LoadTmp1   (Channel, description: "Cryostat\\Load temperature 1 RTD", units: "\u00b0C",
                devcName: "Mod3", hwChan: 0, type: "TEMP", subtype: "RTD:3WIRE")

    LoadTmp2   (Channel, description: "Load temperature 2 RTD", units: "\u00b0C",
                devcName: "Mod3", hwChan: 2, type: "TEMP", subtype: "RTD:3WIRE")

    LoadTmp3   (Channel, description: "Load temperature 3 RTD", units: "\u00b0C",
                devcName: "Mod2", hwChan: 0, type: "TEMP", subtype: "RTD:3WIRE")

    LoadTmp4   (Channel, description: "Load temperature 4 RTD", units: "\u00b0C",
                devcName: "Mod3", hwChan: 4, type: "TEMP", subtype: "RTD:3WIRE")

    LoadTmp5   (Channel, description: "Load temperature 5 RTD", units: "\u00b0C",
                devcName: "Mod3", hwChan: 6, type: "TEMP", subtype: "RTD:3WIRE")

    LoadPower  (Channel, description: "Heat load power", units: "Watts",
                devcName: "Power", hwChan: 0, type: "POWER")

    LoadVolts  (Channel, description: "Heat load voltage", units: "Volts",
                devcName: "Power", hwChan: 1, type: "POWER")

    EvapTemp1  (Channel, description: "Evaporator temperature 1", units: "\u00b0C",
                devcName: "Mod2", hwChan: 2, type: "TEMP", subtype: "TC:T",
                checkLo: "alarm", alarmLo: "AlarmCmpr",
                checkHi: "alarm", alarmHi: "AlarmCmpr")

    EvapTemp2  (Channel, description: "Evaporator temperature 2", units: "\u00b0C",
                devcName: "Mod2", hwChan: 4, type: "TEMP", subtype: "TC:T")

    EvapDLTC01 (Channel, description: "DL TC 01 Evaporator", units: "\u00b0C",
                devcName: "Logger", hwChan: 101, type: "TEMP", subtype: "T")

    EvapDLTC02 (Channel, description: "DL TC 02 Evaporator", units: "\u00b0C",
                devcName: "Logger", hwChan: 102, type: "TEMP", subtype: "T")

    EvapDLTC03 (Channel, description: "DL TC 03 Evaporator", units: "\u00b0C",
                devcName: "Logger", hwChan: 103, type: "TEMP", subtype: "T")

    EvapDLTC04 (Channel, description: "DL TC 04 Evaporator", units: "\u00b0C",
                devcName: "Logger", hwChan: 104, type: "TEMP", subtype: "T")

    EvapDLTC05 (Channel, description: "DL TC 05 Evaporator", units: "\u00b0C",
                devcName: "Logger", hwChan: 105, type: "TEMP", subtype: "T")

    Running    (Channel, description: "Heater Control Chassis\\Running state", format: ".0f",
                devcName: "Mod1", hwChan: 6, type: "SWITCH")

    Interlock  (Channel, description: "Interlock state", format: ".0f",
                devcName: "Mod1", hwChan: 2, type: "SWITCH")

    ThermRelay (Channel, description: "Thermal relay state", format: ".0f",
                devcName: "Mod1", hwChan: 3, type: "SWITCH")

    LoadEnable (Channel, description: "Load enable state", format: ".0f",
                devcName: "Mod1", hwChan: 4, type: "SWITCH")

    V5Power    (Channel, description: "5-Volt power state", format: ".0f",
                devcName: "Mod1", hwChan: 5, type: "SWITCH")

    XTC06CmpWtrSupp (Channel, description: "Compressor TCs\\DL TC 06 Water Supply", units: "\u00b0C",
                devcName: "Logger", hwChan: 106, type: "TEMP", subtype: "T")

    XTC07CmpWtrRetn (Channel, description: "DL TC 07 Water Return", units: "\u00b0C",
                devcName: "Logger", hwChan: 107, type: "TEMP", subtype: "T")

    XTC08CmpLigSupp (Channel, description: "DL TC 08 C3 Liquid Supply", units: "\u00b0C",
                devcName: "Logger", hwChan: 108, type: "TEMP", subtype: "T")

    XTC09CmpVapSupp (Channel, description: "DL TC 09 C4 Vapor Supply", units: "\u00b0C",
                devcName: "Logger", hwChan: 109, type: "TEMP", subtype: "T")

    XTC10CmpRtnLine (Channel, description: "DL TC 10 Return Line", units: "\u00b0C",
                devcName: "Logger", hwChan: 110, type: "TEMP", subtype: "T")

    XTC11CmpOilSep (Channel, description: "DL TC 11 Oil Separator", units: "\u00b0C",
                devcName: "Logger", hwChan: 111, type: "TEMP", subtype: "T")

    XTC12CmpCondIn (Channel, description: "DL TC 12 Condenser Inlet", units: "\u00b0C",
                devcName: "Logger", hwChan: 112, type: "TEMP", subtype: "T")

    XTC13CmpCondOut (Channel, description: "DL TC 13 Condenser Outlet", units: "\u00b0C",
                devcName: "Logger", hwChan: 113, type: "TEMP", subtype: "T")

    XTC14CmpBody (Channel, description: "DL TC 14 Compressor Body", units: "\u00b0C",
                devcName: "Logger", hwChan: 114, type: "TEMP", subtype: "T")

    XTC15CmpOilSump (Channel, description: "DL TC 15 Oil Sump", units: "\u00b0C",
                devcName: "Logger", hwChan: 115, type: "TEMP", subtype: "T")

    XTC16Spare (Channel, description: "Extra TCs\\DL TC 16", units: "\u00b0C",
                devcName: "Logger", hwChan: 116, type: "TEMP", subtype: "T")

    XTC17Spare (Channel, description: "DL TC 17", units: "\u00b0C",
                devcName: "Logger", hwChan: 117, type: "TEMP", subtype: "T")

    XTC18Spare (Channel, description: "DL TC 18", units: "\u00b0C",
                devcName: "Logger", hwChan: 118, type: "TEMP", subtype: "T")

    XTC19Spare (Channel, description: "DL TC 19", units: "\u00b0C",
                devcName: "Logger", hwChan: 119, type: "TEMP", subtype: "T")

    XTC20Spare (Channel, description: "DL TC 20", units: "\u00b0C",
                devcName: "Logger", hwChan: 120, type: "TEMP", subtype: "T")
/*
    Cmpr24Volt (Channel, description: "Cmpr Control Chassis\\24V power supply", units: "Volts",
                devcName: "PlutoCmpr", hwChan: 1, type: "ADDREG:1")

    CmprOnSwch (Channel, description: "ON switch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 6, type: "GLOBAL:1")

    CmprPermit (Channel, description: "CCS permit", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 20, type: "GLOBAL:1")

    CmprEnable (Channel, description: "Enable", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 31, type: "GLOBAL:1")

    CmprPwrOn  (Channel, description: "Power on", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 16, type: "GLOBAL:1")

    CmpExtPerm (Channel, description: "External permit", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 5, type: "GLOBAL:1")

    CmpNoExtPrm (Channel, description: "External permit missing", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 30, type: "GLOBAL:1")

    CmpFlowSwi (Channel, description: "Water flow switch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 0, type: "GLOBAL:1")

    CmprTempOk (Channel, description: "Temperature valid", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 23, type: "GLOBAL:1")

    CmpDisPrsOk (Channel, description: "Discharge pressure valid", format: ".0f",
                 devcName: "PlutoCmpr", hwChan: 25, type: "GLOBAL:1")

    CmpDisPrsHi (Channel, description: "Discharge pressure high latch", format: ".0f",
                 devcName: "PlutoCmpr", hwChan: 26, type: "GLOBAL:1")
*/
}
