import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.Subscale;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.MCCDevice;
import org.lsst.ccs.subsystem.refrig.DcsDevice;
import org.lsst.ccs.subsystem.refrig.WUDevice;
import org.lsst.ccs.subsystem.refrig.GP390Device;
import org.lsst.ccs.subsystem.refrig.DL34970Device;
import org.lsst.ccs.subsystem.refrig.Maq20Device;
import org.lsst.ccs.subsystem.refrig.PlutoDevice;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Channel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig-subscale"]

builder.
    main (Subscale, argMap("main", 10000, 5000, "", ["CmprLine"],
                           ["LoadLine"], "Power", ["EvapTemp1"],
                           ["EvapTemp1"], "TempCtrl")) {

        TempCtrl   (TempControl, argMap(10, 1000, 120, 100, 4, 0, 0.05, 30000))

        MaqCmpr    (Maq20Device, argMap("192.168.128.100",
                                        ["0098704-16", "0100762-06"]))

        PlutoCmpr  (PlutoDevice, argMap("192.168.0.100",
                                        [1, 1, 1, 2, 1, 3]))

        Mod1       (MCCDevice, argMap("TC_AI", "00099707"))

        Mod2       (MCCDevice, argMap("TEMP", "018F9BA8"))

        Mod3       (MCCDevice, argMap("TEMP", "018F9BAA"))

        Vac1       (GP390Device, argMap("AE01BAG1", 2))

        Logger     (DL34970Device, argMap("SERIAL", "/dev/ttyS0", 0))

        Power      (DcsDevice, argMap("FTDI", "A602LIHA"))

        WattsCmpr  (WUDevice, argMap(null, "AH02WF20"))

        CmprLine   (Line, argMap("PlutoCmpr", 16, null, 0))

        LoadLine   (Line, argMap("Mod1", 0, null, 0))

        ResetLine  (Line, argMap("PlutoCmpr", 0, null, 0))

        AlarmCmpr  (Alarm, argMap("Trips off all power", null, 0))

        CmprPower  (Channel,
                    argMap("Compressor\\Power", "Watts",
                           "WattsCmpr", 0, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        CmpDisPrs  (Channel,
                    argMap("Discharge pressure", "Psig",
                           "PlutoCmpr", 1, "ADDREG:0", null, -4.0, 0.1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        CmpSucPrs  (Channel,
                    argMap("Suction pressure", "Psig",
                           "MaqCmpr", 5, "VOLT:0", "V5", 0.0, 40.0,
                           "alarm", aDbl(limitLo, 0.0), 0.0, "AlarmCmpr",
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpDisTmp  (Channel,
                    argMap("Discharge temperature", "\u00b0C",
                           "MaqCmpr", 2, "TTC:1", "T220", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        CmpSepTmp  (Channel,
                    argMap("Separator temperature", "\u00b0C",
                           "MaqCmpr", 0, "TTC:1", "T220", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpAmbTmp  (Channel,
                    argMap("Ambient temperature", "\u00b0C",
                           "MaqCmpr", 1, "TTC:1", "T220", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmprVolts  (Channel,
                    argMap("Line voltage", "Volts",
                           "WattsCmpr", 1, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmprFreq   (Channel,
                    argMap("Line frequency", "Hz",
                           "WattsCmpr", 2, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpFlowLow (Channel,
                    argMap("Water flow low latch", ".0f", "",
                           "PlutoCmpr", 29, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmprTempHi (Channel,
                    argMap("Temperature high latch", ".0f", "",
                           "PlutoCmpr", 24, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        C3LiqdTmp  (Channel,
                    argMap("Heat Exchanger\\C3 liq capillary temperature",
                           "\u00b0C",
                           "Mod1", 0, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PreC3Tmp   (Channel,
                    argMap("Pre C3 temperature", "\u00b0C",
                           "Mod2", 6, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PostC3Tmp  (Channel,
                    argMap("Post C3 temperature", "\u00b0C",
                           "Mod2", 7, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PreC4Tmp   (Channel,
                    argMap("Pre C4 temperature", "\u00b0C",
                           "Mod1", 1, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PostC4Tmp  (Channel,
                    argMap("Post C4 temperature", "\u00b0C",
                           "Mod1", 2, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        EvapVcrTmp (Channel,
                    argMap("Evaporator outlet VCR temp", "\u00b0C",
                           "Mod2", 5, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HXRetnTmp  (Channel,
                    argMap("Return line temperature", "\u00b0C",
                           "Mod1", 3, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        AprnAmbTmp (Channel,
                    argMap("Ambient temperature", "\u00b0C",
                           "Mod2", 3, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexVapPrs  (Channel,
                    argMap("Vapor supply pressure", "Psig",
                           "Mod1", 5, "VOLTS", "1.25V", 4.84, 5000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        HexLiqPrs  (Channel,
                    argMap("Liquid supply pressure", "Psig",
                           "Mod1", 4, "VOLTS", "1.25V", 1.71, 5000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        HexPrsDiff (Channel,
                    argMap("Vapor/liquid delta P", "Psi",
                           null, 0, "DIFF", "HexLiqPrs:HexVapPrs", 0, 0,
                           "none", aDbl(limitLo, 0.0), 0.0, null,
                           "none", aDbl(limitHi, 0.0), 0.0, null))

        HexSucPrs  (Channel,
                    argMap("Return pressure", "Psig",
                           "Mod1", 7, "VOLTS", "1.25V", -0.05, 1000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexVacuum  (Channel,
                    argMap("Vacuum pressure", ".3G", "Torr",
                           "Vac1", 0, "", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadTmp1   (Channel,
                    argMap("Cryostat\\Load temperature 1 RTD", "\u00b0C",
                           "Mod3", 0, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadTmp2   (Channel,
                    argMap("Load temperature 2 RTD", "\u00b0C",
                           "Mod3", 2, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadTmp3   (Channel,
                    argMap("Load temperature 3 RTD", "\u00b0C",
                           "Mod2", 0, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadTmp4   (Channel,
                    argMap("Load temperature 4 RTD", "\u00b0C",
                           "Mod3", 4, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadTmp5   (Channel,
                    argMap("Load temperature 5 RTD", "\u00b0C",
                           "Mod3", 6, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadPower  (Channel,
                    argMap("Heat load power", "Watts",
                           "Power", 0, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadVolts  (Channel,
                    argMap("Heat load voltage", "Volts",
                           "Power", 1, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        EvapTemp1  (Channel,
                    argMap("Evaporator temperature 1", "\u00b0C",
                           "Mod2", 2, "TEMP", "TC:T", 0.0, 1.0,
                           "alarm", aDbl(limitLo, 0.0), 0.0, "AlarmCmpr",
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        EvapTemp2  (Channel,
                    argMap("Evaporator temperature 2", "\u00b0C",
                           "Mod2", 4, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        EvapDLTC01 (Channel,
                    argMap("DL TC 01 Evaporator", "\u00b0C",
                           "Logger", 101, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        EvapDLTC02 (Channel,
                    argMap("DL TC 02 Evaporator", "\u00b0C",
                           "Logger", 102, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        EvapDLTC03 (Channel,
                    argMap("DL TC 03 Evaporator", "\u00b0C",
                           "Logger", 103, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        EvapDLTC04 (Channel,
                    argMap("DL TC 04 Evaporator", "\u00b0C",
                           "Logger", 104, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        EvapDLTC05 (Channel,
                    argMap("DL TC 05 Evaporator", "\u00b0C",
                           "Logger", 105, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        Running    (Channel,
                    argMap("Heater Control Chassis\\Running state", ".0f", "",
                           "Mod1", 6, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        Interlock  (Channel,
                    argMap("Interlock state", ".0f", "",
                           "Mod1", 2, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        ThermRelay (Channel,
                    argMap("Thermal relay state", ".0f", "",
                           "Mod1", 3, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        LoadEnable (Channel,
                    argMap("Load enable state", ".0f", "",
                           "Mod1", 4, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        V5Power    (Channel,
                    argMap("5-Volt power state", ".0f", "",
                           "Mod1", 5, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        XTC06CmpWtrSupp (Channel,
                    argMap("Compressor TCs\\DL TC 06 Water Supply", "\u00b0C",
                           "Logger", 106, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC07CmpWtrRetn (Channel,
                    argMap("DL TC 07 Water Return", "\u00b0C",
                           "Logger", 107, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC08CmpLigSupp (Channel,
                    argMap("DL TC 08 C3 Liquid Supply", "\u00b0C",
                           "Logger", 108, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC09CmpVapSupp (Channel,
                    argMap("DL TC 09 C4 Vapor Supply", "\u00b0C",
                           "Logger", 109, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC10CmpRtnLine (Channel,
                    argMap("DL TC 10 Return Line", "\u00b0C",
                           "Logger", 110, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC11CmpOilSep (Channel,
                    argMap("DL TC 11 Oil Separator", "\u00b0C",
                           "Logger", 111, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC12CmpCondIn (Channel,
                    argMap("DL TC 12 Condenser Inlet", "\u00b0C",
                           "Logger", 112, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC13CmpCondOut (Channel,
                    argMap("DL TC 13 Condenser Outlet", "\u00b0C",
                           "Logger", 113, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC14CmpBody (Channel,
                    argMap("DL TC 14 Compressor Body", "\u00b0C",
                           "Logger", 114, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC15CmpOilSump (Channel,
                    argMap("DL TC 15 Oil Sump", "\u00b0C",
                           "Logger", 115, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC16Spare (Channel,
                    argMap("Extra TCs\\DL TC 16", "\u00b0C",
                           "Logger", 116, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC17Spare (Channel,
                    argMap("DL TC 17", "\u00b0C",
                           "Logger", 117, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC18Spare (Channel,
                    argMap("DL TC 18", "\u00b0C",
                           "Logger", 118, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC19Spare (Channel,
                    argMap("DL TC 19", "\u00b0C",
                           "Logger", 119, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        XTC20Spare (Channel,
                    argMap("DL TC 20", "\u00b0C",
                           "Logger", 120, "TEMP", "T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))
/*
        Cmpr24Volt (Channel,
                    argMap("Cmpr Control Chassis\\24V power supply", "Volts",
                           "PlutoCmpr", 1, "ADDREG:1", null, 0.0, 0.1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmprOnSwch (Channel,
                    argMap("ON switch", ".0f", "",
                           "PlutoCmpr", 6, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmprPermit (Channel,
                    argMap("CCS permit", ".0f", "",
                           "PlutoCmpr", 20, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmprEnable (Channel,
                    argMap("Enable", ".0f", "",
                           "PlutoCmpr", 31, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmprPwrOn  (Channel,
                    argMap("Power on", ".0f", "",
                           "PlutoCmpr", 16, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpExtPerm (Channel,
                    argMap("External permit", ".0f", "",
                           "PlutoCmpr", 5, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpNoExtPrm (Channel,
                    argMap("External permit missing", ".0f", "",
                           "PlutoCmpr", 30, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpFlowSwi (Channel,
                    argMap("Water flow switch", ".0f", "",
                           "PlutoCmpr", 0, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmprTempOk (Channel,
                    argMap("Temperature valid", ".0f", "",
                           "PlutoCmpr", 23, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpDisPrsOk (Channel,
                    argMap("Discharge pressure valid", ".0f", "",
                           "PlutoCmpr", 25, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpDisPrsHi (Channel,
                    argMap("Discharge pressure high latch", ".0f", "",
                           "PlutoCmpr", 26, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))
*/
    }
