/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.subsystem.monitor.Channel;
import org.lsst.ccs.subsystem.refrig.PIController;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.utilities.logging.Logger;

public class TempControl
extends ConfigurableComponent {
    private final double gain;
    private final double timeConst;
    private final double smoothTime;
    private final double maxOutput;
    private final double minOutput = 0.0;
    private final double maxInput = 100.0;
    private final double minInput = -200.0;
    private final double awGain;
    private final double basePower;
    private final double tolerance;
    private final PIController pic;
    private final int updateTime;
    private PowerDevice powerDevc;
    private List<Channel> tempChans;
    private double[] temps;
    private double lastPower;
    private boolean running;
    private Timer loopTimer;
    private Logger log;

    public TempControl(double gain, double timeConst, double smoothTime, double maxOutput, double awGain, double basePower, double tolerance, int updateTime) {
        this.gain = gain;
        this.timeConst = timeConst;
        this.smoothTime = smoothTime;
        this.maxOutput = maxOutput;
        this.awGain = awGain;
        this.basePower = basePower;
        this.tolerance = tolerance;
        this.updateTime = updateTime;
        this.pic = new PIController(gain, timeConst);
        this.pic.setSmoothTime(smoothTime);
        this.pic.setAwGain(awGain);
        this.pic.setBaseOutput(basePower);
        this.pic.setInputRange(-200.0, 100.0);
        this.pic.setOutputRange(0.0, maxOutput);
        this.pic.setTolerance(tolerance);
    }

    public void initialize(List tempChans, PowerDevice powerDevc, Logger log) {
        this.tempChans = tempChans;
        this.powerDevc = powerDevc;
        this.log = log;
        this.temps = new double[tempChans.size()];
    }

    public void setTemp(double value) {
        this.pic.setSetpoint(value);
    }

    public void reset() {
        this.pic.reset();
    }

    public void restart() {
        this.start(this.lastPower);
    }

    public void start(double power) {
        if (this.running) {
            return;
        }
        this.running = true;
        this.pic.reset();
        this.pic.setIntegral(power - this.basePower);
        this.loopTimer = new Timer(true);
        this.loopTimer.schedule((TimerTask)new Iterate(), 0L, (long)this.updateTime);
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.loopTimer.cancel();
    }

    private class Iterate
    extends TimerTask {
        private Iterate() {
        }

        @Override
        public void run() {
            int index = 0;
            for (Channel tempChan : TempControl.this.tempChans) {
                ((TempControl)TempControl.this).temps[index++] = tempChan.getValue();
            }
            double tod = (double)System.currentTimeMillis() / 1000.0;
            TempControl.this.lastPower = TempControl.this.pic.performPI(TempControl.this.temps, tod);
            TempControl.this.powerDevc.setPower(0, TempControl.this.lastPower);
        }
    }
}

