/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.monitor.Device;

public abstract class PowerDevice
extends Device {
    private static final double MIN_VOLTAGE = 10.0;
    private final Map<Integer, PowerState> states = new HashMap<Integer, PowerState>();

    public void enableOutput(int chan, boolean enable) {
        this.getPowerState(chan).enabled = enable;
        this.setOutput(chan, enable);
    }

    public void setPower(int chan, double value) {
        double prevOhms;
        int j;
        double ohms;
        boolean okay;
        PowerState state = this.getPowerState(chan);
        if (!state.enabled) {
            return;
        }
        StringBuilder msg = new StringBuilder("Setting power to ");
        msg.append((float)value);
        ArrayList<Float> voltages = new ArrayList<Float>();
        state.power = value;
        if (state.resistance == 0.0) {
            okay = false;
            ohms = 0.0;
            j = 0;
            while (j < 5 && !okay) {
                prevOhms = ohms;
                this.setVoltage(chan, 10.0);
                double amps = this.readCurrent(chan);
                ohms = amps <= 0.0 ? 0.0 : this.readVoltage(chan) / amps;
                okay = this.areClose(ohms, prevOhms);
                ++j;
            }
            if (okay && ohms != 0.0) {
                state.resistance = ohms;
            } else {
                this.log.error((Object)"Unable to determine load resistance", new String[0]);
                return;
            }
        }
        okay = false;
        ohms = 0.0;
        j = 0;
        while (j < 5 && !okay) {
            prevOhms = ohms;
            double volts = Math.sqrt(state.power * state.resistance);
            this.setVoltage(chan, volts);
            voltages.add(Float.valueOf((float)volts));
            double amps = this.readCurrent(chan);
            ohms = amps <= 0.0 ? 0.0 : this.readVoltage(chan) / amps;
            okay = this.areClose(ohms, state.resistance) || this.areClose(ohms, prevOhms);
            ++j;
        }
        if (okay) {
            if (ohms != 0.0) {
                state.resistance = ohms;
                double volts = Math.sqrt(state.power * state.resistance);
                this.setVoltage(chan, volts);
                voltages.add(Float.valueOf((float)volts));
            }
        } else {
            this.log.error((Object)"Unable to set power consistently", new String[0]);
        }
        msg.append(": voltages =");
        for (Float v : voltages) {
            msg.append(" ");
            msg.append(v);
        }
        this.log.info((Object)msg, new String[0]);
    }

    private boolean areClose(double val1, double val2) {
        if (val2 == 0.0) {
            return val1 == 0.0;
        }
        double error = (val1 - val2) / val2;
        return error > -0.05 && error < 0.05;
    }

    protected void setOnline(boolean online) {
        super.setOnline(online);
        if (online) {
            for (Integer chan : this.states.keySet()) {
                this.setPower(chan, this.states.get(chan).power);
            }
        }
    }

    public abstract void setVoltage(int var1, double var2);

    public abstract void setCurrent(int var1, double var2);

    public abstract void setOutput(int var1, boolean var2);

    public abstract double readVoltage(int var1);

    public abstract double readCurrent(int var1);

    public abstract boolean getOutput(int var1);

    private PowerState getPowerState(int chan) {
        PowerState state = this.states.get(chan);
        if (state == null) {
            state = new PowerState();
            this.states.put(chan, state);
        }
        return state;
    }

    public static class PowerState {
        private double resistance;
        private double power;
        private boolean enabled;
    }
}

