/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class Maq20Device
extends Device {
    private static final Map<String, Integer> ttcRangeMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> jtcRangeMap;
    private static final Map<String, Integer> ktcRangeMap;
    private static final Map<String, Integer> rstcRangeMap;
    private static final Map<String, Integer> rtdRangeMap;
    private static final Map<String, Integer> voltRangeMap;
    private static final Map<String, Integer> mvoltRangeMap;
    private static final Map<String, Integer> ampRangeMap;
    private static final Map<String, ModuleDef> typeMap;
    String node;
    String[] serial;
    Maq20 maq;
    int nModule;

    static {
        ttcRangeMap.put("T400", 0);
        ttcRangeMap.put("T220", 1);
        jtcRangeMap = new HashMap<String, Integer>();
        jtcRangeMap.put("J760", 0);
        jtcRangeMap.put("J393", 1);
        jtcRangeMap.put("J199", 2);
        ktcRangeMap = new HashMap<String, Integer>();
        ktcRangeMap.put("K1350", 0);
        ktcRangeMap.put("K651", 1);
        ktcRangeMap.put("K332", 2);
        rstcRangeMap = new HashMap<String, Integer>();
        rstcRangeMap.put("R1750", 0);
        rstcRangeMap.put("R990", 1);
        rstcRangeMap.put("S1750", 2);
        rstcRangeMap.put("S970", 3);
        rtdRangeMap = new HashMap<String, Integer>();
        rtdRangeMap.put("R850", 0);
        rtdRangeMap.put("R200", 1);
        rtdRangeMap.put("R100", 2);
        voltRangeMap = new HashMap<String, Integer>();
        voltRangeMap.put("V60", 0);
        voltRangeMap.put("V40", 1);
        voltRangeMap.put("V20", 2);
        voltRangeMap.put("V10", 3);
        voltRangeMap.put("V5", 4);
        mvoltRangeMap = new HashMap<String, Integer>();
        mvoltRangeMap.put("V2", 0);
        mvoltRangeMap.put("V1", 1);
        mvoltRangeMap.put("MV250", 2);
        mvoltRangeMap.put("MV100", 3);
        mvoltRangeMap.put("MV50", 4);
        ampRangeMap = new HashMap<String, Integer>();
        ampRangeMap.put("MA0_20", 0);
        ampRangeMap.put("MA4_20", 1);
        typeMap = new HashMap<String, ModuleDef>();
        typeMap.put("JTC", new ModuleDef(0, jtcRangeMap));
        typeMap.put("KTC", new ModuleDef(1, ktcRangeMap));
        typeMap.put("TTC", new ModuleDef(2, ttcRangeMap));
        typeMap.put("RSTC", new ModuleDef(3, rstcRangeMap));
        typeMap.put("RTD", new ModuleDef(4, rtdRangeMap));
        typeMap.put("VOLT", new ModuleDef(6, voltRangeMap));
        typeMap.put("MVOLT", new ModuleDef(5, mvoltRangeMap));
        typeMap.put("AMP", new ModuleDef(8, ampRangeMap));
    }

    public Maq20Device(String nodeName, List serialNo) {
        this.node = nodeName;
        this.serial = new String[serialNo.size()];
        int j = 0;
        while (j < this.serial.length) {
            this.serial[j] = (String)serialNo.get(j);
            ++j;
        }
    }

    protected void configure(Monitor mon) {
        super.configure(mon);
        this.fullName = "Maq20 system (" + this.node + ")";
    }

    protected void initialize() {
        block9: {
            try {
                try {
                    if (!this.inited || this.maq == null) {
                        this.maq = new Maq20();
                    }
                    this.maq.open(0, this.node);
                    this.maq.register(this.serial);
                    this.nModule = this.serial.length;
                    this.setOnline(true);
                    this.initSensors();
                    this.setOutputLines();
                    String message = "Connected to " + this.fullName;
                    if (!this.inited) {
                        this.log.info((Object)message, new String[0]);
                        break block9;
                    }
                    this.log.error((Object)message, new String[0]);
                }
                catch (DriverException e) {
                    if (!this.inited) {
                        this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
                    }
                    if (this.maq != null) {
                        this.close();
                    }
                    this.inited = true;
                }
            }
            finally {
                this.inited = true;
            }
        }
    }

    protected void close() {
        try {
            this.maq.close();
        }
        catch (DriverException driverException) {}
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iRange;
        int modId;
        ModuleDef mDef;
        Integer iType = null;
        Map rMap = null;
        String[] typeFields = type.split(":", -1);
        if (typeFields.length == 2 && (mDef = typeMap.get(typeFields[0].toUpperCase())) != null) {
            iType = mDef.type;
            rMap = mDef.rangeMap;
        }
        try {
            modId = Integer.decode(typeFields[1]);
        }
        catch (NumberFormatException numberFormatException) {
            modId = -1;
        }
        if (iType == null || modId < 0 || modId >= 24) {
            this.mon.reportError(name, "type", (Object)type);
        }
        if ((iRange = (Integer)rMap.get(subtype.toUpperCase())) == null) {
            this.mon.reportError(name, "range", (Object)subtype);
        }
        return new int[]{iType << 8 | modId + 1, iRange};
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        if (!this.online) {
            return;
        }
        int mod = type & 0xFF;
        int modType = type >> 8;
        int range = subtype;
        try {
            int mType;
            if (!this.maq.moduleExists(mod)) {
                this.mon.reportError(name, "module ID", (Object)(mod - 1));
            }
            if (!(modType == (mType = this.maq.getModuleType(mod)) || modType == 6 && mType == 7 || modType == 8 && mType == 9)) {
                this.mon.reportError(name, "module type", (Object)modType);
            }
            if (hwChan < 0 || hwChan >= this.maq.getNumInputs(mod)) {
                this.mon.reportError(name, "channel", (Object)hwChan);
            }
            if (range < 0 || range >= this.maq.getNumRanges(mod)) {
                this.mon.reportError(name, "range", (Object)range);
            }
            this.maq.enable(mod, hwChan, true);
            this.maq.setRange(mod, hwChan, range);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error configuring " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
        }
        catch (Exception exception) {
            this.dropChannel(id);
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.online) {
            try {
                value = this.maq.readValue(type & 0xFF, hwChan);
            }
            catch (DriverException e) {
                this.log.error((Object)("Error reading channel: " + (Object)((Object)e)), new String[0]);
                this.setOnline(false);
            }
        }
        return value;
    }

    private static class ModuleDef {
        int type;
        Map rangeMap;

        ModuleDef(int type, Map rangeMap) {
            this.type = type;
            this.rangeMap = rangeMap;
        }
    }
}

