/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mks.GP390;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class GP390Device
extends Device {
    private static final int BAUD_RATE = 19200;
    private final String serial;
    private final int address;
    private GP390 gp;

    public GP390Device(String serialNo, int addr) {
        this.serial = serialNo;
        this.address = addr;
    }

    protected void configure(Monitor mon) {
        super.configure(mon);
        this.fullName = "GP390 vacuum gauge (" + this.serial + ":" + this.address + ")";
    }

    protected void initialize() {
        block9: {
            try {
                try {
                    if (!this.inited || this.gp == null) {
                        this.gp = new GP390();
                    }
                    this.gp.open(GP390.ConnType.FTDI, this.serial, 19200, this.address);
                    this.gp.setLock(false);
                    this.gp.setPressureUnit(0);
                    this.gp.setLock(true);
                    this.setOnline(true);
                    this.initSensors();
                    String message = "Connected to " + this.fullName;
                    if (!this.inited) {
                        this.log.info((Object)message, new String[0]);
                        break block9;
                    }
                    this.log.error((Object)message, new String[0]);
                }
                catch (DriverException e) {
                    if (!this.inited) {
                        this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
                    }
                    if (this.gp != null) {
                        this.close();
                    }
                    this.inited = true;
                }
            }
            finally {
                this.inited = true;
            }
        }
    }

    protected void close() {
        try {
            this.gp.close();
        }
        catch (DriverException driverException) {}
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.online) {
            try {
                value = this.gp.readPressure();
            }
            catch (DriverException e) {
                this.log.error((Object)("Error reading pressure: " + (Object)((Object)e)), new String[0]);
                this.setOnline(false);
            }
        }
        return value;
    }
}

