/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.agilent.DL34970;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class DL34970Device
extends Device {
    private static final int BAUD_RATE = 9600;
    private static final String tcTypes = "JKTERSBN";
    private static final Map<String, Integer> cTypeMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> typeMap;
    private static final Map<String, DL34970.TcType> tcMap;
    private final String connTypeS;
    private final String devcId;
    private final int baudRate;
    private int connType;
    private DL34970 dl;
    private int firstChan = 1000;
    private int lastChan = -1;
    private double[] chanValues;

    static {
        cTypeMap.put("SERIAL", 2);
        cTypeMap.put("FTDI", 1);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("TEMP", 0);
        tcMap = new HashMap<String, DL34970.TcType>();
        tcMap.put("J", DL34970.TcType.J);
        tcMap.put("K", DL34970.TcType.K);
        tcMap.put("T", DL34970.TcType.T);
        tcMap.put("E", DL34970.TcType.E);
        tcMap.put("R", DL34970.TcType.R);
        tcMap.put("S", DL34970.TcType.S);
        tcMap.put("B", DL34970.TcType.B);
        tcMap.put("N", DL34970.TcType.N);
    }

    public DL34970Device(String connType, String devcId, int baudRate) {
        this.connTypeS = connType;
        this.devcId = devcId;
        this.baudRate = baudRate == 0 ? 9600 : baudRate;
    }

    protected void configure(Monitor mon) {
        super.configure(mon);
        this.fullName = "DL34970 Logger (" + this.devcId + ")";
        Integer iConnType = cTypeMap.get(this.connTypeS);
        if (iConnType == null) {
            this.connType = -1;
            try {
                mon.reportError(this.getName(), "connection type", (Object)this.connTypeS);
            }
            catch (Exception exception) {}
        } else {
            this.connType = iConnType;
        }
    }

    protected void initialize() {
        block13: {
            if (this.connType < 0) {
                return;
            }
            try {
                try {
                    if (!this.inited || this.dl == null) {
                        this.dl = new DL34970();
                    }
                    this.dl.open(this.connType, this.devcId, this.baudRate);
                    this.setOnline(true);
                    this.initSensors();
                    if (this.lastChan >= this.firstChan) {
                        if (this.chanValues == null) {
                            this.chanValues = new double[this.lastChan + 1 - this.firstChan];
                        }
                        int[] chans = new int[this.chanValues.length];
                        int j = 0;
                        while (j < chans.length) {
                            chans[j] = j + this.firstChan;
                            ++j;
                        }
                        this.dl.setScanList(chans);
                    }
                    String message = "Connected to " + this.fullName;
                    if (!this.inited) {
                        this.log.info((Object)message, new String[0]);
                        break block13;
                    }
                    this.log.error((Object)message, new String[0]);
                }
                catch (DriverException e) {
                    if (!this.inited) {
                        this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
                    }
                    if (this.dl != null) {
                        this.close();
                    }
                    this.inited = true;
                }
            }
            finally {
                this.inited = true;
            }
        }
    }

    protected void close() {
        try {
            this.dl.close();
        }
        catch (DriverException driverException) {}
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        int iSubtype;
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            this.mon.reportError(name, "type", (Object)type);
        }
        int n = iSubtype = subtype.length() == 1 ? tcTypes.indexOf(subtype) : -1;
        if (iSubtype < 0) {
            this.mon.reportError(name, "subtype", (Object)subtype);
        }
        this.firstChan = Math.min(hwChan, this.firstChan);
        this.lastChan = Math.max(hwChan, this.lastChan);
        return new int[]{iType, iSubtype};
    }

    protected void initChannel(int chan, int type, int subtype) {
        if (!this.online) {
            return;
        }
        try {
            if (type == 0) {
                this.dl.configTC(tcMap.get(tcTypes.substring(subtype, subtype + 1)), new int[]{chan});
            }
        }
        catch (DriverException e) {
            this.log.error((Object)("Error configuring " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
        }
    }

    protected void readChannelGroup() {
        if (!this.online) {
            return;
        }
        try {
            if (this.lastChan >= this.firstChan) {
                this.chanValues = this.dl.readData();
            }
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading data logger: " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
        }
    }

    protected double readChannel(int hwChan, int type) {
        if (this.online) {
            return this.chanValues[hwChan - this.firstChan];
        }
        return super.readChannel(hwChan, type);
    }
}

