/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.bk.Model1696;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.refrig.PowerDevice;

public class BK1696Device
extends PowerDevice {
    private static final double MAX_CURRENT = 3.0;
    private static final int CHAN_POWER = 0;
    private static final int CHAN_VOLTAGE = 1;
    private static final int CHAN_CURRENT = 2;
    private static final int N_HW_CHANS = 3;
    private static final int BK_CHANNEL = 0;
    private static final Map<String, Integer> cTypeMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> typeMap;
    private final Model1696 bk = new Model1696();
    private final String connTypeS;
    private final String ident;
    private int connType;
    private final double[] values = new double[3];

    static {
        cTypeMap.put("SERIAL", 2);
        cTypeMap.put("FTDI", 1);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("POWER", 2);
    }

    public BK1696Device(String connType, String devcId) {
        this.connTypeS = connType;
        this.ident = devcId;
        this.disabled = true;
    }

    protected void configure(Monitor mon) {
        super.configure(mon);
        this.fullName = "B&K model 1696 PS (" + this.ident + ")";
        Integer iConnType = cTypeMap.get(this.connTypeS);
        if (iConnType == null) {
            this.connType = -1;
            try {
                mon.reportError(this.getName(), "connection type", (Object)this.connTypeS);
            }
            catch (Exception exception) {}
        } else {
            this.connType = iConnType;
        }
    }

    protected void initialize() {
        block9: {
            if (this.connType < 0) {
                return;
            }
            try {
                try {
                    this.bk.open(this.connType, this.ident);
                    this.bk.setTimeout(2.0);
                    this.bk.setCurrent(3.0, 0);
                    this.setOnline(true);
                    String message = "Connected to " + this.fullName;
                    if (!this.inited) {
                        this.log.info((Object)message, new String[0]);
                        break block9;
                    }
                    this.log.error((Object)message, new String[0]);
                }
                catch (DriverException e) {
                    if (!this.inited) {
                        this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
                    }
                    if (this.bk != null) {
                        this.close();
                    }
                    this.inited = true;
                }
            }
            finally {
                this.inited = true;
            }
        }
    }

    protected void close() {
        try {
            this.bk.close();
        }
        catch (DriverException driverException) {}
        int j = 0;
        while (j < 3) {
            this.values[j] = 0.0;
            ++j;
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 3) {
            this.mon.reportError(name, "HW channel", (Object)hwChan);
        }
        Integer iSubtype = 0;
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            this.mon.reportError(name, "type", (Object)type);
        }
        return new int[]{iType, iSubtype};
    }

    protected void readChannelGroup() {
        if (!this.online) {
            return;
        }
        try {
            this.values[1] = this.bk.readVoltage(0);
            this.values[2] = this.bk.readCurrent(0);
            this.values[0] = this.values[1] * this.values[2];
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
        }
    }

    protected double readChannel(int hwChan, int type) {
        return this.online ? this.values[hwChan] : super.readChannel(hwChan, type);
    }

    @Override
    public void setOutput(int chan, boolean value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.bk.setOutput(value, 0);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
        }
    }

    @Override
    public boolean getOutput(int chan) {
        if (!this.testOnline()) {
            return false;
        }
        try {
            return this.bk.getOutput(0);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
            return false;
        }
    }

    @Override
    public void setVoltage(int chan, double value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.bk.setVoltage(value, 0);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
        }
    }

    @Override
    public double readVoltage(int chan) {
        if (!this.testOnline()) {
            return -1.0;
        }
        try {
            return this.bk.readVoltage(0);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
            return -1.0;
        }
    }

    @Override
    public void setCurrent(int chan, double value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.bk.setCurrent(value, 0);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
        }
    }

    @Override
    public double readCurrent(int chan) {
        if (!this.testOnline()) {
            return -1.0;
        }
        try {
            return this.bk.readCurrent(0);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
            return -1.0;
        }
    }
}

