import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.gruth.jutils.BuiltParm;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.Subscale;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.SimDevice;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Channel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig-subscale"]

builder.
    main (Subscale, argMap("main", 10000, 0, "", ["CmprLine"],
                           ["LoadLine"], "Power", ["CryoCtrTmp"],
                           ["CryoCtrTmp"], "TempCtrl")) {

        TempCtrl   (TempControl, argMap(1, 10, 60, 500, 4, 0, 0.1, 10000))

        Sim        (SimDevice, argMap("CryoCtrTmp", "LoadPower"))

        Power      (SimDevice.Power)

        CmprLine   (Line, argMap("Sim", 0, null, 0))

        LoadLine   (Line, argMap("Sim", 1, null, 0))

        AlarmMain  (Alarm, argMap("Trips off all power", null, 0))

        CmprPower  (Channel,
                    argMap("Compressor\\Power", "Watts",
                           "Sim", 5, "POWER", "1050: 0: 0: 0", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        CmpDisPrs  (Channel,
                    argMap("Discharge pressure", "Psig",
                           "Sim", 3, "VOLTS", "300: 30: 50: 30", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        CmpSucPrs  (Channel,
                    argMap("Suction pressure", "Psig",
                           "Sim", 4, "VOLTS", "10: 30: 50: 30", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        CmpDisTmp  (Channel,
                    argMap("Discharge temperature", "\u00b0C",
                           "Sim", 0, "TEMP", "110: 120: 10: 1200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "alarm", aDbl(limitHi, 0), 0, "AlarmMain"))

        CmpRetnTmp (Channel,
                    argMap("C1 oil temperature", "\u00b0C",
                           "Sim", 1, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpSepTmp  (Channel,
                    argMap("Separator temperature", "\u00b0C",
                           "Sim", 2, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmprVolts  (Channel,
                    argMap("Line voltage", "Volts",
                           "Sim", 6, "POWER", "208: 0: 0: 0", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))
        C3LiqdTmp  (Channel,
                    argMap("Heat Exchanger\\C3 liq capillary temperature", "\u00b0C",
                           "Sim", 12, "TEMP", "-120: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        PreC4Tmp   (Channel,
                    argMap("Pre C4 temperature", "\u00b0C",
                           "Sim", 13, "TEMP", "-120: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        PostC4Tmp  (Channel,
                    argMap("Post C4 temperature", "\u00b0C",
                           "Sim", 14, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexVapPrs  (Channel,
                    argMap("Vapor supply pressure", "Psig",
                           "Sim", 23, "VOLTS", "300: 30: 50: 30", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexLiqPrs  (Channel,
                    argMap("Liquid supply pressure", "Psig",
                           "Sim", 22, "VOLTS", "300: 30: 50: 30", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexPrsDiff (Channel,
                    argMap("Vapor/liquid delta P", "Psi",
                           null, 0, "DIFF", "HexLiqPrs:HexVapPrs", 0, 0,
                           "none", aDbl(limitLo, 0.0), 0.0, null,
                           "none", aDbl(limitHi, 0.0), 0.0, null))

        HexSucPrs  (Channel,
                    argMap("Return pressure", "Psig",
                           "Sim", 25, "VOLTS", "300: 30: 50: 30", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexExitTmp (Channel,
                    argMap("Return temperature", "\u00b0C",
                           "Sim", 24, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadTmp1   (Channel,
                    argMap("Cryostat\\Load temperature 1 RTD", "\u00b0C",
                           "Sim", 7, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        LoadTmp2   (Channel,
                    argMap("Load temperature 2 RTD", "\u00b0C",
                           "Sim", 8, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        LoadTmp3   (Channel,
                    argMap("Load temperature 3 RTD", "\u00b0C",
                           "Sim", 9, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        LoadTmp4   (Channel,
                    argMap("Load temperature 4 RTD", "\u00b0C",
                           "Sim", 10, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        LoadTmp5   (Channel,
                    argMap("Load temperature 5 RTD", "\u00b0C",
                           "Sim", 11, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        LoadPower  (Channel,
                    argMap("Heat load power", "Watts",
                           "Power", 0, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadVolts  (Channel,
                    argMap("Heat load voltage", "Volts",
                           "Power", 1, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CryoCtrTmp (Channel,
                    argMap("Cryoplate center temperature", "\u00b0C",
                           "Sim", 16, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmMain"))

        PostCryTmp (Channel,
                    argMap("Cryoplate exit temperature", "\u00b0C",
                           "Sim", 15, "TEMP", "-110: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        HexPostEvp (Channel,
                    argMap("HEX post evap temperature", "\u00b0C",
                           "Sim", 18, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        GridFceTmp (Channel,
                    argMap("Grid face temperature", "\u00b0C",
                           "Sim", 19, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CryStrWTmp (Channel,
                    argMap("Mock grid strap warm end", "\u00b0C",
                           "Sim", 20, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CryStrCTmp (Channel,
                    argMap("Mock grid strap cold end", "\u00b0C",
                           "Sim", 21, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        Running    (Channel,
                    argMap("Control Chassis\\Running state", "",
                           "Sim", 26, "SWITCH", "1: 0: 0: 0", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        Interlock  (Channel,
                    argMap("Interlock state", "",
                           "Sim", 27, "SWITCH", "1: 0: 0: 0", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        ThermRelay (Channel,
                    argMap("Thermal relay state", "",
                           "Sim", 28, "SWITCH", "1: 0: 1: 0", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        LoadEnable (Channel,
                    argMap("Load enable state", "",
                           "Sim", 29, "SWITCH", "1: 0: 0: 0", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        V5Power    (Channel,
                    argMap("5-Volt power state", "",
                           "Sim", 30, "SWITCH", "1: 0: 1: 0", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))
    }
