import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.LongLines;
import org.lsst.ccs.subsystem.refrig.SimDevice;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Channel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig-longlines"]

builder.
    main (LongLines, argMap("main", 10000, "")) {

        Sim        (SimDevice, argMap("LoadTmp", "LoadPower"))

        MainPower  (Line, argMap("Sim", 0, null, 0))

        LoadPower  (Line, argMap("Sim", 1, null, 0))

        LED0       (Line, argMap("Sim", 2, null, 0))

        LED1       (Line, argMap("Sim", 3, null, 1))

        LED2       (Line, argMap("Sim", 4, null, 2))

        LED3       (Line, argMap("Sim", 5, null, 3))

        LED4       (Line, argMap("Sim", 6, null, 4))

        LED5       (Line, argMap("Sim", 7, null, 5))

        Main       (Alarm, argMap("Trips off all power", null, 0))

        Load       (Alarm, argMap("Turns off the load power", null, 1))

        Alarm0     (Alarm, argMap("Turns LED0 red", "LED0", -1))

        Alarm1     (Alarm, argMap("Turns LED1 red", "LED1", -1))

        Alarm2     (Alarm, argMap("Turns LED2 red", "LED2", -1))

        Alarm3     (Alarm, argMap("Turns LED3 red", "LED3", -1))

        Alarm4     (Alarm, argMap("Turns LED4 red", "LED4", -1))

        Alarm5     (Alarm, argMap("Turns LED5 red", "LED5", -1))

        CmpDisTmp  (Channel,
                    argMap("Compressor discharge temperature", "\u00b0C",
                           "Sim", 0, "TEMP", "110: 120: 10: 1200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "alarm", aDbl(limitHi, 0), 0, "Main"))

        CmpDisPrs  (Channel,
                    argMap("Compressor discharge pressure", "Psig",
                           "Sim", 1, "VOLTS", "300: 30: 50: 30", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "alarm", aDbl(limitHi, 0), 0, "Alarm0"))

        C3LiqdTmp  (Channel,
                    argMap("C3 liquid cap temperature", "\u00b0C",
                           "Sim", 2, "TEMP", "-120: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "alarm", aDbl(limitHi, 0), 0, "Alarm1"))

        PreC4Tmp   (Channel,
                    argMap("Pre C4 evaporator temperature", "\u00b0C",
                           "Sim", 3, "TEMP", "-120: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "alarm", aDbl(limitHi, 0), 0, "Alarm2"))

        PostEvpTmp (Channel,
                    argMap("Post evaporator temperature", "\u00b0C",
                           "Sim", 4, "TEMP", "-110: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "alarm", aDbl(limitHi, 0), 0, "Alarm3"))

        LoadTmp    (Channel,
                    argMap("Heat load temperature", "\u00b0C",
                           "Sim", 5, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "alarm", aDbl(limitHi, 0), 2, "Load"))

        LoadTmpTC  (Channel,
                    argMap("Heat load temperature (TC)", "\u00b0C",
                           "Sim", 6, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        DwrSucPrs  (Channel,
                    argMap("Dewar suction pressure", "Psig",
                           "Sim", 12, "VOLTS", "15: 60: 50: 60", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "alarm", aDbl(limitHi, 0), 0, "Alarm4"))

        CmpSucPrs  (Channel,
                    argMap("Compressor suction pressure", "Psig",
                           "Sim", 7, "VOLTS", "10: 30: 50: 30", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "alarm", aDbl(limitHi, 0), 0, "Alarm5"))

        SucPrsDiff (Channel,
                    argMap("Suction pressure difference", "Psi",
                           null, 0, "DIFF", "DwrSucPrs:CmpSucPrs", 0, 0,
                           "none", aDbl(limitLo, 0), 0, null,
                           "none", aDbl(limitHi, 0), 0, null))

        LoadPower  (Channel,
                    argMap("Heat load power", "Watts",
                           "Sim", 8, "POWER", "200: 0: 0: 0", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        CmprPower  (Channel,
                    argMap("Compressor power", "Watts",
                           "Sim", 9, "POWER", "1050: 0: 0: 0", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        CmprVolts  (Channel,
                    argMap("Compressor line voltage", "Volts",
                           "Sim", 10, "POWER", "208: 0: 0: 0", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        FanAlarm   (Channel,
                    argMap("Compressor purge fan alarm", "",
                           "Sim", 11, "SWITCH", "1: 0: 1: 0", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))
    }
