import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.Subscale;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.MCCDevice;
import org.lsst.ccs.subsystem.refrig.BK1696Device;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Channel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig-hxtest"]

builder.
    main (Subscale, argMap("main", 10000, 5000, "", 
                           ["CmprLine1", "CmprLine2"], ["LoadLine1", "LoadLine2"],
                           "Power", ["LoadTemp"], ["LoadTemp"], "TempCtrl")) {

        TempCtrl   (TempControl, argMap(10, 1000, 120, 100, 4, 0, 0.05, 30000))

        Cmpr       (MCCDevice, argMap("TC_AI", "00099271"))

        Mod1       (MCCDevice, argMap("TC_AI", "00099629"))

        Mod2       (MCCDevice, argMap("TEMP", "0197DA2B"))

        Mod3       (MCCDevice, argMap("TEMP", "01923E75"))

        Power      (BK1696Device, argMap("FTDI", "A7032X3P"))

        CmprLine1  (Line, argMap("Cmpr", 0, null, 0))

        CmprLine2  (Line, argMap("Cmpr", 1, null, 0))

        LoadLine1  (Line, argMap("Mod1", 0, null, 0))

        LoadLine2  (Line, argMap("Mod1", 1, null, 0))

        AlarmCmpr  (Alarm, argMap("Trips off all power", null, 0))

        AlarmLoad  (Alarm, argMap("Turns off load power", null, 1))

        CmprPower  (Channel,
                    argMap("Compressor\\Power", "Watts",
                           "Cmpr", 6, "VOLTS", "10V", 0.0, 208.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        CmpDisPrs  (Channel,
                    argMap("Discharge pressure", "Psig",
                           "Cmpr", 5, "VOLTS", "1.25V", 0.0, 10000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        CmpSucPrs  (Channel,
                    argMap("Suction pressure", "Psig",
                           "Cmpr", 4, "VOLTS", "1.25V", 0.0, 1000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpBodyTmp (Channel,
                    argMap("Body temperature", "\u00b0C",
                           "Cmpr", 0, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        CmpDisTmp  (Channel,
                    argMap("Discharge temperature", "\u00b0C",
                           "Cmpr", 1, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        CmpRetnTmp (Channel,
                    argMap("C1 oil temperature", "\u00b0C",
                           "Cmpr", 2, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpSepTmp  (Channel,
                    argMap("Separator temperature", "\u00b0C",
                           "Cmpr", 3, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpFlowSwi (Channel,
                    argMap("Flow switch state", "",
                           "Cmpr", 6, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        CmpTmpRly  (Channel,
                    argMap("Temperature relay state", "",
                           "Cmpr", 4, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        C3LiqdTmp  (Channel,
                    argMap("Heat Exchanger\\C3 liq capillary temperature", "\u00b0C",
                           "Mod1", 1, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PreC4Tmp   (Channel,
                    argMap("Pre C4 temperature", "\u00b0C",
                           "Mod1", 2, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PostC4Tmp  (Channel,
                    argMap("Post C4 temperature", "\u00b0C",
                           "Mod1", 3, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexVapPrs  (Channel,
                    argMap("Vapor supply pressure", "Psig",
                           "Mod1", 4, "VOLTS", "1.25V", -2.5, 10000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        HexLiqPrs  (Channel,
                    argMap("Liquid supply pressure", "Psig",
                           "Mod1", 5, "VOLTS", "1.25V", -5.48, 5000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        HexPrsDiff (Channel,
                    argMap("Vapor/liquid delta P", "Psi",
                           null, 0, "DIFF", "HexLiqPrs:HexVapPrs", 0, 0,
                           "none", aDbl(limitLo, 0.0), 0.0, null,
                           "none", aDbl(limitHi, 0.0), 0.0, null))

        HexSucPrs  (Channel,
                    argMap("Return pressure", "Psig",
                           "Mod1", 6, "VOLTS", "1.25V", 0.38, 1000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexExitTmp (Channel,
                    argMap("Return temperature", "\u00b0C",
                           "Mod2", 2, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadTemp   (Channel,
                    argMap("Load temperature RTD", "\u00b0C",
                           "Mod3", 0, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "alarm", aDbl(limitLo, 0.0), 0.0, "AlarmCmpr",
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        LoadPower  (Channel,
                    argMap("Heat load power", "Watts",
                           "Power", 0, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadVolts  (Channel,
                    argMap("Heat load voltage", "Volts",
                           "Power", 1, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        AmbientTmp (Channel,
                    argMap("Ambient temperature", "\u00b0C",
                           "Mod1", 0, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        Running    (Channel,
                    argMap("Control Chassis\\Running state", "",
                           "Mod1", 6, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        Interlock  (Channel,
                    argMap("Interlock state", "",
                           "Mod1", 2, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        ThermRelay (Channel,
                    argMap("Thermal relay state", "",
                           "Mod1", 3, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        LoadEnable (Channel,
                    argMap("Load enable state", "",
                           "Mod1", 4, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        V5Power    (Channel,
                    argMap("5-Volt power state", "",
                           "Mod1", 5, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))
    }
