/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.subsystem.monitor.Device;

public class WUDevice
extends Device
implements WattsUp.Listener {
    static final int CHAN_WATTS = 0;
    static final int CHAN_VOLTS = 1;
    static final int CHAN_FREQ = 2;
    static final int N_DEV_CHANS = 3;
    static final int LOG_PERIOD = 1;
    String node;
    String serial;
    WattsUp wtu;
    double[] value;

    public WUDevice(String nodeName, String serialNo) {
        this.node = nodeName;
        this.serial = serialNo;
        this.fullName = "WattsUp meter (" + (this.node == null ? "local" : this.node) + (this.serial == null ? "" : ":" + this.serial) + ")";
        this.value = new double[3];
    }

    protected void initialize() {
        block8: {
            try {
                try {
                    if (!this.inited || this.wtu == null) {
                        this.wtu = new WattsUp();
                        this.wtu.addListener((WattsUp.Listener)this);
                    }
                    this.wtu.open(this.node, 0, this.serial);
                    this.wtu.restart();
                    this.setOnline(true);
                    String message = "Connected to " + this.fullName;
                    if (!this.inited) {
                        this.log.info((Object)message, new String[0]);
                        break block8;
                    }
                    this.log.error((Object)message, new String[0]);
                }
                catch (DriverException e) {
                    if (!this.inited) {
                        this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
                    }
                    this.inited = true;
                }
            }
            finally {
                this.inited = true;
            }
        }
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 3) {
            this.mon.reportError(name, "hw channel number", (Object)hwChan);
        }
        return new int[2];
    }

    protected void initChannel(int chan, int type, int subtype) {
    }

    protected double readChannel(int chan, int type) {
        return this.online ? this.value[chan] : super.readChannel(chan, type);
    }

    public void setPowered(boolean on) {
        if (on) {
            try {
                this.wtu.setLoggedFields(65539);
                this.wtu.setExternalLogging(1);
            }
            catch (DriverException e) {
                this.log.error((Object)("Error configuring " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            }
        } else {
            int j = 0;
            while (j < 3) {
                this.value[j] = 0.0;
                ++j;
            }
        }
    }

    public void setClosed() {
        this.setOnline(false);
    }

    public void processData(double[] data) {
        this.value[0] = data[0];
        this.value[1] = data[1];
        this.value[2] = data[16];
    }
}

