/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;

public class LongLines
extends Module
implements HardwareController,
Monitor.AlarmHandler {
    private static final int EVENT_ID_MAIN_POWER = 0;
    private static final int EVENT_ID_LOAD_POWER = 1;
    Monitor mon;
    String configName = "test";
    boolean coldStart;
    boolean loadAlarm;
    int state = 4;
    Line mainPowerLine;
    Line loadPowerLine;

    public LongLines(String name, int tickMillis, String configName) {
        super(name, tickMillis);
        this.configName = configName;
        String cold = System.getProperty("lsst.ccs.refrig.coldstart", "");
        this.coldStart = cold.equals("true");
    }

    public void initModule() {
        this.mon = new Monitor((Module)this, (Monitor.AlarmHandler)this, log);
        this.mon.initConfiguration();
        this.mainPowerLine = this.mon.getLine("MainPower");
        if (this.mainPowerLine == null) {
            log.error((Object)"Main power line (MainPower) not defined", new String[0]);
        }
        this.loadPowerLine = this.mon.getLine("LoadPower");
        if (this.loadPowerLine == null) {
            log.error((Object)"Load power line (LoadPower) not defined", new String[0]);
        }
    }

    public TreeWalkerDiag checkHardware() {
        System.out.println("checkHardware was called");
        if (this.mainPowerLine != null) {
            this.mainPowerLine.setWarm(!this.coldStart);
        }
        this.mon.initSensors();
        if (this.mainPowerLine != null) {
            this.mainPowerLine.setWarm(false);
        }
        this.setMainPowerEnable(this.isMainPowerOn() ? 1 : 0);
        this.setLoadPower();
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() {
        System.out.println("checkStarted was called");
    }

    public void checkStopped() {
        System.out.println("checkStopped was called");
    }

    public void startTicking() {
        this.mon.start();
        super.startTicking();
        this.publishState();
        this.mon.publishState();
        this.mon.publishLimits();
        System.out.println("Refrigeration long lines test system started");
    }

    public void tick() {
        this.mon.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setTickMillis(int value) {
        super.setTickMillis(value);
        this.publishState();
    }

    public void processAlarm(int event, int parm) {
        switch (parm) {
            case 0: {
                if (event == 0) {
                    if ((this.state & 2) != 0) break;
                    this.state |= 2;
                    this.setMainPowerEnable(0);
                    this.publishState();
                    break;
                }
                if (event != 2 || (this.state & 2) == 0) break;
                this.state &= 0xFFFFFFFD;
                this.publishState();
                break;
            }
            case 1: {
                if (event == 0) {
                    this.loadAlarm = true;
                    if ((this.state & 8) == 0) break;
                    this.state &= 0xFFFFFFFB;
                    this.setLoadPower();
                    this.publishState();
                    break;
                }
                if (event != 2) break;
                this.loadAlarm = false;
                if ((this.state & 8) == 0) break;
                this.state |= 4;
                this.setLoadPower();
                this.publishState();
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the main power enabled state")
    public void setMainPowerEnable(int value) {
        if (value != 0) {
            if ((this.state & 2) == 0) {
                this.state |= 1;
            }
        } else {
            this.state &= 0xFFFFFFFE;
        }
        this.setMainPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the load power trip enabled state")
    public void setLoadTripEnable(int value) {
        if (value != 0) {
            this.state |= 8;
            if (this.loadAlarm) {
                this.state &= 0xFFFFFFFB;
                this.setLoadPower();
            }
        } else {
            this.state &= 0xFFFFFFF7;
            if ((this.state & 4) == 0) {
                this.state |= 4;
                this.setLoadPower();
            }
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current configuration")
    public void saveConfig() throws IOException {
        this.getEnvironment().saveConfiguration();
        this.mon.clearLimitChanges();
        this.mon.publishState();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full refrigeration state")
    public RefrigFullState getFullState() {
        RefrigState refgState = new RefrigState(this.state, this.getTickMillis(), 0.0, 0.0);
        MonitorFullState monState = this.mon.getFullState();
        return new RefrigFullState(refgState, monState);
    }

    int getState() {
        return this.state;
    }

    void publishState() {
        this.publish("RefrigState", new RefrigState(this.state, this.getTickMillis(), 0.0, 0.0));
    }

    void setMainPower() {
        if (this.mainPowerLine != null) {
            this.mainPowerLine.set((this.state & 1) != 0);
        }
    }

    void setLoadPower() {
        if (this.loadPowerLine != null) {
            this.loadPowerLine.set((this.state & 4) != 0);
        }
    }

    boolean isMainPowerOn() {
        return this.mainPowerLine != null && this.mainPowerLine.isSet();
    }

    boolean isLoadPowerOn() {
        return this.loadPowerLine != null && this.loadPowerLine.isSet();
    }
}

