/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;

public class Compressor
extends Module
implements HardwareController,
Monitor.AlarmHandler {
    private static final int EVENT_ID_MAIN_POWER = 0;
    private final String configName;
    private final boolean coldStart;
    private final int checkMillis;
    private final String compPowerLineS;
    private final String heaterPowerLineS;
    private final String resetLineS;
    private Line compPowerLine;
    private Line heaterPowerLine;
    private Line resetLine;
    private Monitor mon;
    private int state = 0;

    public Compressor(String name, int tickMillis, int checkMillis, String configName, String compPowerLine, String heaterPowerLine, String resetLine) {
        super(name, tickMillis);
        this.checkMillis = checkMillis;
        this.configName = configName != null ? configName : "";
        this.compPowerLineS = compPowerLine;
        this.heaterPowerLineS = heaterPowerLine;
        this.resetLineS = resetLine;
        String cold = System.getProperty("lsst.ccs.refrig.coldstart", "");
        this.coldStart = cold.equals("true");
    }

    public void initModule() {
        if (this.compPowerLineS != null) {
            this.compPowerLine = (Line)this.getComponent(this.compPowerLineS, Line.class);
        }
        if (this.heaterPowerLineS != null) {
            this.heaterPowerLine = (Line)this.getComponent(this.heaterPowerLineS, Line.class);
        }
        if (this.resetLineS != null) {
            this.resetLine = (Line)this.getComponent(this.resetLineS, Line.class);
        }
        if (this.compPowerLine == null) {
            log.error((Object)"Compressor power line not specified", new String[0]);
        }
        if (this.heaterPowerLine == null) {
            log.error((Object)"Heater power line not specified", new String[0]);
        }
        if (this.resetLine == null) {
            log.error((Object)"Reset line not specified", new String[0]);
        }
        this.mon = new Monitor((Module)this, (Monitor.AlarmHandler)this, log);
        this.mon.initConfiguration();
    }

    public TreeWalkerDiag checkHardware() {
        if (this.compPowerLine != null) {
            this.compPowerLine.setWarm(!this.coldStart);
        }
        if (this.heaterPowerLine != null) {
            this.heaterPowerLine.setWarm(!this.coldStart);
        }
        this.mon.initSensors(this.checkMillis);
        if (this.compPowerLine != null) {
            this.compPowerLine.setWarm(false);
        }
        if (this.heaterPowerLine != null) {
            this.heaterPowerLine.setWarm(false);
        }
        this.setCompPowerEnable(this.isCompPowerOn() ? 1 : 0);
        this.setHeaterPowerEnable(this.isHeaterPowerOn() ? 1 : 0);
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() {
        System.out.println("checkStarted was called");
    }

    public void checkStopped() {
        System.out.println("checkStopped was called");
    }

    public void startTicking() {
        this.mon.start();
        super.startTicking();
        this.publishState();
        this.mon.publishState();
        this.mon.publishLimits();
        System.out.println("Refrigeration compressor test started");
    }

    public void tick() {
        this.mon.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setTickMillis(int value) {
        super.setTickMillis(value);
        this.publishState();
    }

    public void processAlarm(int event, int parm) {
        switch (parm) {
            case 0: {
                if (event == 0) {
                    if ((this.state & 2) != 0) break;
                    this.state |= 2;
                    this.setCompPowerEnable(0);
                    this.publishState();
                    break;
                }
                if (event != 2 || (this.state & 2) == 0) break;
                this.state &= 0xFFFFFFFD;
                this.publishState();
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the main power enabled state")
    public void setCompPowerEnable(int value) {
        if (value != 0) {
            if ((this.state & 2) == 0) {
                this.state |= 1;
            }
        } else {
            this.state &= 0xFFFFFFDE;
        }
        this.setCompPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the heater power enabled state")
    public void setHeaterPowerEnable(int value) {
        this.state = value != 0 ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
        this.setHeaterPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Reset the latches")
    public void reset() {
        if (this.resetLine != null) {
            this.resetLine.set(true);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
            this.resetLine.set(false);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current configuration")
    public void saveConfig() throws IOException {
        this.getEnvironment().saveConfiguration();
        this.mon.clearLimitChanges();
        this.mon.publishState();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full refrigeration state")
    public RefrigFullState getFullState() {
        RefrigState refgState = new RefrigState(this.state, this.getTickMillis(), 0.0, 0.0);
        MonitorFullState monState = this.mon.getFullState();
        return new RefrigFullState(refgState, monState);
    }

    private void publishState() {
        this.publish("RefrigState", new RefrigState(this.state, this.getTickMillis(), 0.0, 0.0));
    }

    private void setCompPower() {
        boolean on;
        boolean bl = on = (this.state & 1) != 0;
        if (this.compPowerLine != null) {
            this.compPowerLine.set(on);
        }
    }

    private void setHeaterPower() {
        boolean on;
        boolean bl = on = (this.state & 4) != 0;
        if (this.heaterPowerLine != null) {
            this.heaterPowerLine.set(on);
        }
    }

    private boolean isCompPowerOn() {
        return this.compPowerLine != null && this.compPowerLine.isSet();
    }

    private boolean isHeaterPowerOn() {
        return this.heaterPowerLine != null && this.heaterPowerLine.isSet();
    }

    private Object getComponent(String name, Class cls) {
        Object cmpt = this.getComponentByName(name);
        return cls.isInstance(cmpt) ? cmpt : null;
    }
}

