import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.Compressor;
import org.lsst.ccs.subsystem.refrig.Maq20Device;
import org.lsst.ccs.subsystem.refrig.PlutoDevice;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Channel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig-compressor"]

builder.
    main (Compressor, argMap("main", 10000, 5000, "", "CompLine", "HtrLine",
                             "ResetLine")) {

        Maq        (Maq20Device, argMap("192.168.128.100",
                                        ["0098704-16", "0100762-01"]))

        Pluto      (PlutoDevice, argMap("192.168.0.100",
                                        [1, 1, 1, 2, 1, 3]))

        ResetLine  (Line, argMap("Pluto", 0, null, 0))

        CompLine   (Line, argMap("Pluto", 16, null, 0))

        HtrLine    (Line, argMap("Pluto", 32, null, 0))

        CompOn     (Channel,
                    argMap("Control\\Compressor ON switch", "",
                           "Pluto", 6, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CompPerm   (Channel,
                    argMap("CCS compressor permit", "",
                           "Pluto", 20, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CompEnab   (Channel,
                    argMap("Compressor enable", "",
                           "Pluto", 31, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CompPwr    (Channel,
                    argMap("Compressor power", "",
                           "Pluto", 16, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HeaterOn   (Channel,
                    argMap("Heater ON switch", "",
                           "Pluto", 0, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HeaterPerm (Channel,
                    argMap("CCS heater permit", "",
                           "Pluto", 21, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HeaterPwr  (Channel,
                    argMap("Heater power", "",
                           "Pluto", 17, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        Permit     (Channel,
                    argMap("External permit", "",
                           "Pluto", 5, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PermLatch  (Channel,
                    argMap("External permit latch", "",
                           "Pluto", 30, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LevelSw    (Channel,
                    argMap("Oil level switch", "",
                           "Pluto", 4, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LevelLatch (Channel,
                    argMap("Oil level OK latch", "",
                           "Pluto", 22, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        FlowSw     (Channel,
                    argMap("Water flow switch", "",
                           "Pluto", 0, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        FlowLatch  (Channel,
                    argMap("Water flow OK latch", "",
                           "Pluto", 29, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CompTemp   (Channel,
                    argMap("Compressor temperature", "\u00b0C",
                           "Pluto", 0, "ADDREG:0", null, 0.0, 0.01,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CompTmpOk  (Channel,
                    argMap("Compressor temp valid", "",
                           "Pluto", 23, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CompTmpHi  (Channel,
                    argMap("Compressor temp high latch", "",
                           "Pluto", 24, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        DisPress   (Channel,
                    argMap("Discharge pressure", "Psig",
                           "Pluto", 1, "ADDREG:0", null, 0.0, 0.1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        DisPrsOk   (Channel,
                    argMap("Discharge pressure valid", "",
                           "Pluto", 25, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        DisPrsHi   (Channel,
                    argMap("Discharge pressure high latch", "",
                           "Pluto", 26, "GLOBAL:1", null, 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmprTemp    (Channel,
                    argMap("Monitoring\\Compressor temperature", "\u00b0C",
                           "Maq", 3, "TTC:1", "T220", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        DisTemp    (Channel,
                    argMap("Discharge temperature", "\u00b0C",
                           "Maq", 2, "TTC:1", "T220", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        OilTemp    (Channel,
                    argMap("Oil temperature", "\u00b0C",
                           "Maq", 1, "TTC:1", "T220", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        WaterTemp  (Channel,
                    argMap("Water temperature", "\u00b0C",
                           "Maq", 5, "TTC:1", "T220", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        SepTemp    (Channel,
                    argMap("Separator temperature", "\u00b0C",
                           "Maq", 0, "TTC:1", "T220", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        C1Temp    (Channel,
                    argMap("C1 temperature", "\u00b0C",
                           "Maq", 4, "TTC:1", "T220", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        SucPress   (Channel,
                    argMap("Suction pressure", "Psig",
                           "Maq", 3, "VOLT:0", "V5", 0.0, 40.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CompVolt   (Channel,
                    argMap("Compressor voltage", "Volts",
                           "Maq", 0, "VOLT:0", "V5", 0.0, 50.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CompCurr   (Channel,
                    argMap("Compressor current", "Amps",
                           "Maq", 1, "VOLT:0", "V5", 0.0, 5.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        SupplyVolt (Channel,
                    argMap("24 volt supply", "Volts",
                           "Pluto", 1, "ADDREG:1", null, 0.0, 0.1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

    }
