#! /bin/sh
#
#  Run the refrigeration subscale camera test simulation program
#
#  subscaleSim.sh [jms] [cold]
#
#    jms     If present, uses JMS instead of jGroups
#
#    cold    If present, performs a cold start
#

if [ `uname` == Linux ]; then FP=`readlink -fn $0`
else FP=`perl -e "use Cwd 'abs_path'; print abs_path('$0')"`; fi
BD=`dirname $FP`

if [ "$1" == jms ] || [ "$2" == jms ]; then
    TL="-tl GlassFish3"
fi

if [ "$1" == cold ] || [ "$2" == cold ]; then
    CS="-D lsst.ccs.refrig.coldstart=true"
fi

export CCS_RESOURCE_PATH=..
CFG=ccs-refrig-subscale__sim.properties
touch $BD/../../$CFG
$BD/CCSbootstrap.sh -app RefrigSubscaleSim $TL $CS --configuration $CFG "$@"
#$BD/CCSbootstrap.sh -app RefrigSubscaleSim $TL $CS --configuration $CFG "$@" >> ~/ccs/logs/refrigSubscaleSim.log 2>&1 &
