/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.mmr.Mmr;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class MMRDevice
extends Device
implements Mmr.Listener {
    static final int CHAN_T0 = 0;
    static final int CHAN_T1 = 1;
    static final int CHAN_P0 = 2;
    static final int CHAN_P1 = 3;
    static final int CHAN_D0 = 4;
    static final int CHAN_D1 = 5;
    static final int CHAN_I = 6;
    static final int N_DEV_CHANS = 7;
    static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    String connTypeS;
    String ident;
    int connType;
    Mmr mmr;
    double[] value;

    static {
        typeMap.put("FTDI", 1);
        typeMap.put("SERIAL", 2);
    }

    public MMRDevice(String cType, String id) {
        this.connTypeS = cType;
        this.ident = id;
        this.fullName = "MMR controller (" + this.ident + ")";
        this.value = new double[7];
    }

    protected void configure(Monitor mon) {
        super.configure(mon);
        Integer iConnType = typeMap.get(this.connTypeS.toUpperCase());
        if (iConnType == null) {
            this.log.error((Object)("Invalid MMR connection type (" + this.connTypeS + ")"), new String[0]);
            this.connType = -1;
        } else {
            this.connType = iConnType;
        }
    }

    protected void initialize() {
        block9: {
            if (this.connType < 0) {
                return;
            }
            try {
                try {
                    if (!this.inited || this.mmr == null) {
                        this.mmr = new Mmr();
                        this.mmr.addListener((Mmr.Listener)this);
                    }
                    this.mmr.open(this.connType, this.ident);
                    this.setOnline(true);
                    String message = "Connected to " + this.fullName;
                    if (!this.inited) {
                        this.log.info((Object)message, new String[0]);
                        break block9;
                    }
                    this.log.error((Object)message, new String[0]);
                }
                catch (Exception e) {
                    if (!this.inited) {
                        this.log.error((Object)("Error connecting to " + this.fullName + ": " + e), new String[0]);
                    }
                    this.inited = true;
                }
            }
            finally {
                this.inited = true;
            }
        }
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 7) {
            this.mon.reportError(name, "hw channel number", (Object)hwChan);
        }
        return new int[2];
    }

    protected double readChannel(int chan, int type) {
        return this.online ? this.value[chan] : super.readChannel(chan, type);
    }

    public void setPowered(boolean on) {
        if (!on) {
            int j = 0;
            while (j < 7) {
                this.value[j] = 0.0;
                ++j;
            }
        }
    }

    public void setClosed(Exception e) {
        this.log.error((Object)("MMR controller error: " + e), new String[0]);
        this.setOnline(false);
    }

    public void processData(double[] data) {
        this.value[0] = data[1];
        this.value[1] = data[2];
        this.value[2] = data[3];
        this.value[3] = data[4];
        this.value[4] = data[5];
        this.value[5] = data[6];
        this.value[6] = data[7];
    }
}

