/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.monitor.Channel;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;

public class HXTest
extends Module
implements HardwareController,
Monitor.AlarmHandler {
    private static final int EVENT_ID_MAIN_POWER = 0;
    private final String configName;
    private final boolean coldStart;
    private final int checkMillis;
    private final String loadPowerDevcS;
    private final List cmprPowerLinesS;
    private final List loadPowerLinesS;
    private final List alarmDsabChansS;
    private final List loadTempChansS;
    private final String tempCtrlS;
    private final List<Line> cmprPowerLines = new ArrayList<Line>();
    private final List<Line> loadPowerLines = new ArrayList<Line>();
    private final List<Channel> alarmDsabChans = new ArrayList<Channel>();
    private final List<Channel> loadTempChans = new ArrayList<Channel>();
    private PowerDevice loadPowerDevc;
    private TempControl tempCtrl;
    private Monitor mon;
    private int state = 8;
    private double loadTemp;
    private double loadPower;
    private Double startPower = 0.0;

    public HXTest(String name, int tickMillis, int checkMillis, String configName, List cmprPowerLines, List loadPowerLines, String loadPowerDevc, List alarmDsabChans, List loadTempChans, String tempCtrl) {
        super(name, tickMillis);
        this.checkMillis = checkMillis;
        this.configName = configName != null ? configName : "";
        this.cmprPowerLinesS = cmprPowerLines;
        this.loadPowerLinesS = loadPowerLines;
        this.loadPowerDevcS = loadPowerDevc;
        this.alarmDsabChansS = alarmDsabChans;
        this.loadTempChansS = loadTempChans;
        this.tempCtrlS = tempCtrl;
        String cold = System.getProperty("lsst.ccs.refrig.coldstart", "");
        this.coldStart = cold.equals("true");
    }

    public void initModule() {
        Object cmpt;
        this.loadPowerDevc = (PowerDevice)((Object)this.getComponent(this.loadPowerDevcS, PowerDevice.class));
        for (Object chanS : this.cmprPowerLinesS) {
            Object object = cmpt = chanS instanceof String ? this.getComponent((String)chanS, Line.class) : null;
            if (cmpt == null) continue;
            this.cmprPowerLines.add((Line)cmpt);
        }
        for (Object chanS : this.loadPowerLinesS) {
            Object object = cmpt = chanS instanceof String ? this.getComponent((String)chanS, Line.class) : null;
            if (cmpt == null) continue;
            this.loadPowerLines.add((Line)cmpt);
        }
        for (Object chanS : this.alarmDsabChansS) {
            Object object = cmpt = chanS instanceof String ? this.getComponent((String)chanS, Channel.class) : null;
            if (cmpt == null) continue;
            this.alarmDsabChans.add((Channel)cmpt);
        }
        for (Object chanS : this.loadTempChansS) {
            Object object = cmpt = chanS instanceof String ? this.getComponent((String)chanS, Channel.class) : null;
            if (cmpt == null) continue;
            this.loadTempChans.add((Channel)cmpt);
        }
        this.tempCtrl = (TempControl)((Object)this.getComponent(this.tempCtrlS, TempControl.class));
        if (this.cmprPowerLines.isEmpty()) {
            log.error((Object)"No valid compressor power lines specified", new String[0]);
        } else if (this.cmprPowerLines.size() != this.cmprPowerLinesS.size()) {
            log.error((Object)"Some compressor power lines are invalid", new String[0]);
        }
        if (this.loadPowerLines.isEmpty()) {
            log.error((Object)"No valid load power lines specified", new String[0]);
        } else if (this.loadPowerLines.size() != this.loadPowerLinesS.size()) {
            log.error((Object)"Some load power lines are invalid", new String[0]);
        }
        if (this.loadPowerDevc == null) {
            log.error((Object)"No valid load power device specified", new String[0]);
            this.state |= 0x10;
        }
        if (this.alarmDsabChans.size() != this.alarmDsabChansS.size()) {
            log.error((Object)"Some alarm disable channels are invalid", new String[0]);
        }
        if (this.loadTempChans.size() != this.loadTempChansS.size()) {
            log.error((Object)"Some load temperature channels are invalid", new String[0]);
        }
        if (this.tempCtrl == null) {
            log.error((Object)"No valid temperature controller specified", new String[0]);
        }
        this.mon = new Monitor((Module)this, (Monitor.AlarmHandler)this, log);
        this.mon.initConfiguration();
        if (this.tempCtrl != null) {
            this.tempCtrl.initialize(this.loadTempChans, this.loadPowerDevc, log);
        }
    }

    public TreeWalkerDiag checkHardware() {
        for (Line line : this.cmprPowerLines) {
            line.setWarm(!this.coldStart);
        }
        for (Line line : this.loadPowerLines) {
            line.setWarm(!this.coldStart);
        }
        this.mon.initSensors(this.checkMillis);
        for (Line line : this.cmprPowerLines) {
            line.setWarm(false);
        }
        for (Line line : this.loadPowerLines) {
            line.setWarm(false);
        }
        this.setMainPowerEnable(this.isCmprPowerOn() ? 1 : (this.isLoadPowerOn() ? -1 : 0));
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() {
        System.out.println("checkStarted was called");
    }

    public void checkStopped() {
        System.out.println("checkStopped was called");
    }

    public void startTicking() {
        this.mon.start();
        super.startTicking();
        this.publishState();
        this.mon.publishState();
        this.mon.publishLimits();
        System.out.println("Refrigeration heat exchanger test system started");
    }

    public void tick() {
        this.mon.publishData();
        this.setLoadPower();
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the tick interval")
    public void setTickMillis(int value) {
        super.setTickMillis(value);
        this.publishState();
    }

    public void processAlarm(int event, int parm) {
        switch (parm) {
            case 0: {
                if (event == 0) {
                    if ((this.state & 2) != 0) break;
                    this.state |= 2;
                    this.setMainPowerEnable(0);
                    this.publishState();
                    break;
                }
                if (event != 2 || (this.state & 2) == 0) break;
                this.state &= 0xFFFFFFFD;
                this.publishState();
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the main power enabled state")
    public void setMainPowerEnable(int value) {
        if (value != 0) {
            if ((this.state & 2) == 0) {
                this.state |= 1;
                this.state = value > 0 ? (this.state &= 0xFFFFFFDF) : (this.state |= 0x20);
            }
        } else {
            this.state &= 0xFFFFFFDE;
        }
        this.setMainPower();
        this.setLoadPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the load power enabled state")
    public void setLoadPowerEnable(int value) {
        if (this.loadPowerDevc != null) {
            this.state = value != 0 ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
            if (value < 0) {
                if (this.tempCtrl != null) {
                    this.state |= 0x10;
                    this.tempCtrl.setTemp(this.loadTemp);
                    if ((this.state & 1) != 0) {
                        this.startTempCtrl();
                    }
                }
            } else {
                this.state &= 0xFFFFFFEF;
                this.stopTempCtrl();
                this.setLoadPower();
            }
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the load trip enabled state")
    public void setLoadTripEnable(int value) {
        boolean enable;
        boolean bl = enable = value != 0;
        this.state = enable ? (this.state |= 8) : (this.state &= 0xFFFFFFF7);
        for (Channel chan : this.alarmDsabChans) {
            chan.enableAlarm(false, enable);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the load power set point")
    public void setLoadPower(double value) {
        this.loadPower = value;
        if (this.startPower != null) {
            this.startPower = this.loadPower;
        }
        this.setLoadPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the load temperature set point")
    public void setLoadTemp(double value) {
        this.loadTemp = value;
        if (this.tempCtrl != null) {
            this.tempCtrl.setTemp(this.loadTemp);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Saves the current configuration")
    public void saveConfiguration() throws IOException {
        this.getEnvironment().register(this.configName);
        this.mon.clearLimitChanges();
        this.mon.publishState();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the full refrigeration state")
    public RefrigFullState getFullState() {
        RefrigState refgState = new RefrigState(this.state, this.getTickMillis(), this.loadPower, this.loadTemp);
        MonitorFullState monState = this.mon.getFullState();
        return new RefrigFullState(refgState, monState);
    }

    private void publishState() {
        this.publish("RefrigState", new RefrigState(this.state, this.getTickMillis(), this.loadPower, this.loadTemp));
    }

    private void setMainPower() {
        boolean on = (this.state & 1) != 0;
        boolean loadOnly = (this.state & 0x20) != 0;
        for (Line line : this.cmprPowerLines) {
            line.set(on & !loadOnly);
        }
        for (Line line : this.loadPowerLines) {
            line.set(on);
        }
        if (this.loadPowerDevc != null) {
            if (on) {
                this.loadPowerDevc.enable();
                if ((this.state & 0x10) != 0) {
                    this.startTempCtrl();
                }
            } else {
                this.stopTempCtrl();
                this.loadPowerDevc.disable();
            }
        }
    }

    private void setLoadPower() {
        if (this.loadPowerDevc == null || !this.loadPowerDevc.isOnline()) {
            return;
        }
        this.loadPowerDevc.enableOutput(0, (this.state & 4) != 0);
        if ((this.state & 0x10) == 0) {
            this.loadPowerDevc.setPower(0, this.loadPower);
            this.startPower = this.loadPower;
        }
    }

    private boolean isCmprPowerOn() {
        if (this.cmprPowerLines.isEmpty()) {
            return false;
        }
        for (Line line : this.cmprPowerLines) {
            if (line.isSet()) continue;
            return false;
        }
        return true;
    }

    private boolean isLoadPowerOn() {
        if (this.loadPowerLines.isEmpty()) {
            return false;
        }
        for (Line line : this.loadPowerLines) {
            if (line.isSet()) continue;
            return false;
        }
        return true;
    }

    private void startTempCtrl() {
        if (this.tempCtrl != null) {
            if (this.startPower == null) {
                this.tempCtrl.restart();
            } else {
                this.tempCtrl.start(this.startPower);
                this.startPower = null;
            }
        }
    }

    private void stopTempCtrl() {
        if (this.tempCtrl != null) {
            this.tempCtrl.stop();
        }
    }

    private Object getComponent(String name, Class cls) {
        Object cmpt = this.getComponentByName(name);
        if (cmpt != null && !cls.isInstance(cmpt)) {
            cmpt = null;
        }
        return cmpt;
    }
}

