import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.Subscale;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.MCCDevice;
import org.lsst.ccs.subsystem.refrig.DcsDevice;
import org.lsst.ccs.subsystem.refrig.WUDevice;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Channel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig-subscale"]

builder.
    main (Subscale, argMap("main", 10000, 5000, "", ["CmprLine"],
                           ["LoadLine"], "Power", ["CryoCtrTmp"],
                           ["CryoCtrTmp"], "TempCtrl")) {

        TempCtrl   (TempControl, argMap(10, 1000, 120, 100, 4, 0, 0.05, 30000))

        Cmpr       (MCCDevice, argMap("TC_AI", "00087534"))

        Mod1       (MCCDevice, argMap("TC_AI", "00099707"))

        Mod2       (MCCDevice, argMap("TEMP", "018F9BA8"))

        Mod3       (MCCDevice, argMap("TEMP", "018F9BAA"))

        Power      (DcsDevice, argMap("FTDI", "A602LIHA"))

        WattsCmpr  (WUDevice, argMap(null, "A100KS6F"))

        CmprLine   (Line, argMap("Cmpr", 7, null, 0))

        LoadLine   (Line, argMap("Mod1", 0, null, 0))

        AlarmCmpr  (Alarm, argMap("Trips off all power", null, 0))

        CmprPower  (Channel,
                    argMap("Compressor\\Power", "Watts",
                           "WattsCmpr", 0, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        CmpDisPrs  (Channel,
                    argMap("Discharge pressure", "Psig",
                           "Cmpr", 6, "VOLTS", "1.25V", -5.0, 10000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        CmpSucPrs  (Channel,
                    argMap("Suction pressure", "Psig",
                           "Cmpr", 7, "VOLTS", "1.25V", -0.53, 1000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpDisTmp  (Channel,
                    argMap("Discharge temperature", "\u00b0C",
                           "Cmpr", 0, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        CmpRetnTmp (Channel,
                    argMap("C1 oil temperature", "\u00b0C",
                           "Cmpr", 1, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpSepTmp  (Channel,
                    argMap("Separator temperature", "\u00b0C",
                           "Cmpr", 2, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmprVolts  (Channel,
                    argMap("Line voltage", "Volts",
                           "WattsCmpr", 1, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmprFreq   (Channel,
                    argMap("Line frequency", "Hz",
                           "WattsCmpr", 2, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpFlowSwi (Channel,
                    argMap("Flow switch state", "",
                           "Cmpr", 1, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        CmpTmpRly  (Channel,
                    argMap("Temperature relay state", "",
                           "Cmpr", 2, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        C3LiqdTmp  (Channel,
                    argMap("Heat Exchanger\\C3 liq capillary temperature",
                           "\u00b0C",
                           "Mod1", 0, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PreC3Tmp   (Channel,
                    argMap("Pre C3 temperature", "\u00b0C",
                           "Mod2", 6, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PostC3Tmp  (Channel,
                    argMap("Post C3 temperature", "\u00b0C",
                           "Mod2", 7, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PreC4Tmp   (Channel,
                    argMap("Pre C4 temperature", "\u00b0C",
                           "Mod1", 1, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PostC4Tmp  (Channel,
                    argMap("Post C4 temperature", "\u00b0C",
                           "Mod1", 2, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        EvapVcrTmp (Channel,
                    argMap("Evaporator outlet VCR temp", "\u00b0C",
                           "Mod2", 5, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexVapPrs  (Channel,
                    argMap("Vapor supply pressure", "Psig",
                           "Mod1", 5, "VOLTS", "1.25V", 5.1, 5000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        HexLiqPrs  (Channel,
                    argMap("Liquid supply pressure", "Psig",
                           "Mod1", 4, "VOLTS", "1.25V", 0.3, 5000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        HexPrsDiff (Channel,
                    argMap("Vapor/liquid delta P", "Psi",
                           null, 0, "DIFF", "HexLiqPrs:HexVapPrs", 0, 0,
                           "none", aDbl(limitLo, 0.0), 0.0, null,
                           "none", aDbl(limitHi, 0.0), 0.0, null))

        HexSucPrs  (Channel,
                    argMap("Return pressure", "Psig",
                           "Mod1", 7, "VOLTS", "1.25V", 0.26, 1000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexExitTmp (Channel,
                    argMap("Return temperature", "\u00b0C",
                           "Mod2", 3, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadTmp1   (Channel,
                    argMap("Cryostat\\Load temperature 1 RTD", "\u00b0C",
                           "Mod3", 0, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadTmp2   (Channel,
                    argMap("Load temperature 2 RTD", "\u00b0C",
                           "Mod3", 2, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadTmp3   (Channel,
                    argMap("Load temperature 3 RTD", "\u00b0C",
                           "Mod2", 0, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadTmp4   (Channel,
                    argMap("Load temperature 4 RTD", "\u00b0C",
                           "Mod3", 4, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadTmp5   (Channel,
                    argMap("Load temperature 5 RTD", "\u00b0C",
                           "Mod3", 6, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadPower  (Channel,
                    argMap("Heat load power", "Watts",
                           "Power", 0, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadVolts  (Channel,
                    argMap("Heat load voltage", "Volts",
                           "Power", 1, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CryoCtrTmp (Channel,
                    argMap("Cryoplate center temperature", "\u00b0C",
                           "Mod2", 2, "TEMP", "TC:T", 0.0, 1.0,
                           "alarm", aDbl(limitLo, 0.0), 0.0, "AlarmCmpr",
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        GridFceTmp (Channel,
                    argMap("Grid face temperature", "\u00b0C",
                           "Mod2", 4, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HXRetnTmp  (Channel,
                    argMap("HX return line temperature", "\u00b0C",
                           "Mod1", 3, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        Running    (Channel,
                    argMap("Control Chassis\\Running state", "",
                           "Mod1", 6, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        Interlock  (Channel,
                    argMap("Interlock state", "",
                           "Mod1", 2, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        ThermRelay (Channel,
                    argMap("Thermal relay state", "",
                           "Mod1", 3, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        LoadEnable (Channel,
                    argMap("Load enable state", "",
                           "Mod1", 4, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        V5Power    (Channel,
                    argMap("5-Volt power state", "",
                           "Mod1", 5, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))
    }
