/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.refrig.PowerDevice;

public class SimDevice
extends Device {
    static final int MAIN_POWER_LINE = 0;
    static final int LOAD_POWER_LINE = 1;
    static final int N_DEV_CHANS = 64;
    static final int N_DEV_LINES = 8;
    static final double LOAD_POWER_FCTR = 6.667E-4;
    static SimDevice sim;
    static Power power;
    ChannelSim[] chanData = new ChannelSim[64];
    ChannelSim loadTmpChan;
    ChannelSim loadPwrChan;
    double loadFract = 0.6;
    boolean[] lineOn = new boolean[8];

    public SimDevice() {
        this.fullName = "Simulated devices";
        sim = this;
    }

    protected void initialize() {
        if (this.loadTmpChan == null) {
            this.log.error((Object)"No load temperature channel defined", new String[0]);
        }
        if (power == null && this.loadPwrChan == null) {
            this.log.error((Object)"No load power channel defined", new String[0]);
        }
        this.setOnline(true);
        this.initSensors();
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 64) {
            this.mon.reportError(name, "hw channel number", (Object)hwChan);
        }
        String[] flds = subtype.split(":");
        try {
            ChannelSim chan;
            double onValue = Double.valueOf(flds[0]);
            double onTime = Double.valueOf(flds[1]);
            double offValue = Double.valueOf(flds[2]);
            double offTime = Double.valueOf(flds[3]);
            this.chanData[hwChan] = chan = new ChannelSim(hwChan, onValue, onTime, offValue, offTime);
            if (name.equals("LoadTmp")) {
                this.loadTmpChan = chan;
            } else if (name.equals("LoadPower")) {
                this.loadPwrChan = chan;
            }
        }
        catch (Exception exception) {
            this.mon.reportError(name, "subtype", (Object)subtype);
        }
        return new int[2];
    }

    protected void initChannel(int hwChan, int type, int subtype) {
        this.chanData[hwChan].initialize();
    }

    protected double readChannel(int hwChan, int type) {
        ChannelSim chan = this.chanData[hwChan];
        chan.read();
        return chan.value;
    }

    protected void checkHwLine(String name, int line) throws Exception {
        if (line < 0 || line >= 8) {
            this.mon.reportError(name, "line number", (Object)line);
        }
    }

    protected void setHwLine(int line, boolean on) {
        this.lineOn[line] = on;
        System.out.print("Line states:");
        boolean[] blArray = this.lineOn;
        int n = this.lineOn.length;
        int n2 = 0;
        while (n2 < n) {
            boolean lon = blArray[n2];
            System.out.print(lon ? " on" : " off");
            ++n2;
        }
        System.out.println();
        if (line == 0) {
            this.setMainPower();
        } else if (line == 1) {
            this.setLoadPower();
        }
    }

    protected boolean isHwLineSet(int line) {
        return this.lineOn[line];
    }

    public void setLoadFract(double fract) {
        this.loadFract = fract;
        this.setLoadPower();
    }

    void setLoadTmpRate(double loadPower) {
        ChannelSim tc = this.loadTmpChan;
        if (tc != null) {
            tc.powerOn();
            tc.rate += 6.667E-4 * loadPower;
        }
    }

    private void setMainPower() {
        ChannelSim[] channelSimArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelSim chan = channelSimArray[n2];
            if (chan != null && chan != this.loadPwrChan) {
                chan.powerOn();
            }
            ++n2;
        }
        this.setLoadPower();
    }

    private void setLoadPower() {
        if (power != null) {
            power.powerOn(this.lineOn[1]);
        } else {
            if (this.loadPwrChan == null) {
                return;
            }
            double value = 0.0;
            if (this.lineOn[0] && this.lineOn[1]) {
                value = this.loadFract * this.loadPwrChan.onValue;
            }
            this.setLoadTmpRate(value);
            this.loadPwrChan.endValue = value;
            this.loadPwrChan.value = value;
        }
    }

    class ChannelSim {
        int hwChan;
        double onValue;
        double onTime;
        double offValue;
        double offTime;
        double endValue;
        double rate;
        boolean negative;
        double value;
        long currTime;

        public ChannelSim(int hwChan, double onValue, double onTime, double offValue, double offTime) {
            this.hwChan = hwChan;
            this.onValue = onValue;
            this.onTime = onTime;
            this.offValue = offValue;
            this.offTime = offTime;
            this.currTime = System.currentTimeMillis();
        }

        void initialize() {
            if (this == SimDevice.this.loadPwrChan) {
                this.onTime = 0.0;
                this.offValue = 0.0;
                this.offTime = 0.0;
            }
            this.endValue = this.offValue;
            this.value = this.offValue;
        }

        void read() {
            long thisTime = System.currentTimeMillis();
            double intvl = (double)(thisTime - this.currTime) / 1000.0;
            this.currTime = thisTime;
            this.value += this.rate * intvl;
            if (this.negative) {
                if (this.value < this.endValue) {
                    this.value = this.endValue;
                }
            } else if (this.value > this.endValue) {
                this.value = this.endValue;
            }
        }

        void powerOn() {
            this.currTime = System.currentTimeMillis();
            this.rate = 0.0;
            if (SimDevice.this.lineOn[0]) {
                this.endValue = this.onValue;
                if (this.onTime != 0.0) {
                    this.rate = (this.onValue - this.offValue) / this.onTime;
                }
            } else {
                this.endValue = this.offValue;
                if (this.offTime != 0.0) {
                    this.rate = (this.offValue - this.onValue) / this.offTime;
                }
            }
            if (this.rate == 0.0) {
                this.value = this.endValue;
            }
            this.negative = this.rate < 0.0;
        }
    }

    static class Power
    extends Device
    implements PowerDevice {
        private static final int N_DEV_CHANS = 3;
        private static final int CHAN_WATTS = 0;
        private static final int CHAN_VOLTS = 1;
        private static final int CHAN_AMPS = 2;
        private static final double LOAD_OHMS = 50.0;
        double setVolts;
        double setAmps;
        double loadVolts;
        double loadAmps;
        double loadWatts;
        boolean outputOn;

        public Power() {
            this.fullName = "Simulated power supply";
            power = this;
        }

        public void initialize() {
            if (!SimDevice.sim.lineOn[1]) {
                return;
            }
            this.setOnline(true);
            this.initSensors();
        }

        public void close() {
        }

        public int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
            if (hwChan < 0 || hwChan >= 3) {
                this.mon.reportError(name, "hw channel number", (Object)hwChan);
            }
            return new int[2];
        }

        public double readChannel(int hwChan, int type) {
            switch (hwChan) {
                case 0: {
                    return SimDevice.power.loadWatts;
                }
                case 1: {
                    return SimDevice.power.loadVolts;
                }
                case 2: {
                    return SimDevice.power.loadAmps;
                }
            }
            return 0.0;
        }

        @Override
        public void setVoltage(int chan, double value) {
            this.setVolts = value;
            this.setPower();
        }

        @Override
        public void setCurrent(int chan, double value) {
            this.setAmps = value;
            this.setPower();
        }

        @Override
        public void setOutput(int chan, boolean value) {
            this.outputOn = value;
            this.setPower();
        }

        @Override
        public double readVoltage(int chan) {
            return this.loadVolts;
        }

        @Override
        public double readCurrent(int chan) {
            return this.loadAmps;
        }

        @Override
        public boolean getOutput(int chan) {
            return this.outputOn;
        }

        void powerOn(boolean on) {
            if (!on) {
                this.setOutput(0, false);
            }
            this.setOnline(on);
        }

        private void setPower() {
            if (!this.outputOn) {
                this.loadVolts = 0.0;
                this.loadAmps = 0.0;
            } else {
                double amps = this.setVolts / 50.0;
                if (amps > this.setAmps) {
                    amps = this.setAmps;
                }
                this.loadVolts = amps * 50.0;
                this.loadAmps = amps;
            }
            this.loadWatts = this.loadVolts * this.loadAmps;
            sim.setLoadTmpRate(this.loadWatts);
        }
    }
}

