import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.Subscale;
import org.lsst.ccs.subsystem.refrig.SimDevice;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Channel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig-subscale"]

builder.
    main (Subscale, argMap("main", 10000, "sim")) {

        Sim        (SimDevice)

        Power      (SimDevice.Power)

        MainPower  (Line, argMap("Sim", 0, null, 0))

        LoadPower  (Line, argMap("Sim", 1, null, 0))

        Main       (Alarm, argMap(null, 0))

        CmpDisTmp  (Channel,
                    argMap("Compressor discharge temperature", "C",
                           "Sim", 0, "TEMP", "110: 120: 10: 1200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "alarm", aDbl(limitHi, 0), 0, "Main"))

        CmpRetnTmp (Channel,
                    argMap("Compressor oil return temperature", "C",
                           "Sim", 1, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpSepTmp  (Channel,
                    argMap("Compressor separator temperature", "C",
                           "Sim", 2, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpDisPrs  (Channel,
                    argMap("Compressor discharge pressure", "Psig",
                           "Sim", 3, "VOLTS", "300: 30: 50: 30", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        CmpSucPrs  (Channel,
                    argMap("Compressor suction pressure", "Psig",
                           "Sim", 4, "VOLTS", "10: 30: 50: 30", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        CmprPower  (Channel,
                    argMap("Compressor power", "Watts",
                           "Sim", 5, "POWER", "1050: 0: 0: 0", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        CmprVolts  (Channel,
                    argMap("Compressor line voltage", "Volts",
                           "Sim", 6, "POWER", "208: 0: 0: 0", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))
        LoadTmp1   (Channel,
                    argMap("Heat load temperature 1", "C",
                           "Sim", 7, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        LoadTmp2   (Channel,
                    argMap("Heat load temperature 2", "C",
                           "Sim", 8, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        LoadTmp3   (Channel,
                    argMap("Heat load temperature 3", "C",
                           "Sim", 9, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        LoadTmp4   (Channel,
                    argMap("Heat load temperature 4", "C",
                           "Sim", 10, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        LoadTmp5   (Channel,
                    argMap("Heat load temperature 5", "C",
                           "Sim", 11, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        C3LiqdTmp  (Channel,
                    argMap("C3 liquid cap temperature", "C",
                           "Sim", 12, "TEMP", "-120: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        PreC4Tmp   (Channel,
                    argMap("Pre C4 evaporator temperature", "C",
                           "Sim", 13, "TEMP", "-120: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        PostC4Tmp  (Channel,
                    argMap("Post C4 temperature", "C",
                           "Sim", 14, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PostCryTmp (Channel,
                    argMap("Post cryo temperature", "C",
                           "Sim", 15, "TEMP", "-110: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0), 0, null,
                           "flag", aDbl(limitHi, 0), 0, null))

        RelayTmp   (Channel,
                    argMap("Relay temperature", "C",
                           "Sim", 16, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexExitTmp (Channel,
                    argMap("HEX exit temperature", "C",
                           "Sim", 17, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CryFlxTmp1 (Channel,
                    argMap("Cryo flex hose temperature 1", "C",
                           "Sim", 18, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CryFlxTmp2 (Channel,
                    argMap("Cryo flex hose temperature 2", "C",
                           "Sim", 19, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        TubeMidTmp (Channel,
                    argMap("Tube midpoint temperature", "C",
                           "Sim", 20, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        AprnAmbTmp (Channel,
                    argMap("Apron ambient temperature", "C",
                           "Sim", 21, "TEMP", "-100: 1800: 25: 7200", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexLiqPrs  (Channel,
                    argMap("HEX liquid pressure", "Psig",
                           "Sim", 22, "VOLTS", "300: 30: 50: 30", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexVapPrs  (Channel,
                    argMap("HEX vapor pressure", "Psig",
                           "Sim", 23, "VOLTS", "300: 30: 50: 30", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexPrsDiff (Channel,
                    argMap("HEX liq/vap pressure difference", "Psi",
                           null, 0, "DIFF", "HexLiqPrs:HexVapPrs", 0, 0,
                           "none", aDbl(limitLo, 0.0), 0.0, null,
                           "none", aDbl(limitHi, 0.0), 0.0, null))

        PostC4Prs  (Channel,
                    argMap("Post C4 pressure", "Psig",
                           "Sim", 24, "VOLTS", "300: 30: 50: 30", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexSucPrs  (Channel,
                    argMap("HEX suction pressure", "Psig",
                           "Sim", 25, "VOLTS", "300: 30: 50: 30", 0, 1,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadPower  (Channel,
                    argMap("Heater power", "Watts",
                           "Power", 0, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadVolts  (Channel,
                    argMap("Heater voltage", "Volts",
                           "Power", 1, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

    }
