/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.subsystem.refrig.Device;

public class WUDevice
extends Device
implements WattsUp.Listener {
    static final int CHAN_WATTS = 0;
    static final int CHAN_VOLTS = 1;
    static final int N_DEV_CHANS = 2;
    static final int LOG_PERIOD = 1;
    String node;
    String serial;
    WattsUp wtu;
    double[] value;

    public WUDevice(String nodeName, String serialNo) {
        this.type = 1;
        this.node = nodeName;
        this.serial = serialNo;
        this.fullName = "WattsUp meter (" + (this.node == null ? "local" : this.node) + (this.serial == null ? "" : ":" + this.serial) + ")";
        this.value = new double[2];
    }

    @Override
    int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 2) {
            this.refg.reportError(name, "hw channel number", hwChan);
        }
        return new int[2];
    }

    @Override
    void initialize() {
        block8: {
            try {
                try {
                    if (!this.inited || this.wtu == null) {
                        this.wtu = new WattsUp();
                        this.wtu.addListener((WattsUp.Listener)this);
                    }
                    this.wtu.open(this.node, 0, this.serial);
                    this.wtu.restart();
                    this.setOnline(true);
                    String message = "Connected to " + this.fullName;
                    if (!this.inited) {
                        this.log.info((Object)message, new String[0]);
                        break block8;
                    }
                    this.log.error((Object)message, new String[0]);
                }
                catch (Exception e) {
                    if (!this.inited) {
                        this.log.error((Object)("Error connecting to " + this.fullName + ": " + e), new String[0]);
                    }
                    this.inited = true;
                }
            }
            finally {
                this.inited = true;
            }
        }
    }

    @Override
    void initChannel(int chan, int type, int subtype) {
    }

    @Override
    double readChannel(int chan) {
        return this.value[chan];
    }

    @Override
    void close() {
    }

    public void setPowered(boolean on) {
        if (on) {
            try {
                this.wtu.setLoggedFields(3);
                this.wtu.setExternalLogging(1);
            }
            catch (Exception e) {
                this.log.error((Object)("Error configuring " + this.fullName + ": " + e), new String[0]);
            }
        } else {
            int j = 0;
            while (j < 2) {
                this.value[j] = 0.0;
                ++j;
            }
        }
    }

    public void setClosed() {
        this.setOnline(false);
        this.log.error((Object)("Disconnected from " + this.fullName), new String[0]);
    }

    public void processData(float[] data) {
        this.value[0] = data[0];
        this.value[1] = data[1];
    }
}

