/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.subsystem.refrig.Device;

public class SimDevice
extends Device {
    static final int MAIN_POWER_LINE = 0;
    static final int LOAD_POWER_LINE = 1;
    static final int N_DEV_CHANS = 24;
    static final int N_DEV_LINES = 2;
    static final double LOAD_POWER_FCTR = 6.667E-4;
    ChannelSim[] chanData = new ChannelSim[24];
    ChannelSim loadPwrChan;
    ChannelSim loadTmpChan;
    double loadFract = 0.6;
    boolean mainPowerOn;
    boolean loadPowerOn;
    int lineMask;

    public SimDevice(String devName, String serialNo) {
    }

    @Override
    int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 24) {
            this.refg.reportError(name, "hw channel number", hwChan);
        }
        String[] flds = subtype.split(":");
        try {
            ChannelSim chan;
            double onValue = Double.valueOf(flds[0]);
            double onTime = Double.valueOf(flds[1]);
            double offValue = Double.valueOf(flds[2]);
            double offTime = Double.valueOf(flds[3]);
            this.chanData[hwChan] = chan = new ChannelSim(hwChan, onValue, onTime, offValue, offTime);
            if (name.equals("LoadPower")) {
                this.loadPwrChan = chan;
            } else if (name.equals("LoadTmp")) {
                this.loadTmpChan = chan;
            }
        }
        catch (Exception exception) {
            this.refg.reportError(name, "subtype", subtype);
        }
        return new int[2];
    }

    @Override
    void initialize() {
        if (this.loadPwrChan == null) {
            this.log.warn((Object)"No load power channel defined", new String[0]);
        }
        if (this.loadTmpChan == null) {
            this.log.warn((Object)"No load temperature channel defined", new String[0]);
        }
        this.setOnline(true);
        this.initSensors();
    }

    @Override
    void initChannel(int hwChan, int type, int subtype) {
        this.chanData[hwChan].initialize();
    }

    @Override
    double readChannel(int hwChan) {
        ChannelSim chan = this.chanData[hwChan];
        chan.read();
        return chan.value;
    }

    @Override
    void checkLine(String name, int line) throws Exception {
        if (line < 0 || line >= 2) {
            this.refg.reportError(name, "line number", line);
        }
    }

    @Override
    void addLine(int line) {
        this.lineMask |= 1 << line;
    }

    @Override
    void setLine(int line, boolean on) {
        if (line == 0) {
            this.setMainPower(on);
        } else if (line == 1) {
            this.setLoadPower(on);
        }
    }

    @Override
    boolean isLineSet(int line) {
        if (line == 0) {
            return this.mainPowerOn;
        }
        if (line == 1) {
            return this.loadPowerOn;
        }
        return false;
    }

    @Override
    void close() {
    }

    public void setLoadFract(double fract) {
        this.loadFract = fract;
        this.setLoadPower();
    }

    void setMainPower(boolean on) {
        this.mainPowerOn = on;
        ChannelSim[] channelSimArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelSim chan = channelSimArray[n2];
            if (chan != null && chan != this.loadPwrChan) {
                chan.powerOn();
            }
            ++n2;
        }
        this.setLoadPower();
    }

    void setLoadPower(boolean on) {
        this.loadPowerOn = on;
        this.setLoadPower();
    }

    void setLoadPower() {
        if (this.loadPwrChan == null) {
            return;
        }
        double endValue = 0.0;
        if (this.mainPowerOn) {
            ChannelSim tc;
            if (this.loadPowerOn) {
                endValue = this.loadFract * this.loadPwrChan.onValue;
            }
            if ((tc = this.loadTmpChan) != null && tc.onTime != 0.0) {
                tc.rate = (tc.onValue - tc.offValue) / tc.onTime + 6.667E-4 * endValue;
            }
        }
        this.loadPwrChan.endValue = endValue;
        this.loadPwrChan.value = endValue;
    }

    class ChannelSim {
        int hwChan;
        double onValue;
        double onTime;
        double offValue;
        double offTime;
        double endValue;
        double rate;
        boolean negative;
        double value;
        long currTime;

        public ChannelSim(int hwChan, double onValue, double onTime, double offValue, double offTime) {
            this.hwChan = hwChan;
            this.onValue = onValue;
            this.onTime = onTime;
            this.offValue = offValue;
            this.offTime = offTime;
            this.currTime = System.currentTimeMillis();
        }

        void initialize() {
            if (this == SimDevice.this.loadPwrChan) {
                this.onTime = 0.0;
                this.offValue = 0.0;
                this.offTime = 0.0;
            }
            this.endValue = this.offValue;
            this.value = this.offValue;
        }

        void read() {
            long thisTime = System.currentTimeMillis();
            double intvl = (double)(thisTime - this.currTime) / 1000.0;
            this.currTime = thisTime;
            this.value += this.rate * intvl;
            if (this.negative) {
                if (this.value < this.endValue) {
                    this.value = this.endValue;
                }
            } else if (this.value > this.endValue) {
                this.value = this.endValue;
            }
        }

        void powerOn() {
            this.currTime = System.currentTimeMillis();
            this.rate = 0.0;
            if (SimDevice.this.mainPowerOn) {
                this.endValue = this.onValue;
                if (this.onTime != 0.0) {
                    this.rate = (this.onValue - this.offValue) / this.onTime;
                }
            } else {
                this.endValue = this.offValue;
                if (this.offTime != 0.0) {
                    this.rate = (this.offValue - this.onValue) / this.offTime;
                }
            }
            if (this.rate == 0.0) {
                this.value = this.endValue;
            }
            this.negative = this.rate < 0.0;
        }
    }
}

