/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.refrig.Device;
import org.lsst.ccs.subsystem.refrig.MonChannel;
import org.lsst.ccs.subsystem.refrig.OutputLine;
import org.lsst.ccs.subsystem.refrig.data.RefrigChannel;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.status.RefrigStateStatus;
import org.lsst.ccs.utilities.logging.Logger;

public class RefrigTest
extends Module {
    static final long UPDATE_PERIOD = 1000L;
    static final long CHECK_PERIOD = 10000L;
    int numChans;
    MonChannel[] chanData;
    String configName = "test";
    boolean coldStart;
    boolean running;
    BitSet loLimChange = new BitSet();
    BitSet hiLimChange = new BitSet();
    BitSet goodChans = new BitSet();
    BitSet onlineChans = new BitSet();
    int state;
    Map<String, Device> devcMap;
    List<Device> devcList = new ArrayList<Device>();
    OutputLine mainPowerLine;
    OutputLine loadPowerLine;
    List<OutputLine> alarmLine = new ArrayList<OutputLine>();

    public RefrigTest(String name, int tickMillis, String configName) {
        super(name, tickMillis);
        this.configName = configName;
        String cold = System.getProperty("lsst.ccs.refrig.coldstart", "");
        this.coldStart = cold.equals("true");
    }

    public void initModule() {
        this.initConfiguration();
        this.initSensors();
        this.setOutputLines();
        this.coldStart = false;
        new Timer(true).schedule((TimerTask)new UpdateState(), 0L, 1000L);
    }

    public void tick() {
        if (!this.running) {
            System.out.println("Refrigeration test system started");
            this.publishState();
            this.publishLimits();
            this.running = true;
        }
        long timeStamp = System.currentTimeMillis();
        ArrayList<ValueNotification> trendingValues = new ArrayList<ValueNotification>();
        MonChannel[] monChannelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            MonChannel ch = monChannelArray[n2];
            trendingValues.add(new ValueNotification(ch.getName(), (Object)ch.value, timeStamp));
            ++n2;
        }
        trendingValues.add(new ValueNotification("state", (Object)this.getState(), timeStamp));
        this.publishData(trendingValues);
    }

    public void setTickMillis(int value) {
        super.setTickMillis(value);
        if (this.running) {
            this.publishState();
        }
    }

    public void setMainPowerEnable(int value) {
        this.setMainPowerEnable(value, true);
    }

    public void setMainPowerEnable(int value, boolean publish) {
        boolean on = false;
        if (value != 0) {
            if ((this.state & 2) == 0) {
                this.state |= 1;
                on = true;
            }
        } else {
            this.state &= 0xFFFFFFFE;
        }
        this.setMainPower(on);
        if (publish) {
            this.publishState();
        }
    }

    public void setLoadTripEnable(int value) {
        this.state = value != 0 ? (this.state |= 8) : (this.state &= 0xFFFFFFF7);
        this.publishState();
    }

    public void saveConfiguration() throws IOException {
        this.register(this.configName, "");
        this.loLimChange.clear();
        this.hiLimChange.clear();
        this.publishState();
    }

    public RefrigFullState getFullState() {
        RefrigFullState status = new RefrigFullState();
        MonChannel[] monChannelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            MonChannel ch = monChannelArray[n2];
            status.addChannel(new RefrigChannel(ch.getName(), ch.description, ch.units, ch.limitLo, ch.limitHi, ch.value));
            ++n2;
        }
        status.setRefrigState(new RefrigState(this.state, this.goodChans, this.onlineChans, this.loLimChange, this.hiLimChange, this.getTickMillis()));
        return status;
    }

    void setOutputLines() {
        this.setMainPowerEnable(!this.coldStart && this.isMainPowerOn() ? 1 : 0, this.running);
        this.setLoadPower((this.state & 4) != 0);
        this.setDisplay(null, this.goodChans);
    }

    int getState() {
        return this.state;
    }

    void publishState() {
        RefrigState refrigState = new RefrigState(this.state, this.goodChans, this.onlineChans, this.loLimChange, this.hiLimChange, this.getTickMillis());
        this.sendToStatus((Status)new RefrigStateStatus(refrigState));
    }

    void publishLimits() {
        MonChannel[] monChannelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            MonChannel ch = monChannelArray[n2];
            this.getSubsystem().publishMetaData(ch.getName(), "alarmLow", String.valueOf(ch.limitLo));
            this.getSubsystem().publishMetaData(ch.getName(), "alarmHigh", String.valueOf(ch.limitHi));
            ++n2;
        }
    }

    void checkLimits() {
        int sState = (this.state | 4) & 0xFFFFFFFD;
        BitSet chanState = new BitSet(this.numChans);
        MonChannel[] monChannelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            MonChannel ch = monChannelArray[n2];
            sState = ch.checkLimits(sState, chanState);
            ++n2;
        }
        boolean update = false;
        this.state ^= (sState ^= this.state);
        if (sState != 0) {
            if ((sState & 2) != 0 && (this.state & 2) != 0) {
                this.setMainPowerEnable(0, false);
            }
            if ((sState & 4) != 0) {
                this.setLoadPower((this.state & 4) != 0);
            }
            update = true;
        }
        chanState.xor(this.goodChans);
        this.goodChans.xor(chanState);
        if (!chanState.isEmpty()) {
            this.setDisplay(chanState, this.goodChans);
            update = true;
        }
        if (update && this.running) {
            this.publishState();
            this.tick();
        }
    }

    int findChannelId(String name) {
        MonChannel[] monChannelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            MonChannel ch = monChannelArray[n2];
            if (ch.getName().equals(name)) {
                return ch.id;
            }
            ++n2;
        }
        return -1;
    }

    MonChannel getChannel(int id) {
        return this.chanData[id];
    }

    void setOnline(BitSet mask, boolean online) {
        BitSet prevOnline = (BitSet)this.onlineChans.clone();
        if (online) {
            this.onlineChans.or(mask);
        } else {
            this.onlineChans.andNot(mask);
        }
        if (!this.onlineChans.equals(prevOnline)) {
            this.publishState();
        }
    }

    int getNumChans() {
        return this.numChans;
    }

    Logger getLogger() {
        return log;
    }

    void reportError(String cName, String pName, Object pValue) throws Exception {
        log.error((Object)("Invalid " + pName + " (" + pValue + ") for " + cName), new String[0]);
        throw new Exception();
    }

    void initConfiguration() {
        this.devcMap = this.getChildren(Device.class);
        for (Device devc : this.devcMap.values()) {
            this.devcList.add(devc);
            devc.configure(this);
        }
        int id = 0;
        for (OutputLine line : this.getChildren(OutputLine.class).values()) {
            line.configure(this, id++);
            if (line.type == 0) {
                this.mainPowerLine = line;
                continue;
            }
            if (line.type == 1) {
                this.loadPowerLine = line;
                continue;
            }
            if (line.type != 2) continue;
            this.alarmLine.add(line);
        }
        Map chanMap = this.getChildren(MonChannel.class);
        this.chanData = new MonChannel[chanMap.size()];
        id = 0;
        for (MonChannel ch : chanMap.values()) {
            ch.configure(this, id);
            this.chanData[id++] = ch;
        }
        MonChannel[] monChannelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            MonChannel ch;
            ch = monChannelArray[n2];
            ch.configDerived();
            ++n2;
        }
    }

    void initSensors() {
        for (Device devc : this.devcList) {
            devc.initialize();
        }
        new Timer(true).schedule((TimerTask)new CheckDevices(), 0L, 10000L);
    }

    void readSensors() {
        MonChannel ch;
        MonChannel[] monChannelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            ch = monChannelArray[n2];
            ch.readSensor();
            ++n2;
        }
        monChannelArray = this.chanData;
        n = this.chanData.length;
        n2 = 0;
        while (n2 < n) {
            ch = monChannelArray[n2];
            ch.calcDerived();
            ++n2;
        }
    }

    void setMainPower(boolean on) {
        if (this.mainPowerLine == null) {
            return;
        }
        this.mainPowerLine.set(on);
    }

    void setLoadPower(boolean on) {
        if (this.loadPowerLine == null) {
            return;
        }
        this.loadPowerLine.set(on);
    }

    boolean isMainPowerOn() {
        boolean on = false;
        if (this.mainPowerLine != null) {
            on = this.mainPowerLine.isSet();
        }
        return on;
    }

    boolean isLoadPowerOn() {
        boolean on = false;
        if (this.loadPowerLine != null) {
            on = this.loadPowerLine.isSet();
        }
        return on;
    }

    void setDisplay(BitSet mask, BitSet state) {
        MonChannel[] monChannelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            MonChannel ch = monChannelArray[n2];
            if (ch.alarm >= 0 && (mask == null || mask.get(ch.id))) {
                this.alarmLine.get(ch.alarm).set(state.get(ch.id));
            }
            ++n2;
        }
    }

    void setAlarm(int alarm, boolean on) {
        if (alarm < 0 || alarm >= this.alarmLine.size()) {
            return;
        }
        this.alarmLine.get(alarm).set(on);
    }

    boolean checkAlarm(int alarm) {
        return alarm < this.alarmLine.size();
    }

    Device getDevice(String name) {
        return this.devcMap.get(name);
    }

    private class CheckDevices
    extends TimerTask {
        private CheckDevices() {
        }

        @Override
        public void run() {
            for (Device devc : RefrigTest.this.devcList) {
                devc.checkOnline();
            }
        }
    }

    private class UpdateState
    extends TimerTask {
        private UpdateState() {
        }

        @Override
        public void run() {
            RefrigTest.this.readSensors();
            RefrigTest.this.checkLimits();
        }
    }
}

