/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.subsystem.refrig.Device;
import org.lsst.ccs.subsystem.refrig.RefrigTest;
import org.lsst.ccs.utilities.logging.Logger;

public class OutputLine
extends ConfigurableComponent {
    static final int TYPE_UNKNOWN = -1;
    static final int TYPE_MAIN_POWER = 0;
    static final int TYPE_LOAD_POWER = 1;
    static final int TYPE_ALARM = 2;
    String typeS;
    String devcName;
    int chan;
    String devcNameC;
    int chanC;
    int type;
    Device device;
    Device deviceC;
    Logger log;
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();

    static {
        typeMap.put("MAIN", 0);
        typeMap.put("LOAD", 1);
        typeMap.put("ALARM", 2);
    }

    public OutputLine(String type, String devcName, int chan, String devcNameC, int chanC) {
        this.typeS = type;
        this.devcName = devcName;
        this.chan = chan;
        this.devcNameC = devcNameC;
        this.chanC = chanC;
    }

    void configure(RefrigTest refg, int id) {
        try {
            Integer iType = typeMap.get(this.typeS);
            if (iType == null) {
                refg.reportError(this.getName(), "type", this.typeS);
            }
            this.type = iType;
            if (this.devcName != null) {
                this.device = refg.getDevice(this.devcName);
                if (this.device == null) {
                    refg.reportError(this.getName(), "device", this.devcName);
                }
                this.device.checkLine(this.getName(), this.chan);
                this.device.addLine(id);
            }
            if (this.devcNameC != null) {
                this.deviceC = refg.getDevice(this.devcNameC);
                if (this.deviceC == null) {
                    refg.reportError(this.getName(), "device", this.devcNameC);
                }
                this.deviceC.checkLine(this.getName(), this.chanC);
                this.deviceC.addLine(id);
            }
        }
        catch (Exception exception) {}
    }

    void set(boolean on) {
        if (this.device != null && this.device.online) {
            this.device.setLine(this.chan, on);
        }
        if (this.deviceC != null && this.deviceC.online) {
            this.deviceC.setLine(this.chanC, !on);
        }
    }

    boolean isSet() {
        boolean state = false;
        if (this.device != null && this.device.online) {
            state = this.device.isLineSet(this.chan);
        } else if (this.deviceC != null && this.deviceC.online) {
            state = !this.deviceC.isLineSet(this.chanC);
        }
        return state;
    }
}

