/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.BitSet;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.subsystem.refrig.MonChannel;

public abstract class Monitor {
    static final long UPDATE_PERIOD = 1000L;
    int numChans;
    MonChannel[] chanData;
    BitSet loLimChange = new BitSet();
    BitSet hiLimChange = new BitSet();
    BitSet goodChans = new BitSet();
    BitSet onlineChans = new BitSet();
    int state;

    public void start() {
        new Timer(true).schedule((TimerTask)new UpdateState(), 0L, 1000L);
    }

    void publishLimits() {
    }

    void checkLimits() {
        int sState = (this.state | 4) & 0xFFFFFFFD;
        BitSet chanState = new BitSet(this.numChans);
        MonChannel[] monChannelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            MonChannel ch = monChannelArray[n2];
            sState = ch.checkLimits(sState, chanState);
            ++n2;
        }
        this.state ^= (sState ^= this.state);
        if (sState == 0 || (sState & 2) != 0) {
            // empty if block
        }
        chanState.xor(this.goodChans);
        this.goodChans.xor(chanState);
        if (!chanState.isEmpty()) {
            // empty if block
        }
    }

    int findChannelId(String name) {
        MonChannel[] monChannelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            MonChannel ch = monChannelArray[n2];
            if (ch.getName().equals(name)) {
                return ch.id;
            }
            ++n2;
        }
        return -1;
    }

    MonChannel getChannel(int id) {
        return this.chanData[id];
    }

    void setOnline(BitSet mask, boolean online) {
        BitSet prevOnline = (BitSet)this.onlineChans.clone();
        if (online) {
            this.onlineChans.or(mask);
        } else {
            this.onlineChans.andNot(mask);
        }
        this.onlineChans.equals(prevOnline);
    }

    int getNumChans() {
        return this.numChans;
    }

    void reportError(String cName, String pName, Object pValue) throws Exception {
        throw new Exception();
    }

    abstract void initConfiguration();

    abstract void initSensors();

    abstract void readSensors();

    private class UpdateState
    extends TimerTask {
        private UpdateState() {
        }

        @Override
        public void run() {
            Monitor.this.readSensors();
            Monitor.this.checkLimits();
        }
    }
}

