/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystem.refrig.Device;
import org.lsst.ccs.subsystem.refrig.RefrigTest;
import org.lsst.ccs.utilities.logging.Logger;

public class MonChannel
extends ConfigurableComponent {
    static final int TYPE_UNKNOWN = -1;
    static final int TYPE_TEMP = 0;
    static final int TYPE_VOLTS = 1;
    static final int TYPE_POWER = 2;
    static final int TYPE_SWITCH = 3;
    static final int TYPE_DIFF = 4;
    static final int LIMIT_CHECK_NONE = 0;
    static final int LIMIT_CHECK_FLAG = 1;
    static final int LIMIT_CHECK_MAIN_TRIP = 2;
    static final int LIMIT_CHECK_LOAD_TRIP = 3;
    private static final Map<String, Integer> checkMap = new HashMap<String, Integer>();
    String description;
    String units;
    String loCheckS;
    String hiCheckS;
    double deadbandLo;
    double deadbandHi;
    String devcName;
    int hwChan;
    String typeS;
    String subtypeS;
    int alarm;
    double offset;
    double scale;
    double limitLo;
    double limitHi;
    int loCheck;
    int hiCheck;
    Device devc;
    int type;
    int subtype;
    int id;
    RefrigTest refg;
    Logger log;
    double value;
    boolean trippedLo;
    boolean trippedHi;

    static {
        checkMap.put("NONE", 0);
        checkMap.put("FLAG", 1);
        checkMap.put("MTRIP", 2);
        checkMap.put("LTRIP", 3);
    }

    public MonChannel(String desc, String units, String loCheck, double limitLo, double deadbandLo, String hiCheck, double limitHi, double deadbandHi, String devcName, int hwChan, String type, String subtype, int alarm, double offset, double scale) {
        this.description = desc;
        this.units = units;
        this.loCheckS = loCheck;
        this.hiCheckS = hiCheck;
        this.limitLo = limitLo;
        this.deadbandLo = deadbandLo;
        this.limitHi = limitHi;
        this.deadbandHi = deadbandHi;
        this.devcName = devcName;
        this.hwChan = hwChan;
        this.typeS = type;
        this.subtypeS = subtype;
        this.alarm = alarm;
        this.offset = offset;
        this.scale = scale;
    }

    void configure(RefrigTest refg, int id) {
        this.refg = refg;
        this.id = id;
        this.log = refg.getLogger();
        int iLoCheck = 1;
        int iHiCheck = 1;
        int iType = -1;
        int iSubtype = -1;
        int iChan = -1;
        int iAlarm = -1;
        try {
            Integer iCheck = checkMap.get(this.loCheckS.toUpperCase());
            if (iCheck == null) {
                refg.reportError(this.getName(), "locheck", this.loCheckS);
            }
            iLoCheck = iCheck;
            iCheck = checkMap.get(this.hiCheckS.toUpperCase());
            if (iCheck == null) {
                refg.reportError(this.getName(), "hicheck", this.hiCheckS);
            }
            iHiCheck = iCheck;
            this.devc = refg.getDevice(this.devcName);
            if (this.devc == null) {
                refg.reportError(this.getName(), "device", this.devcName);
            }
            int[] types = this.devc.checkChannel(this.getName(), this.hwChan, this.typeS, this.subtypeS);
            iChan = this.hwChan;
            iType = types[0];
            iSubtype = types[1];
            this.devc.addChannel(id);
            if (!refg.checkAlarm(this.alarm)) {
                refg.reportError(this.getName(), "alarm number", this.alarm);
            }
            iAlarm = this.alarm;
        }
        catch (Exception exception) {}
        this.loCheck = iLoCheck;
        this.hiCheck = iHiCheck;
        this.type = iType;
        this.subtype = iSubtype;
        this.hwChan = iChan;
        this.alarm = iAlarm;
    }

    void configDerived() {
        if (this.type != 4) {
            return;
        }
        String[] names = this.subtypeS.split(":", -1);
        boolean okay = false;
        if (names.length == 2) {
            int id0 = this.refg.findChannelId(names[0]);
            int id1 = this.refg.findChannelId(names[1]);
            if (id0 >= 0 && id1 >= 0) {
                this.subtype = id0 << 16 | id1;
                okay = true;
                BitSet mask = new BitSet();
                mask.set(this.id);
                this.refg.setOnline(mask, true);
            }
        }
        if (!okay) {
            this.log.error((Object)("Invalid subtype (" + this.subtypeS + ") for " + this.getName()), new String[0]);
            this.type = -1;
        }
    }

    void initSensor() {
        if (this.devc != null) {
            this.devc.initChannel(this.hwChan, this.type, this.subtype);
        }
    }

    void readSensor() {
        if (this.devc != null) {
            this.value = this.offset + this.scale * this.devc.readChannel(this.hwChan);
        }
    }

    void calcDerived() {
        if (this.type != 4) {
            return;
        }
        this.value = this.refg.getChannel((int)(this.subtype >> 16)).value - this.refg.getChannel((int)(this.subtype & 0xFFFF)).value;
    }

    @ConfigChanger
    public void setLimitLo(double limit) {
        if (limit == this.limitLo) {
            return;
        }
        this.limitLo = limit;
        this.refg.loLimChange.set(this.id);
        this.refg.publishState();
        this.refg.getSubsystem().publishMetaData(this.getName(), "alarmLow", String.valueOf(limit));
    }

    @ConfigChanger
    public void setLimitHi(double limit) {
        if (limit == this.limitHi) {
            return;
        }
        this.limitHi = limit;
        this.refg.hiLimChange.set(this.id);
        this.refg.publishState();
        this.refg.getSubsystem().publishMetaData(this.getName(), "alarmHigh", String.valueOf(limit));
    }

    int checkLimits(int sState, BitSet cState) {
        boolean ok = false;
        if (this.value < this.limitLo) {
            if (this.loCheck == 0) {
                ok = true;
            } else if (this.loCheck == 2) {
                sState |= 2;
            } else if (this.loCheck == 3 && (sState & 8) != 0) {
                sState &= 0xFFFFFFFB;
                this.trippedLo = true;
            }
        } else if (this.value > this.limitHi) {
            if (this.hiCheck == 0) {
                ok = true;
            } else if (this.hiCheck == 2) {
                sState |= 2;
            } else if (this.hiCheck == 3 && (sState & 8) != 0) {
                sState &= 0xFFFFFFFB;
                this.trippedHi = true;
            }
        } else {
            boolean tripped;
            ok = true;
            if (this.loCheck == 3) {
                tripped = false;
                if ((sState & 8) != 0 && this.trippedLo && this.value < this.limitLo + this.deadbandLo) {
                    sState &= 0xFFFFFFFB;
                    tripped = true;
                }
                this.trippedLo = tripped;
            }
            if (this.hiCheck == 3) {
                tripped = false;
                if ((sState & 8) != 0 && this.trippedHi && this.value > this.limitHi - this.deadbandHi) {
                    sState &= 0xFFFFFFFB;
                    tripped = true;
                }
                this.trippedHi = tripped;
            }
        }
        if (ok) {
            cState.set(this.id);
        }
        return sState;
    }
}

