/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEncodingException;
import javax.usb.UsbException;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import javax.usb.UsbNotOpenException;
import org.lsst.ccs.drivers.mcc.MccUsb;
import org.lsst.ccs.subsystem.refrig.Device;

public class MCCDevice
extends Device {
    static final int N_DEV_CHANS = 8;
    static final float[] RTD_COEFFS = new float[]{100.0f, 0.003908f, -5.8019E-7f, -4.2735E-12f};
    private static final Map<String, Integer> didMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> typeMap;
    private static final Map<String, Integer> tSbTypMap;
    private static final Map<String, Integer> tcSbTypMap;
    private static final Map<String, Integer> rtSbTypMap;
    private static final Map<String, Integer> vSbTypMap;
    String dName;
    String serial;
    int did;
    MccUsb mcc;
    int tcMask;
    int rtMask;
    int vMask;
    int lineMask;

    static {
        didMap.put("TC_AI", 0);
        didMap.put("TC", 1);
        didMap.put("TEMP", 2);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("TEMP", 0);
        typeMap.put("VOLTS", 1);
        typeMap.put("SWITCH", 3);
        tSbTypMap = new HashMap<String, Integer>();
        tSbTypMap.put("TC", 2);
        tSbTypMap.put("RTD", 0);
        tcSbTypMap = new HashMap<String, Integer>();
        tcSbTypMap.put("J", 0);
        tcSbTypMap.put("K", 1);
        tcSbTypMap.put("T", 2);
        tcSbTypMap.put("E", 3);
        tcSbTypMap.put("R", 4);
        tcSbTypMap.put("S", 5);
        tcSbTypMap.put("B", 6);
        tcSbTypMap.put("N", 7);
        rtSbTypMap = new HashMap<String, Integer>();
        rtSbTypMap.put("2WIRE1", 0);
        rtSbTypMap.put("2WIRE2", 1);
        rtSbTypMap.put("3WIRE", 2);
        rtSbTypMap.put("4WIRE", 3);
        vSbTypMap = new HashMap<String, Integer>();
        vSbTypMap.put("10V", 2);
        vSbTypMap.put("5V", 3);
        vSbTypMap.put("2.5V", 4);
        vSbTypMap.put("1.25V", 5);
    }

    public MCCDevice(String devName, String serialNo) {
        this.type = 0;
        this.dName = devName;
        this.serial = serialNo;
        this.fullName = "MCC " + this.dName + " module" + (this.serial == null ? "" : " (" + this.serial + ")");
        Integer iDid = didMap.get(this.dName);
        if (iDid == null) {
            this.log.error((Object)("Invalid MCC device type (" + this.dName + ")"), new String[0]);
            this.did = -1;
        } else {
            this.did = iDid;
            if (this.did == 0) {
                this.tcMask = 15;
                this.vMask = 240;
            } else if (this.did == 1) {
                this.tcMask = 255;
            } else if (this.did == 2) {
                this.tcMask = 255;
                this.rtMask = 255;
            }
        }
    }

    @Override
    int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iSubtype = 0;
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            this.refg.reportError(name, "type", type);
        }
        String sbtype = subtype.toUpperCase();
        if (iType == 0) {
            Integer iStp;
            String[] sbtypes = sbtype.split(":", -1);
            if (sbtypes.length < 2) {
                this.refg.reportError(name, "subtype", subtype);
            }
            if ((iSubtype = tSbTypMap.get(sbtypes[0])) == null) {
                this.refg.reportError(name, "subtype", subtype);
            }
            Integer n = iStp = iSubtype == 0 ? rtSbTypMap.get(sbtypes[1]) : tcSbTypMap.get(sbtypes[1]);
            if (iStp == null) {
                this.refg.reportError(name, "subtype", subtype);
            }
            iSubtype = iSubtype | iStp << 8;
        } else if (iType == 1 && (iSubtype = vSbTypMap.get(sbtype)) == null) {
            this.refg.reportError(name, "subtype", subtype);
        }
        boolean chanOk = true;
        if (iType == 0) {
            int mask;
            int n = mask = (iSubtype & 0xFF) == 0 ? this.rtMask : this.tcMask;
            if ((1 << hwChan & mask) == 0) {
                chanOk = false;
            }
        } else if (iType == 1) {
            if ((1 << hwChan & this.vMask) == 0) {
                chanOk = false;
            }
        } else if (hwChan < 0 || hwChan >= 8) {
            chanOk = false;
        }
        if (!chanOk) {
            this.refg.reportError(name, "hw channel number", hwChan);
        }
        return new int[]{iType, iSubtype};
    }

    @Override
    void initialize() {
        block16: {
            if (this.did < 0) {
                return;
            }
            try {
                try {
                    int j;
                    if (!this.inited || this.mcc == null) {
                        this.mcc = new MccUsb();
                    }
                    this.mcc.open(this.did, this.serial, true);
                    this.mcc.blink();
                    this.mcc.dioConfig(0);
                    if (this.did == 0) {
                        j = 0;
                        while (j < 8) {
                            this.mcc.configAlarm(j, 0, 0, 0.0f, 0.0f);
                            ++j;
                        }
                    } else if (this.did == 2) {
                        j = 0;
                        while (j < 8) {
                            this.mcc.setSensorType(j, 4);
                            j += 2;
                        }
                    }
                    this.setOnline(true);
                    this.initSensors();
                    if (this.lineMask != 0) {
                        this.setOutputLines();
                    }
                    String message = "Connected to " + this.fullName;
                    if (!this.inited) {
                        this.log.info((Object)message, new String[0]);
                        break block16;
                    }
                    this.log.error((Object)message, new String[0]);
                }
                catch (Exception e) {
                    MCCDevice.checkUsbException(e);
                    if (!this.inited) {
                        this.log.error((Object)("Error connecting to " + this.fullName + ": " + e), new String[0]);
                    }
                    if (this.mcc != null) {
                        this.close();
                    }
                    this.inited = true;
                }
            }
            finally {
                this.inited = true;
            }
        }
    }

    @Override
    void initChannel(int chan, int type, int subtype) {
        if (!this.online) {
            return;
        }
        try {
            if (type == 0) {
                int sType = subtype & 0xFF;
                int tType = subtype >> 8;
                this.mcc.setSensorType(chan, sType);
                if (sType == 0) {
                    this.mcc.setThermConnType(chan, tType);
                    this.mcc.setExcitation(chan, 2);
                    this.mcc.setGain(chan, 2);
                    int j = 0;
                    while (j < RTD_COEFFS.length) {
                        this.mcc.setCoefficient(chan, j, RTD_COEFFS[j]);
                        ++j;
                    }
                } else {
                    this.mcc.setTCType(chan, tType);
                }
            } else if (type == 1) {
                this.mcc.setGain(chan, subtype);
                this.mcc.setVoltageConnType(chan, 0);
            } else if (type == 3) {
                this.mcc.dioConfigBit(chan, 1);
            }
        }
        catch (Exception e) {
            MCCDevice.checkUsbException(e);
            this.log.error((Object)("Error configuring " + this.fullName + ": " + e), new String[0]);
            this.setOnline(false);
        }
    }

    @Override
    double readChannel(int chan) {
        double value = 0.0;
        if (!this.online) {
            return value;
        }
        if (this.type == 3) {
            try {
                value = this.mcc.dioInBit(chan);
            }
            catch (Exception e) {
                MCCDevice.checkUsbException(e);
                this.log.error((Object)("Error reading DIO line: " + e), new String[0]);
                this.setOnline(false);
            }
        } else {
            try {
                value = this.mcc.adcIn(chan, 0);
            }
            catch (Exception e) {
                MCCDevice.checkUsbException(e);
                this.log.error((Object)("Error reading ADC: " + e), new String[0]);
                this.setOnline(false);
            }
        }
        return value;
    }

    @Override
    void checkLine(String name, int line) throws Exception {
        if (line < 0 || line >= 8) {
            this.refg.reportError(name, "line", line);
        }
    }

    @Override
    void addLine(int id) {
        this.lineMask |= 1 << id;
    }

    @Override
    void setLine(int id, boolean on) {
        try {
            this.mcc.dioOutBit(id, on ? 1 : 0);
        }
        catch (Exception e) {
            MCCDevice.checkUsbException(e);
            this.log.error((Object)("Error setting DIO line: " + e), new String[0]);
            this.setOnline(false);
        }
    }

    @Override
    boolean isLineSet(int id) {
        try {
            return this.mcc.dioInBit(id) != 0;
        }
        catch (Exception e) {
            MCCDevice.checkUsbException(e);
            this.log.error((Object)("Error reading DIO line: " + e), new String[0]);
            this.setOnline(false);
            return false;
        }
    }

    @Override
    void close() {
        try {
            this.mcc.close();
        }
        catch (Exception e) {
            MCCDevice.checkUsbException(e);
        }
    }

    static void checkUsbException(Exception e) {
        if (e instanceof UsbException || e instanceof UsbDisconnectedException || e instanceof UsbEncodingException || e instanceof UsbNotActiveException || e instanceof UsbNotOpenException || e instanceof UsbNotClaimedException) {
            return;
        }
        throw (RuntimeException)e;
    }
}

