/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.BitSet;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.subsystem.refrig.RefrigTest;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class Device
extends ConfigurableComponent {
    static final int TYPE_MCC = 0;
    static final int TYPE_WATTS = 1;
    Logger log;
    int type;
    String fullName;
    BitSet chanMask;
    RefrigTest refg;
    boolean inited;
    boolean online;

    void configure(RefrigTest refg) {
        this.refg = refg;
        this.log = refg.getLogger();
        this.chanMask = new BitSet(refg.getNumChans());
    }

    abstract void initialize();

    abstract int[] checkChannel(String var1, int var2, String var3, String var4) throws Exception;

    void addChannel(int id) {
        this.chanMask.set(id);
    }

    abstract void initChannel(int var1, int var2, int var3);

    abstract double readChannel(int var1);

    void checkOnline() {
        if (this.online) {
            return;
        }
        this.initialize();
    }

    void setOnline(boolean online) {
        this.online = online;
        this.refg.setOnline(this.chanMask, online);
        if (!online) {
            this.log.error((Object)("Disconnected from " + this.fullName), new String[0]);
            this.close();
        }
    }

    void initSensors() {
        int id = this.chanMask.nextSetBit(0);
        while (id >= 0) {
            this.refg.getChannel(id).initSensor();
            id = this.chanMask.nextSetBit(id + 1);
        }
    }

    void setOutputLines() {
        this.refg.setOutputLines();
    }

    abstract void close();

    void checkLine(String name, int line) throws Exception {
    }

    void addLine(int id) {
    }

    void setLine(int line, boolean on) {
    }

    boolean isLineSet(int line) {
        return false;
    }
}

