import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.RefrigTest;
import org.lsst.ccs.subsystem.refrig.SimDevice;
import org.lsst.ccs.subsystem.refrig.OutputLine;
import org.lsst.ccs.subsystem.refrig.MonChannel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig"]

builder.
    main (RefrigTest, argMap("main", 10000, "sim")) {

        Sim        (SimDevice, argMap(null, null))

        MainPower  (OutputLine, argMap("MAIN", "Sim", 0, null, 0))

        LoadPower  (OutputLine, argMap("LOAD", "Sim", 1, null, 0))

        CmpDisTmp  (MonChannel,
                    argMap("Compressor discharge temperature", "C",
                           "flag", aDbl(limitLo, 0), 0,
                           "mtrip", aDbl(limitHi, 0), 0,
                           "Sim", 0, "TEMP", "110: 120: 10: 1200",
                           -1, 0, 1))

        CmpDisPrs  (MonChannel,
                    argMap("Compressor discharge pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Sim", 1, "VOLTS", "300.0: 30.0: 50.0: 30.0",
                           -1, 0.0, 1.0))

        C3LiqdTmp  (MonChannel,
                    argMap("C3 liquid cap temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Sim", 2, "TEMP", "-120.0: 1800.0: 25.0: 7200.0",
                           -1, 0.0, 1.0))

        PreC4Tmp   (MonChannel,
                    argMap("Pre C4 evaporator temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Sim", 3, "TEMP", "-120.0: 1800.0: 25.0: 7200.0",
                           -1, 0.0, 1.0))

        PostEvpTmp (MonChannel,
                    argMap("Post evaporator temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Sim", 4, "TEMP", "-110.0: 1800.0: 25.0: 7200.0",
                           -1, 0.0, 1.0))

        LoadTmp    (MonChannel,
                    argMap("Heat load temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "ltrip", aDbl(limitHi, 0.0), 2.0,
                           "Sim", 5, "TEMP", "-100.0: 1800.0: 25.0: 7200.0",
                           -1, 0.0, 1.0))

        LoadTmpTC  (MonChannel,
                    argMap("Heat load temperature (TC)", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Sim", 6, "TEMP", "-100.0: 1800.0: 25.0: 7200.0",
                           -1, 0.0, 1.0))

        CmpSucPrs  (MonChannel,
                    argMap("Compressor suction pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Sim", 7, "VOLTS", "10.0: 30.0: 50.0: 30.0",
                           -1, 0.0, 1.0))

        LoadPower  (MonChannel,
                    argMap("Heat load power", "Watts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Sim", 8, "POWER", "200.0: 0.0: 0.0: 0.0",
                           -1, 0.0, 1.0))

        CmprPower  (MonChannel,
                    argMap("Compressor power", "Watts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Sim", 9, "POWER", "1050.0: 0.0: 0.0: 0.0",
                           -1, 0.0, 1.0))

        CmprVolts  (MonChannel,
                    argMap("Compressor line voltage", "Volts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Sim", 10, "POWER", "208.0: 0.0: 0.0: 0.0",
                           -1, 0.0, 1.0))

        FanAlarm   (MonChannel,
                    argMap("Compressor purge fan alarm", "",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Sim", 11, "SWITCH", "1.0: 0.0: 1.0: 0.0",
                           -1, 0.0, 1.0))
    }
