#! /bin/sh
#
#  Run the refrigeration test simulation program
#
#  daq.sh [jms] [cold]
#
#    jms     If present, uses JMS instead of jGroups
#
#    cold    If present, performs a cold start
#

if [ `uname` == Linux ]; then FP=`readlink -fn $0`
else FP=`perl -e "use Cwd 'abs_path'; print abs_path('$0')"`; fi
BD=`dirname $FP`

if [ "$1" == jms ] || [ "$2" == jms ]; then
    TL="-tl GlassFish3"
fi

if [ "$1" == cold ] || [ "$2" == cold ]; then
    CS="-D lsst.ccs.refrig.coldstart=true"
fi

export CCS_RESOURCE_PATH=..
cd $BD/../..
CFG=ccs-refrig_sim_.properties
touch $CFG
$BD/CCSbootstrap.sh -app RefrigSim $TL $CS --description $BD/../etc/ccs-refrig__sim.groovy --configuration $CFG
