#! /bin/sh

#
#  Run the refrigeration test simulation program
#
#  sim.sh [jg] [gc]
#
#    jg      If present, uses jGroups instead of Glassfish
#
#    gc      If present, writes garbage collection statistics to gui_gc.log in
#            the directory containing this script
#

name=`readlink -fn $0`
BD=`dirname $name`
BR=$BD/../share/java

if [ "$1" == jg ] || [ "$2" == jg ]; then
  MF=-Dlsst.messaging.factory=org.lsst.ccs.bus.BusMessagingFactory
else
  MF=-Dlsst.messaging.factory=org.lsst.ccs.bus.jms.JMSMessagingFactory
fi

GC=""
if [ "$1" == gc ] || [ "$2" == gc ]; then
  GC=-Xloggc:./daq_gc.log
fi

CP=$BR/glassfish-embedded-all-3.1.1.jar
JAR=`ls -r $BR/org-lsst-ccs-subsystem-refrig-main-*.jar`
CP=$CP:${JAR//$'\n'/:}
RSP=$BD/../etc

#java -cp $CP $MF -Djava.util.logging.config.file=$RSP/logging.properties org.lsst.ccs.startup.SubsystemBoot --description $RSP/ccs-refrig__sim.groovy --configuration $RSP/ccs-refrig_sim_.properties

java -cp $CP $MF org.lsst.ccs.startup.SubsystemBoot --description $RSP/ccs-refrig__sim.groovy --configuration $RSP/ccs-refrig_sim_.properties
