#! /bin/sh

#
#  Run the refrigeration test DAQ program
#
#  daq.sh [jg] [gc]
#
#    jg      If present, uses jGroups instead of Glassfish
#
#    gc      If present, writes garbage collection statistics to gui_gc.log in
#            the directory containing this script
#

name=`readlink -fn $0`
BD=`dirname $name`
BR=$BD/../share/java

if [ "$1" == jg ] || [ "$2" == jg ]; then
  MF=-Dlsst.messaging.factory=org.lsst.ccs.bus.BusMessagingFactory
else
  MF=-Dlsst.messaging.factory=org.lsst.ccs.bus.jms.JMSMessagingFactory
fi

GC=""
if [ "$1" == gc ] || [ "$2" == gc ]; then
  GC=-Xloggc:./daq_gc.log
fi

CP=$BR/glassfish-embedded-all-3.1.1.jar
JAR=`ls -r $BR/org-lsst-ccs-subsystem-refrig-main-*.jar`
CP=$CP:${JAR//$'\n'/:}
LDP=$BD/../lib/jni:$BD/../lib
RSP=$BD/../etc

#LD_LIBRARY_PATH=$LDP java $GC $MF -Djava.util.logging.config.file=$RSP/logging.properties -cp $CP org.lsst.ccs.startup.SubsystemBoot --description $RSP/ccs-refrig__hdw.groovy --configuration $RSP/ccs-refrig_hdw_.properties

LD_LIBRARY_PATH=$LDP java $GC $MF -cp $CP org.lsst.ccs.startup.SubsystemBoot --description $RSP/ccs-refrig__hdw.groovy --configuration $RSP/ccs-refrig_hdw_.properties
