import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.RefrigTestHdw;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig"]

builder.
    main (RefrigTestHdw,
          argMap("main", 10000, "hdw")) {

        MccTcAi    (RefrigTestHdw.MCC, argMap("TC_AI", null))

        MccTc      (RefrigTestHdw.MCC, argMap("TC", null))

        MccTemp    (RefrigTestHdw.MCC, argMap("TEMP", null))

        WattsLoad  (RefrigTestHdw.Watts, argMap(null, null))

        WattsCmpr  (RefrigTestHdw.Watts, argMap("ppa-pc66117-l", "A100KS6F"))

        CmpDisTmp  (RefrigTestHdw.ChannelHdw,
                    argMap("Compressor discharge temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "mtrip", aDbl(limitHi, 0.0), 0.0,
                           "TEMP", "TC:T", 0, 0, 0.0, 1.0))

        CmpDisPrs  (RefrigTestHdw.ChannelHdw,
                    argMap("Compressor discharge pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "mtrip", aDbl(limitHi, 0.0), 0.0,
                           "VOLTS", "1.25V", 6, 1, -5.0, 10000.0))

        C3LiqdTmp  (RefrigTestHdw.ChannelHdw,
                    argMap("C3 liquid cap temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "TEMP", "TC:T", 1, 2, 0.0, 1.0))

        PreC4Tmp   (RefrigTestHdw.ChannelHdw,
                    argMap("Pre C4 evaporator temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "TEMP", "TC:T", 2, 3, 0.0, 1.0))

        PostEvpTmp (RefrigTestHdw.ChannelHdw,
                    argMap("Post evaporator temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "TEMP", "TC:T", 12, -1, 0.0, 1.0))

        LoadTmp    (RefrigTestHdw.ChannelHdw,
                    argMap("Heat load temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "ltrip", aDbl(limitHi, 0.0), 2.0,
                           "TEMP", "RTD:3WIRE", 16, 4, 0.0, 1.0))

        LoadTmpTC  (RefrigTestHdw.ChannelHdw,
                    argMap("Heat load temperature (TC)", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "TEMP", "TC:T", 3, -1, 0.0, 1.0))

        DwrSucPrs  (RefrigTestHdw.ChannelHdw,
                    argMap("Dewar suction pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "VOLTS", "1.25V", 5, -1, -0.53, 1000.0))

        CmpSucPrs  (RefrigTestHdw.ChannelHdw,
                    argMap("Compressor suction pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "VOLTS", "1.25V", 7, 5, -0.53, 1000.0))

        SucPrsDiff (RefrigTestHdw.ChannelHdw,
                    argMap("Suction pressure difference", "Psi",
                           "none", aDbl(limitLo, 0.0), 0.0,
                           "none", aDbl(limitHi, 0.0), 0.0,
                           "DIFF", "DwrSucPrs:CmpSucPrs", 0, -1, 0, 0))

        LoadPower  (RefrigTestHdw.ChannelHdw,
                    argMap("Heat load power", "Watts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "POWER", "", 0, -1, 0.0, 1.0))

        CmprPower  (RefrigTestHdw.ChannelHdw,
                    argMap("Compressor power", "Watts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "mtrip", aDbl(limitHi, 0.0), 0.0,
                           "POWER", "", 2, -1, 0.0, 1.0))

        CmprVolts  (RefrigTestHdw.ChannelHdw,
                    argMap("Compressor line voltage", "Volts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "POWER", "", 3, -1, 0.0, 1.0))

        FanAlarm   (RefrigTestHdw.ChannelHdw,
                    argMap("Compressor purge fan alarm", "",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "SWITCH", "", 15, -1, 0.0, 1.0))

        AmbientTmp (RefrigTestHdw.ChannelHdw,
                    argMap("Ambient Temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "TEMP", "TC:T", 13, -1, 0.0, 1.0))
    }
