/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.usb.UsbException;
import org.lsst.ccs.drivers.mcc.MccUsb;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.subsystem.refrig.RefrigTest;

public class RefrigTestHdw
extends RefrigTest {
    private static final int N_MCC_DEV_CHANS = 8;
    private static final int N_ALARMS = 6;
    private static final int MAIN_POWER_BIT = 7;
    private static final int LOAD_POWER_BIT = 6;
    private static final int ALARMS_MASK = 63;
    private static final int LEDS_MASK = 127;
    private static final int N_WATTS_DEV_CHANS = 2;
    private static final int WATTS_LOG_PERIOD = 1;
    private static final int CHAN_TYPE_UNKNOWN = -1;
    private static final int CHAN_TYPE_TEMP = 0;
    private static final int CHAN_TYPE_VOLTS = 1;
    private static final int CHAN_TYPE_POWER = 2;
    private static final int CHAN_TYPE_SWITCH = 3;
    private static final int CHAN_TYPE_DIFF = 4;
    private static final float[] RTD_COEFFS = new float[]{100.0f, 0.003908f, -5.8019E-7f, -4.2735E-12f};
    private MCC[] mccData;
    private Watts[] wuData;
    private ChannelHdw[] chanDataHdw;
    private int nMcc;
    private int nWatts;
    private int tcChanMask;
    private int rtChanMask;
    private int vChanMask;
    private int mainPowerDev;
    private int loadPowerDev;
    private int loadPowerDev2;
    private int alarmsDev;
    private int alarmsDev2;

    public RefrigTestHdw(String name, int tickMillis, String configName) {
        super(name, tickMillis, configName);
    }

    @Override
    void initConfiguration() {
        Map mccMap = this.getChildren(MCC.class);
        this.nMcc = mccMap.size();
        this.mccData = new MCC[this.nMcc];
        Iterator iMcc = mccMap.values().iterator();
        int id = 0;
        while (id < this.nMcc) {
            this.mccData[id] = (MCC)iMcc.next();
            this.mccData[id].configure(this, id);
            ++id;
        }
        Map wuMap = this.getChildren(Watts.class);
        this.nWatts = wuMap.size();
        this.wuData = new Watts[this.nWatts];
        Iterator iWatts = wuMap.values().iterator();
        int id2 = 0;
        while (id2 < this.nWatts) {
            this.wuData[id2] = (Watts)iWatts.next();
            ++id2;
        }
        Map chanMap = this.getChildren(ChannelHdw.class);
        this.nChan = chanMap.size();
        this.chanData = new ChannelHdw[this.nChan];
        this.chanDataHdw = (ChannelHdw[])this.chanData;
        Iterator values = chanMap.values().iterator();
        int id3 = 0;
        while (id3 < this.nChan) {
            this.chanDataHdw[id3] = (ChannelHdw)((Object)values.next());
            this.chanDataHdw[id3].configure(this, id3);
            ++id3;
        }
        ChannelHdw[] channelHdwArray = this.chanDataHdw;
        int n = this.chanDataHdw.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelHdw ch = channelHdwArray[n2];
            ch.configDerived();
            ++n2;
        }
    }

    @Override
    void initSensors() {
        Object[] objectArray = this.mccData;
        int n = this.mccData.length;
        int n2 = 0;
        while (n2 < n) {
            MCC mcc = objectArray[n2];
            mcc.initialize();
            ++n2;
        }
        objectArray = this.wuData;
        n = this.wuData.length;
        n2 = 0;
        while (n2 < n) {
            Object wu = objectArray[n2];
            ((Watts)wu).initialize();
            ++n2;
        }
        objectArray = this.chanDataHdw;
        n = this.chanDataHdw.length;
        n2 = 0;
        while (n2 < n) {
            Object ch = objectArray[n2];
            ((ChannelHdw)((Object)ch)).initSensor();
            ++n2;
        }
    }

    @Override
    void readSensors() {
        ChannelHdw ch;
        ChannelHdw[] channelHdwArray = this.chanDataHdw;
        int n = this.chanDataHdw.length;
        int n2 = 0;
        while (n2 < n) {
            ch = channelHdwArray[n2];
            ch.readSensor();
            ++n2;
        }
        channelHdwArray = this.chanDataHdw;
        n = this.chanDataHdw.length;
        n2 = 0;
        while (n2 < n) {
            ch = channelHdwArray[n2];
            ch.calcDerived();
            ++n2;
        }
    }

    @Override
    void setMainPower() {
        MCC mccDev = this.mccData[this.mainPowerDev];
        if (mccDev.inited) {
            try {
                int on = this.setState >> 16 & 1;
                mccDev.mcc.dioOutBit(7, on);
            }
            catch (UsbException e) {
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)), new String[0]);
            }
        }
    }

    @Override
    void setLoadPower() {
        int on = this.chanState >> 18 & 1;
        MCC mccDev = this.mccData[this.loadPowerDev];
        if (mccDev.inited) {
            try {
                mccDev.mcc.dioOutBit(6, on);
            }
            catch (UsbException e) {
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)), new String[0]);
            }
        }
        mccDev = this.mccData[this.loadPowerDev2];
        if (mccDev.inited) {
            try {
                mccDev.mcc.dioOutBit(6, on ^ 1);
            }
            catch (UsbException e) {
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)), new String[0]);
            }
        }
    }

    @Override
    void setDisplay() {
        int alarms = 0;
        ChannelHdw[] channelHdwArray = this.chanDataHdw;
        int n = this.chanDataHdw.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelHdw ch = channelHdwArray[n2];
            int alarm = ch.getAlarm();
            if (alarm >= 0 && (this.chanState >> ch.getId() & 1) == 0) {
                alarms |= 1 << alarm;
            }
            ++n2;
        }
        MCC mccDev = this.mccData[this.alarmsDev];
        if (mccDev.inited) {
            try {
                int value = mccDev.mcc.dioIn();
                mccDev.mcc.dioOut(value & 0xFFFFFFC0 | alarms);
            }
            catch (UsbException e) {
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)), new String[0]);
            }
        }
        mccDev = this.mccData[this.alarmsDev2];
        if (mccDev.inited) {
            try {
                int value = mccDev.mcc.dioIn();
                mccDev.mcc.dioOut(value & 0xFFFFFFC0 | ~alarms);
            }
            catch (UsbException e) {
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)), new String[0]);
            }
        }
    }

    private int findChannelId(String name) {
        ChannelHdw[] channelHdwArray = this.chanDataHdw;
        int n = this.chanDataHdw.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelHdw ch = channelHdwArray[n2];
            if (ch.getName().equals(name)) {
                return ch.getId();
            }
            ++n2;
        }
        return -1;
    }

    public static class ChannelHdw
    extends RefrigTest.Channel {
        String typeS;
        String subtypeS;
        int chan;
        int alarm;
        float offset;
        float scale;
        int type;
        int subtype;
        RefrigTestHdw refHdw;
        private static final HashMap<String, Integer> typeMap = new HashMap();
        private static final HashMap<String, Integer> tSubtypeMap;
        private static final HashMap<String, Integer> tcSubtypeMap;
        private static final HashMap<String, Integer> rtSubtypeMap;
        private static final HashMap<String, Integer> vSubtypeMap;

        static {
            typeMap.put("TEMP", 0);
            typeMap.put("VOLTS", 1);
            typeMap.put("POWER", 2);
            typeMap.put("SWITCH", 3);
            typeMap.put("DIFF", 4);
            tSubtypeMap = new HashMap();
            tSubtypeMap.put("TC", 2);
            tSubtypeMap.put("RTD", 0);
            tcSubtypeMap = new HashMap();
            tcSubtypeMap.put("J", 0);
            tcSubtypeMap.put("K", 1);
            tcSubtypeMap.put("T", 2);
            tcSubtypeMap.put("E", 3);
            tcSubtypeMap.put("R", 4);
            tcSubtypeMap.put("S", 5);
            tcSubtypeMap.put("B", 6);
            tcSubtypeMap.put("N", 7);
            rtSubtypeMap = new HashMap();
            rtSubtypeMap.put("2WIRE1", 0);
            rtSubtypeMap.put("2WIRE2", 1);
            rtSubtypeMap.put("3WIRE", 2);
            rtSubtypeMap.put("4WIRE", 3);
            vSubtypeMap = new HashMap();
            vSubtypeMap.put("10V", 2);
            vSubtypeMap.put("5V", 3);
            vSubtypeMap.put("2.5V", 4);
            vSubtypeMap.put("1.25V", 5);
        }

        public ChannelHdw(String desc, String units, String loCheck, double limitLo, double deadbandLo, String hiCheck, double limitHi, double deadbandHi, String type, String subtype, int chan, int alarm, double offset, double scale) {
            super(desc, units, loCheck, limitLo, deadbandLo, hiCheck, limitHi, deadbandHi);
            this.typeS = type;
            this.subtypeS = subtype;
            this.chan = chan;
            this.alarm = alarm;
            this.offset = (float)offset;
            this.scale = (float)scale;
        }

        void configure(RefrigTestHdw ref, int id) {
            super.configure(ref, id);
            this.refHdw = ref;
            int iType = -1;
            int iSubtype = -1;
            int iChan = -1;
            int iAlarm = -1;
            try {
                Integer iTyp = typeMap.get(this.typeS.toUpperCase());
                if (iTyp == null) {
                    RefrigTestHdw.reportError(this.getName(), "type", this.typeS);
                }
                iType = iTyp;
                String sbtype = this.subtypeS.toUpperCase();
                if (iType == 0) {
                    Integer iStp;
                    String[] sbtypes = sbtype.split(":", -1);
                    if (sbtypes.length < 2) {
                        RefrigTestHdw.reportError(this.getName(), "subtype", this.subtypeS);
                    }
                    if ((iStp = tSubtypeMap.get(sbtypes[0])) == null) {
                        RefrigTestHdw.reportError(this.getName(), "subtype", this.subtypeS);
                    }
                    iSubtype = iStp;
                    if ((iStp = iStp == 0 ? rtSubtypeMap.get(sbtypes[1]) : tcSubtypeMap.get(sbtypes[1])) == null) {
                        RefrigTestHdw.reportError(this.getName(), "subtype", this.subtypeS);
                    }
                    iSubtype |= iStp << 8;
                } else if (iType == 1) {
                    Integer iStp = vSubtypeMap.get(sbtype);
                    if (iStp == null) {
                        RefrigTestHdw.reportError(this.getName(), "subtype", this.subtypeS);
                    }
                    iSubtype = iStp;
                }
                if (iType == 0) {
                    int mask;
                    int n = mask = (iSubtype & 0xFF) == 0 ? this.refHdw.rtChanMask : this.refHdw.tcChanMask;
                    if ((1 << this.chan & mask) == 0) {
                        RefrigTestHdw.reportError(this.getName(), "hw channel number", this.chan);
                    }
                } else if (iType == 1) {
                    if ((1 << this.chan & this.refHdw.vChanMask) == 0) {
                        RefrigTestHdw.reportError(this.getName(), "hw channel number", this.chan);
                    }
                } else if (iType == 3 && (this.chan < 0 || this.chan >= 8 * this.refHdw.nMcc)) {
                    RefrigTestHdw.reportError(this.getName(), "hw channel number", this.chan);
                }
                iChan = this.chan;
                if (this.alarm >= 6) {
                    RefrigTestHdw.reportError(this.getName(), "alarm number", this.alarm);
                }
                iAlarm = this.alarm;
            }
            catch (Exception exception) {}
            this.type = iType;
            this.subtype = iSubtype;
            this.chan = iChan;
            this.alarm = iAlarm;
        }

        void configDerived() {
            if (this.type != 4) {
                return;
            }
            String[] names = this.subtypeS.split(":", -1);
            boolean okay = false;
            if (names.length == 2) {
                int id0 = this.refHdw.findChannelId(names[0]);
                int id1 = this.refHdw.findChannelId(names[1]);
                if (id0 >= 0 && id1 >= 0) {
                    this.subtype = id0 << 16 | id1;
                    okay = true;
                }
            }
            if (!okay) {
                log.error((Object)("Invalid subtype (" + this.subtypeS + ") for " + this.getName()), new String[0]);
                this.type = -1;
            }
        }

        void initSensor() {
            if (this.type != 3 && this.type != 0 && this.type != 1) {
                return;
            }
            MCC mccDev = this.refHdw.mccData[this.chan / 8];
            if (!mccDev.inited) {
                return;
            }
            int chn = this.chan % 8;
            MccUsb mcc = mccDev.mcc;
            try {
                if (this.type == 0) {
                    int sType = this.subtype & 0xFF;
                    int tType = this.subtype >> 8;
                    mcc.setSensorType(chn, sType);
                    if (sType == 0) {
                        mcc.setThermConnType(chn, tType);
                        mcc.setExcitation(chn, 2);
                        mcc.setGain(chn, 2);
                        int j = 0;
                        while (j < RTD_COEFFS.length) {
                            mcc.setCoefficient(chn, j, RTD_COEFFS[j]);
                            ++j;
                        }
                    } else {
                        mcc.setTCType(chn, tType);
                    }
                } else if (this.type == 1) {
                    mcc.setGain(chn, this.subtype);
                    mcc.setVoltageConnType(chn, 0);
                } else if (this.type == 3) {
                    mcc.dioConfigBit(chn, 1);
                }
            }
            catch (UsbException e) {
                log.error((Object)("Error configuring " + mccDev.type + " module: " + (Object)((Object)e)), new String[0]);
                mccDev.inited = false;
            }
        }

        void readSensor() {
            if (this.type == 2) {
                Watts wuDev = this.refHdw.wuData[this.chan / 2];
                this.value = wuDev.value[this.chan % 2];
                return;
            }
            if (this.type != 3 && this.type != 0 && this.type != 1) {
                return;
            }
            MCC mccDev = this.refHdw.mccData[this.chan / 8];
            if (!mccDev.inited) {
                return;
            }
            int chn = this.chan % 8;
            if (this.type == 3) {
                try {
                    this.value = mccDev.mcc.dioInBit(chn);
                }
                catch (UsbException e) {
                    log.error((Object)("Error reading DIO line: " + (Object)((Object)e)), new String[0]);
                }
            } else {
                try {
                    this.value = this.offset + this.scale * mccDev.mcc.adcIn(chn, 0);
                }
                catch (UsbException e) {
                    log.error((Object)("Error reading ADC: " + (Object)((Object)e)), new String[0]);
                }
            }
        }

        void calcDerived() {
            if (this.type != 4) {
                return;
            }
            this.value = this.refHdw.chanDataHdw[this.subtype >> 16].getValue() - this.refHdw.chanDataHdw[this.subtype & 0xFFFF].getValue();
        }

        int getAlarm() {
            return this.alarm;
        }
    }

    public static class MCC {
        String type;
        int did;
        String serial;
        MccUsb mcc;
        boolean inited;
        private static final HashMap<String, Integer> didMap = new HashMap();

        static {
            didMap.put("TC_AI", 0);
            didMap.put("TC", 1);
            didMap.put("TEMP", 2);
        }

        public MCC(String type, String serial) {
            this.type = type;
            this.serial = serial;
            Integer iDid = didMap.get(type);
            if (iDid == null) {
                log.error((Object)("Invalid MCC device type (" + type + ")"), new String[0]);
                this.did = -1;
            } else {
                this.did = iDid;
            }
        }

        private void configure(RefrigTestHdw ref, int id) {
            int shift = 8 * id;
            if (this.did == 0) {
                RefrigTestHdw refrigTestHdw = ref;
                refrigTestHdw.tcChanMask = refrigTestHdw.tcChanMask | 15 << shift;
                RefrigTestHdw refrigTestHdw2 = ref;
                refrigTestHdw2.vChanMask = refrigTestHdw2.vChanMask | 240 << shift;
                ref.mainPowerDev = id;
                ref.loadPowerDev = id;
                ref.alarmsDev = id;
            } else if (this.did == 1) {
                RefrigTestHdw refrigTestHdw = ref;
                refrigTestHdw.tcChanMask = refrigTestHdw.tcChanMask | 255 << shift;
                ref.loadPowerDev2 = id;
                ref.alarmsDev2 = id;
            } else if (this.did == 2) {
                RefrigTestHdw refrigTestHdw = ref;
                refrigTestHdw.tcChanMask = refrigTestHdw.tcChanMask | 255 << shift;
                RefrigTestHdw refrigTestHdw3 = ref;
                refrigTestHdw3.rtChanMask = refrigTestHdw3.rtChanMask | 255 << shift;
            }
        }

        private void initialize() {
            if (this.did < 0) {
                return;
            }
            try {
                this.mcc = new MccUsb();
                this.mcc.open(this.did, this.serial, true);
                this.mcc.blink();
                this.mcc.dioConfig(0);
                this.mcc.dioOut(0);
                if (this.did == 0) {
                    int j = 0;
                    while (j < 6) {
                        this.mcc.configAlarm(j, 0, 0, 0.0f, 0.0f);
                        ++j;
                    }
                } else if (this.did == 2) {
                    int j = 0;
                    while (j < 8) {
                        this.mcc.setSensorType(j, 4);
                        j += 2;
                    }
                }
                this.inited = true;
            }
            catch (UsbException e) {
                log.error((Object)("Error initializing " + this.type + " module: " + (Object)((Object)e)), new String[0]);
            }
        }
    }

    public static class Watts
    implements WattsUp.Listener {
        String node;
        String serial;
        boolean inited;
        WattsUp wtu;
        float[] value;

        public Watts(String node, String serial) {
            this.node = node;
            this.serial = serial;
            this.value = new float[2];
        }

        /*
         * Unable to fully structure code
         */
        private void initialize() {
            block3: {
                try {
                    this.wtu = new WattsUp();
                    this.wtu.addListener((WattsUp.Listener)this);
                    this.wtu.open(this.node, 0, this.serial);
                    this.inited = true;
                    break block3;
                }
                catch (Exception e) {
                    RefrigTestHdw.access$0().error((Object)("Cannot access WattsUp meter: " + e), new String[0]);
                    j = 0;
                    ** while (j < 2)
                }
lbl-1000:
                // 1 sources

                {
                    this.value[j] = -1.0f;
                    ++j;
                    continue;
                }
            }
        }

        public void setPowered(boolean on) {
            if (on) {
                try {
                    this.wtu.setLoggedFields(3);
                    this.wtu.setExternalLogging(1);
                }
                catch (Exception e) {
                    log.error((Object)("Cannot configure WattsUp meter: " + e), new String[0]);
                }
            } else {
                int j = 0;
                while (j < 2) {
                    this.value[j] = 0.0f;
                    ++j;
                }
            }
        }

        public void setClosed() {
            int j = 0;
            while (j < 2) {
                this.value[j] = -1.0f;
                ++j;
            }
            this.inited = false;
        }

        public void processData(float[] data) {
            this.value[0] = data[0];
            this.value[1] = data[1];
        }
    }
}

