/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.Iterator;
import java.util.Map;
import org.lsst.ccs.subsystem.refrig.RefrigTest;

public class RefrigTestSim
extends RefrigTest {
    private static final float LOAD_POWER_FCTR = 6.667E-4f;
    private ChannelSim[] chanDataSim;
    private int loadPwrId = -1;
    private int loadTmpId = -1;
    private long currTime = System.currentTimeMillis();
    private double loadFract = 0.6;

    public RefrigTestSim(String name, int tickMillis, String configName) {
        super(name, tickMillis, configName);
    }

    public void setLoadFract(double fract) {
        this.loadFract = (float)fract;
        this.setLoadPower();
    }

    public double getLoadFract() {
        return this.loadFract;
    }

    @Override
    void initConfiguration() {
        Map chData = this.getChildren(ChannelSim.class);
        this.nChan = chData.size();
        this.chanData = new ChannelSim[this.nChan];
        this.chanDataSim = (ChannelSim[])this.chanData;
        Iterator values = chData.values().iterator();
        int id = 0;
        while (id < this.nChan) {
            ChannelSim ch = this.chanDataSim[id] = (ChannelSim)((Object)values.next());
            ch.configure(this, id);
            if (ch.getName().equals("LoadPower")) {
                this.loadPwrId = id;
            }
            if (ch.getName().equals("LoadTmp")) {
                this.loadTmpId = id;
            }
            ++id;
        }
    }

    @Override
    void initSensors() {
        ChannelSim[] channelSimArray = this.chanDataSim;
        int n = this.chanDataSim.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelSim ch = channelSimArray[n2];
            ch.initSensor();
            ++n2;
        }
    }

    @Override
    void readSensors() {
        long thisTime = System.currentTimeMillis();
        double intvl = (double)(thisTime - this.currTime) / 1000.0;
        this.currTime = thisTime;
        ChannelSim[] channelSimArray = this.chanDataSim;
        int n = this.chanDataSim.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelSim ch = channelSimArray[n2];
            ch.readSensor(intvl);
            ++n2;
        }
    }

    @Override
    void setMainPower() {
        this.currTime = System.currentTimeMillis();
        ChannelSim[] channelSimArray = this.chanDataSim;
        int n = this.chanDataSim.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelSim ch = channelSimArray[n2];
            if (ch.getId() != this.loadPwrId) {
                ch.powerOn();
            }
            ++n2;
        }
        this.setLoadPower();
    }

    @Override
    void setLoadPower() {
        ChannelSim pc = this.chanDataSim[this.loadPwrId];
        float endValue = 0.0f;
        if ((this.setState & 0x10000) != 0) {
            ChannelSim tc;
            if ((this.chanState & 0x40000) != 0) {
                endValue = (float)(this.loadFract * (double)pc.getOnValue());
            }
            if ((tc = this.chanDataSim[this.loadTmpId]).getOnTime() != 0.0f) {
                tc.setRate((tc.getOnValue() - tc.getOffValue()) / tc.getOnTime() + 6.667E-4f * endValue);
            }
        }
        pc.setEndValue(endValue);
        pc.setValue(endValue);
    }

    @Override
    void setDisplay() {
    }

    public static class ChannelSim
    extends RefrigTest.Channel {
        float onValue;
        float onTime;
        float offValue;
        float offTime;
        float endValue;
        float rate;
        boolean negative;
        RefrigTestSim refSim;

        public ChannelSim(String desc, String units, String loCheck, double limitLo, double deadbandLo, String hiCheck, double limitHi, double deadbandHi, double onValue, double onTime, double offValue, double offTime) {
            super(desc, units, loCheck, limitLo, deadbandLo, hiCheck, limitHi, deadbandHi);
            this.onValue = (float)onValue;
            this.onTime = (float)onTime;
            this.offValue = (float)offValue;
            this.offTime = (float)offTime;
            this.endValue = 0.0f;
            this.rate = 0.0f;
            this.negative = false;
        }

        void configure(RefrigTestSim ref, int id) {
            super.configure(ref, id);
            this.refSim = ref;
        }

        void initSensor() {
            if (this.id == this.refSim.loadPwrId) {
                this.onTime = 0.0f;
                this.offValue = 0.0f;
                this.offTime = 0.0f;
            }
            this.endValue = this.offValue;
            this.value = this.offValue;
        }

        void readSensor(double intvl) {
            this.value = (float)((double)this.value + (double)this.rate * intvl);
            if (this.negative) {
                if (this.value < this.endValue) {
                    this.value = this.endValue;
                }
            } else if (this.value > this.endValue) {
                this.value = this.endValue;
            }
        }

        void powerOn() {
            this.rate = 0.0f;
            if ((this.refSim.setState & 0x10000) != 0) {
                this.endValue = this.onValue;
                if (this.onTime != 0.0f) {
                    this.rate = (this.onValue - this.offValue) / this.onTime;
                }
            } else {
                this.endValue = this.offValue;
                if (this.offTime != 0.0f) {
                    this.rate = (this.offValue - this.onValue) / this.offTime;
                }
            }
            if (this.rate == 0.0f) {
                this.value = this.endValue;
            }
            this.negative = this.rate < 0.0f;
        }

        float getOffValue() {
            return this.offValue;
        }

        float getOnValue() {
            return this.onValue;
        }

        float getOnTime() {
            return this.onTime;
        }

        void setEndValue(float value) {
            this.endValue = value;
        }

        void setRate(float value) {
            this.rate = value;
        }

        void setValue(float value) {
            this.value = value;
        }
    }
}

