/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.usb.UsbException;
import org.lsst.ccs.drivers.mcc.MccUsb;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.subsystem.refrig.RefrigTest;
import org.lsst.ccs.utilities.conv.Convert;

public class RefrigTestHdw
extends RefrigTest
implements WattsUp.Listener {
    private static final int MCC_DEV_TC_AI = 0;
    private static final int MCC_DEV_TC = 1;
    private static final int MCC_DEV_TEMP = 2;
    private static final int N_MCC_DEVS = 3;
    private static final int N_MCC_DEV_CHANS = 8;
    private static final int N_MCC_CHANS = 24;
    private static final int TC_CHAN_MASK = 0xFFFF0F;
    private static final int RT_CHAN_MASK = 0xFF0000;
    private static final int V_CHAN_MASK = 240;
    private static final int N_ALARMS = 6;
    private static final int MAIN_POWER_DEV = 0;
    private static final int MAIN_POWER_BIT = 7;
    private static final int LOAD_POWER_DEV = 0;
    private static final int LOAD_POWER_DEV2 = 1;
    private static final int LOAD_POWER_BIT = 6;
    private static final int ALARMS_MASK = 63;
    private static final int LEDS_MASK = 127;
    private static final int LOAD_POWER_CHAN = 0;
    private static final int CMPR_POWER_CHAN = 1;
    private static final int CMPR_VOLTS_CHAN = 2;
    private static final int CHAN_TYPE_UNKNOWN = -1;
    private static final int CHAN_TYPE_TEMP = 0;
    private static final int CHAN_TYPE_VOLTS = 1;
    private static final int CHAN_TYPE_POWER = 2;
    private static final int CHAN_TYPE_SWITCH = 3;
    private static final int CHAN_TYPE_DIFF = 4;
    private static final float[] RTD_COEFFS = new float[]{100.0f, 0.003908f, -5.8019E-7f, -4.2735E-12f};
    private static final String[] DEV_NAMES = new String[3];
    private static final int[] DEV_DIDS;
    private ChannelHdw[] chanDataHdw;
    private MccUsb[] mcc = new MccUsb[3];
    private WattsUp wtu;
    private float[] power = new float[]{-1.0f, -1.0f, -1.0f};
    private boolean[] mccInited = new boolean[3];
    private boolean wattsInited;

    static {
        RefrigTestHdw.DEV_NAMES[0] = "USB_TC_AI";
        RefrigTestHdw.DEV_NAMES[1] = "USB_TC";
        RefrigTestHdw.DEV_NAMES[2] = "USB_TEMP";
        DEV_DIDS = new int[3];
        RefrigTestHdw.DEV_DIDS[0] = 0;
        RefrigTestHdw.DEV_DIDS[1] = 1;
        RefrigTestHdw.DEV_DIDS[2] = 2;
    }

    public RefrigTestHdw(String name, int tickMillis, String configName) {
        super(name, tickMillis, configName);
    }

    @Override
    void initConfiguration() {
        Map chData = this.getChildren(ChannelHdw.class);
        this.nChan = chData.size();
        this.chanData = new ChannelHdw[this.nChan];
        this.chanDataHdw = (ChannelHdw[])this.chanData;
        Iterator values = chData.values().iterator();
        int id = 0;
        while (id < this.nChan) {
            this.chanDataHdw[id] = (ChannelHdw)((Object)values.next());
            this.chanDataHdw[id].configure(this, id);
            ++id;
        }
        ChannelHdw[] channelHdwArray = this.chanDataHdw;
        int n = this.chanDataHdw.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelHdw ch = channelHdwArray[n2];
            ch.configDerived();
            ++n2;
        }
    }

    @Override
    void initSensors() {
        int dev = 0;
        while (dev < 3) {
            try {
                this.mcc[dev] = new MccUsb();
                this.mcc[dev].open(DEV_DIDS[dev], null, true);
                this.mcc[dev].blink();
                this.mcc[dev].dioConfig(0);
                this.mcc[dev].dioOut(0);
                if (dev == 0) {
                    int j = 0;
                    while (j < 6) {
                        this.mcc[dev].configAlarm(j, 0, 0, 0.0f, 0.0f);
                        ++j;
                    }
                } else if (dev == 2) {
                    int j = 0;
                    while (j < 8) {
                        this.mcc[dev].setSensorType(j, 4);
                        j += 2;
                    }
                }
                this.mccInited[dev] = true;
            }
            catch (UsbException e) {
                log.error((Object)("Error initializing " + DEV_NAMES[dev] + " module: " + (Object)((Object)e)));
            }
            ++dev;
        }
        try {
            this.wtu = new WattsUp();
            this.wtu.addListener((WattsUp.Listener)this);
            this.wtu.open();
            this.wattsInited = true;
            this.power[0] = 0.0f;
        }
        catch (Exception e) {
            log.error((Object)("Cannot access WattsUp meter: " + e));
        }
        ChannelHdw[] channelHdwArray = this.chanDataHdw;
        int n = this.chanDataHdw.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelHdw ch = channelHdwArray[n2];
            ch.initSensor();
            ++n2;
        }
        new RemotePower().start();
    }

    @Override
    void readSensors() {
        ChannelHdw ch;
        ChannelHdw[] channelHdwArray = this.chanDataHdw;
        int n = this.chanDataHdw.length;
        int n2 = 0;
        while (n2 < n) {
            ch = channelHdwArray[n2];
            ch.readSensor();
            ++n2;
        }
        channelHdwArray = this.chanDataHdw;
        n = this.chanDataHdw.length;
        n2 = 0;
        while (n2 < n) {
            ch = channelHdwArray[n2];
            ch.calcDerived();
            ++n2;
        }
    }

    @Override
    void setMainPower() {
        block2: {
            try {
                int on = this.setState >> 16 & 1;
                this.mcc[0].dioOutBit(7, on);
            }
            catch (UsbException e) {
                if (!this.mccInited[0]) break block2;
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
            }
        }
    }

    @Override
    void setLoadPower() {
        block5: {
            int on;
            block4: {
                on = this.chanState >> 18 & 1;
                try {
                    this.mcc[0].dioOutBit(6, on);
                }
                catch (UsbException e) {
                    if (!this.mccInited[0]) break block4;
                    log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
                }
            }
            try {
                this.mcc[1].dioOutBit(6, on ^ 1);
            }
            catch (UsbException e) {
                if (!this.mccInited[1]) break block5;
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
            }
        }
    }

    @Override
    void setDisplay() {
        block7: {
            int alarms;
            block6: {
                alarms = 0;
                ChannelHdw[] channelHdwArray = this.chanDataHdw;
                int n = this.chanDataHdw.length;
                int n2 = 0;
                while (n2 < n) {
                    ChannelHdw ch = channelHdwArray[n2];
                    int alarm = ch.getAlarm();
                    if (alarm >= 0 && (this.chanState >> ch.getId() & 1) == 0) {
                        alarms |= 1 << alarm;
                    }
                    ++n2;
                }
                try {
                    int value = this.mcc[0].dioIn();
                    this.mcc[0].dioOut(value & 0xFFFFFFC0 | alarms);
                }
                catch (UsbException e) {
                    if (!this.mccInited[0]) break block6;
                    log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
                }
            }
            try {
                int value = this.mcc[1].dioIn();
                this.mcc[1].dioOut(value & 0xFFFFFFC0 | ~alarms);
            }
            catch (UsbException e) {
                if (!this.mccInited[1]) break block7;
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
            }
        }
    }

    public void setPowered(boolean on) {
        if (on) {
            try {
                this.wtu.setLoggedFields(1);
                this.wtu.setExternalLogging(1);
            }
            catch (Exception e) {
                log.error((Object)("Cannot initialize WattsUp meter: " + e));
            }
        } else {
            this.power[0] = 0.0f;
        }
    }

    public void setClosed() {
        this.power[0] = -1.0f;
        this.wattsInited = false;
    }

    public void processData(float[] data) {
        this.power[0] = data[0];
    }

    private int findChannelId(String name) {
        ChannelHdw[] channelHdwArray = this.chanDataHdw;
        int n = this.chanDataHdw.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelHdw ch = channelHdwArray[n2];
            if (ch.getName().equals(name)) {
                return ch.getId();
            }
            ++n2;
        }
        return -1;
    }

    public static class ChannelHdw
    extends RefrigTest.Channel {
        String typeS;
        String subtypeS;
        int chan;
        int alarm;
        float offset;
        float scale;
        int type;
        int subtype;
        RefrigTestHdw refHdw;
        private static final HashMap<String, Integer> typeMap = new HashMap();
        private static final HashMap<String, Integer> tSubtypeMap;
        private static final HashMap<String, Integer> tcSubtypeMap;
        private static final HashMap<String, Integer> rtSubtypeMap;
        private static final HashMap<String, Integer> vSubtypeMap;

        static {
            typeMap.put("TEMP", 0);
            typeMap.put("VOLTS", 1);
            typeMap.put("POWER", 2);
            typeMap.put("SWITCH", 3);
            typeMap.put("DIFF", 4);
            tSubtypeMap = new HashMap();
            tSubtypeMap.put("TC", 2);
            tSubtypeMap.put("RTD", 0);
            tcSubtypeMap = new HashMap();
            tcSubtypeMap.put("J", 0);
            tcSubtypeMap.put("K", 1);
            tcSubtypeMap.put("T", 2);
            tcSubtypeMap.put("E", 3);
            tcSubtypeMap.put("R", 4);
            tcSubtypeMap.put("S", 5);
            tcSubtypeMap.put("B", 6);
            tcSubtypeMap.put("N", 7);
            rtSubtypeMap = new HashMap();
            rtSubtypeMap.put("2WIRE1", 0);
            rtSubtypeMap.put("2WIRE2", 1);
            rtSubtypeMap.put("3WIRE", 2);
            rtSubtypeMap.put("4WIRE", 3);
            vSubtypeMap = new HashMap();
            vSubtypeMap.put("10V", 2);
            vSubtypeMap.put("5V", 3);
            vSubtypeMap.put("2.5V", 4);
            vSubtypeMap.put("1.25V", 5);
        }

        public ChannelHdw(String desc, String units, String loCheck, double limitLo, double deadbandLo, String hiCheck, double limitHi, double deadbandHi, String type, String subtype, int chan, int alarm, double offset, double scale) {
            super(desc, units, loCheck, limitLo, deadbandLo, hiCheck, limitHi, deadbandHi);
            this.typeS = type;
            this.subtypeS = subtype;
            this.chan = chan;
            this.alarm = alarm;
            this.offset = (float)offset;
            this.scale = (float)scale;
        }

        void configure(RefrigTestHdw ref, int id) {
            super.configure(ref, id);
            this.refHdw = ref;
            int iType = -1;
            int iSubtype = -1;
            int iChan = -1;
            int iAlarm = -1;
            try {
                Integer iTyp = typeMap.get(this.typeS.toUpperCase());
                if (iTyp == null) {
                    RefrigTestHdw.reportError(this.getName(), "type", this.typeS);
                }
                iType = iTyp;
                String sbtype = this.subtypeS.toUpperCase();
                if (iType == 0) {
                    Integer iStp;
                    String[] sbtypes = sbtype.split(":", -1);
                    if (sbtypes.length < 2) {
                        RefrigTestHdw.reportError(this.getName(), "subtype", this.subtypeS);
                    }
                    if ((iStp = tSubtypeMap.get(sbtypes[0])) == null) {
                        RefrigTestHdw.reportError(this.getName(), "subtype", this.subtypeS);
                    }
                    iSubtype = iStp;
                    if ((iStp = iStp == 0 ? rtSubtypeMap.get(sbtypes[1]) : tcSubtypeMap.get(sbtypes[1])) == null) {
                        RefrigTestHdw.reportError(this.getName(), "subtype", this.subtypeS);
                    }
                    iSubtype |= iStp << 8;
                } else if (iType == 1) {
                    Integer iStp = vSubtypeMap.get(sbtype);
                    if (iStp == null) {
                        RefrigTestHdw.reportError(this.getName(), "subtype", this.subtypeS);
                    }
                    iSubtype = iStp;
                }
                if (iType == 0) {
                    int mask;
                    int n = mask = (iSubtype & 0xFF) == 0 ? 0xFF0000 : 0xFFFF0F;
                    if ((1 << this.chan & mask) == 0) {
                        RefrigTestHdw.reportError(this.getName(), "hw channel number", this.chan);
                    }
                } else if (iType == 1) {
                    if ((1 << this.chan & 0xF0) == 0) {
                        RefrigTestHdw.reportError(this.getName(), "hw channel number", this.chan);
                    }
                } else if (iType == 3 && (this.chan < 0 || this.chan >= 24)) {
                    RefrigTestHdw.reportError(this.getName(), "hw channel number", this.chan);
                }
                iChan = this.chan;
                if (this.alarm >= 6) {
                    RefrigTestHdw.reportError(this.getName(), "alarm number", this.alarm);
                }
                iAlarm = this.alarm;
            }
            catch (Exception exception) {}
            this.type = iType;
            this.subtype = iSubtype;
            this.chan = iChan;
            this.alarm = iAlarm;
        }

        void configDerived() {
            if (this.type != 4) {
                return;
            }
            String[] names = this.subtypeS.split(":", -1);
            boolean okay = false;
            if (names.length == 2) {
                int id0 = this.refHdw.findChannelId(names[0]);
                int id1 = this.refHdw.findChannelId(names[1]);
                if (id0 >= 0 && id1 >= 0) {
                    this.subtype = id0 << 16 | id1;
                    okay = true;
                }
            }
            if (!okay) {
                log.error((Object)("Invalid subtype (" + this.subtypeS + ") for " + this.getName()));
                this.type = -1;
            }
        }

        void initSensor() {
            if (this.type != 3 && this.type != 0 && this.type != 1) {
                return;
            }
            int dev = this.chan / 8;
            if (!this.refHdw.mccInited[dev]) {
                return;
            }
            int chn = this.chan % 8;
            MccUsb mcc = this.refHdw.mcc[dev];
            try {
                if (this.type == 0) {
                    int sType = this.subtype & 0xFF;
                    int tType = this.subtype >> 8;
                    mcc.setSensorType(chn, sType);
                    if (sType == 0) {
                        mcc.setThermConnType(chn, tType);
                        mcc.setExcitation(chn, 2);
                        mcc.setGain(chn, 2);
                        int j = 0;
                        while (j < RTD_COEFFS.length) {
                            mcc.setCoefficient(chn, j, RTD_COEFFS[j]);
                            ++j;
                        }
                    } else {
                        mcc.setTCType(chn, tType);
                    }
                } else if (this.type == 1) {
                    mcc.setGain(chn, this.subtype);
                    mcc.setVoltageConnType(chn, 0);
                } else if (this.type == 3) {
                    mcc.dioConfigBit(chn, 1);
                }
            }
            catch (UsbException e) {
                log.error((Object)("Error configuring " + DEV_NAMES[dev] + " module: " + (Object)((Object)e)));
                ((RefrigTestHdw)this.refHdw).mccInited[dev] = false;
            }
        }

        void readSensor() {
            block8: {
                if (this.type == 2) {
                    this.value = this.refHdw.power[this.chan];
                    return;
                }
                if (this.type != 3 && this.type != 0 && this.type != 1) {
                    return;
                }
                int dev = this.chan / 8;
                int chn = this.chan % 8;
                if (this.type == 3) {
                    try {
                        this.value = this.refHdw.mcc[dev].dioInBit(chn);
                    }
                    catch (UsbException e) {
                        if (this.refHdw.mccInited[dev]) {
                            log.error((Object)("Error reading DIO line: " + (Object)((Object)e)));
                        }
                        break block8;
                    }
                }
                try {
                    this.value = this.offset + this.scale * this.refHdw.mcc[dev].adcIn(chn, 0);
                }
                catch (UsbException e) {
                    if (!this.refHdw.mccInited[dev]) break block8;
                    log.error((Object)("Error reading ADC: " + (Object)((Object)e)));
                }
            }
        }

        void calcDerived() {
            if (this.type != 4) {
                return;
            }
            this.value = this.refHdw.chanDataHdw[this.subtype >> 16].getValue() - this.refHdw.chanDataHdw[this.subtype & 0xFFFF].getValue();
        }

        int getAlarm() {
            return this.alarm;
        }
    }

    private class RemotePower
    extends Thread {
        private RemotePower() {
        }

        @Override
        public void run() {
            ServerSocket server;
            try {
                server = new ServerSocket(7070, 1);
            }
            catch (IOException e) {
                log.error((Object)("Error creating remote power listener: " + e));
                return;
            }
            byte[] data = new byte[12];
            block8: while (true) {
                InputStream netInp;
                try {
                    netInp = server.accept().getInputStream();
                }
                catch (IOException e) {
                    log.error((Object)("Error creating remote power socket: " + e));
                    continue;
                }
                while (true) {
                    int nRead;
                    try {
                        nRead = netInp.read(data);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error reading remote power data: " + e));
                        nRead = -2;
                    }
                    if (nRead < 0) {
                        try {
                            netInp.close();
                        }
                        catch (IOException iOException) {}
                        ((RefrigTestHdw)RefrigTestHdw.this).power[1] = -1.0f;
                        ((RefrigTestHdw)RefrigTestHdw.this).power[2] = -1.0f;
                        continue block8;
                    }
                    if (nRead < data.length || Convert.bytesToInt((byte[])data, (int)0) != 13572468) continue;
                    ((RefrigTestHdw)RefrigTestHdw.this).power[1] = Convert.bytesToFloat((byte[])data, (int)4);
                    ((RefrigTestHdw)RefrigTestHdw.this).power[2] = Convert.bytesToFloat((byte[])data, (int)8);
                }
                break;
            }
        }
    }
}

