/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.utilities.conv.Convert;

public class RefrigPower
implements WattsUp.Listener {
    static final int POWER_PORT = 7070;
    static final int POWER_ID = 13572468;
    private final int UPDATE_PERIOD = 1;
    private final int CHECK_OPEN_PERIOD = 10;
    private static final PrintStream out = System.out;
    private OutputStream netOut = null;
    private WattsUp wtu;
    private String daqNode;
    private float power = -1.0f;
    private float volts = -1.0f;
    private boolean meterOpen = false;

    public static void main(String[] args) {
        if (args.length < 1) {
            out.println("No DAQ IP address supplied");
            System.exit(0);
        }
        new RefrigPower().run(args[0]);
        System.exit(0);
    }

    private void run(String node) {
        this.wtu = new WattsUp();
        this.wtu.addListener((WattsUp.Listener)this);
        this.daqNode = node;
        new Timer().schedule((TimerTask)new OpenMeter(), 0L, 10000L);
        new Timer().schedule((TimerTask)new OpenNet(), 0L, 10000L);
        new Timer().schedule((TimerTask)new SendPower(), 0L, 1000L);
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void setPowered(boolean on) {
        if (on) {
            try {
                this.wtu.setLoggedFields(3);
                this.wtu.setExternalLogging(1);
            }
            catch (Exception e) {
                out.println("Cannot configure WattsUp meter: " + e);
            }
        } else {
            this.volts = 0.0f;
            this.power = 0.0f;
            this.sendData();
        }
    }

    public void setClosed() {
        out.println("Disconnected from WattsUp meter");
        this.volts = -1.0f;
        this.power = -1.0f;
        this.sendData();
        this.meterOpen = false;
    }

    public void processData(float[] data) {
        this.power = data[0];
        this.volts = data[1];
    }

    private void sendData() {
        if (this.netOut != null) {
            byte[] mesg = new byte[12];
            Convert.intToBytes((int)13572468, (byte[])mesg, (int)0);
            Convert.floatToBytes((float)this.power, (byte[])mesg, (int)4);
            Convert.floatToBytes((float)this.volts, (byte[])mesg, (int)8);
            try {
                this.netOut.write(mesg);
            }
            catch (IOException iOException) {
                out.println("Lost connection to DAQ node");
                this.closeNet();
            }
        }
    }

    private void closeNet() {
        try {
            this.netOut.close();
        }
        catch (IOException iOException) {}
        this.netOut = null;
    }

    private class OpenMeter
    extends TimerTask {
        private OpenMeter() {
        }

        @Override
        public void run() {
            if (RefrigPower.this.meterOpen) {
                return;
            }
            try {
                out.println("Attempting meter connection");
                RefrigPower.this.wtu.open();
                RefrigPower.this.power = 0.0f;
                RefrigPower.this.volts = 0.0f;
                out.println("Connected to WattsUp meter");
                RefrigPower.this.meterOpen = true;
            }
            catch (RuntimeException e) {
                out.println("Cannot open meter (runtime): " + e);
            }
            catch (Exception e) {
                out.println("Cannot open meter (excptn): " + e);
            }
            catch (Error e) {
                out.println("Cannot open meter (error): " + e);
            }
        }
    }

    private class OpenNet
    extends TimerTask {
        private OpenNet() {
        }

        @Override
        public void run() {
            if (RefrigPower.this.netOut != null) {
                return;
            }
            try {
                RefrigPower.this.netOut = new Socket(RefrigPower.this.daqNode, 7070).getOutputStream();
                out.println("Connected to DAQ node (" + RefrigPower.this.daqNode + ")");
            }
            catch (UnknownHostException e) {
                out.println(e);
            }
            catch (Exception exception) {}
        }
    }

    private class SendPower
    extends TimerTask {
        private SendPower() {
        }

        @Override
        public void run() {
            RefrigPower.this.sendData();
        }
    }
}

