/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import org.lsst.ccs.subsystem.refrig.RefrigTest;

public class RefrigTestSim
extends RefrigTest {
    private static final float LOAD_POWER_FCTR = 6.667E-4f;
    private final ChannelSim[] chanDataSim;
    private int loadPwrId = -1;
    private int loadTmpId = -1;
    private long currTime = System.currentTimeMillis();
    private double loadFract = 0.6;

    public RefrigTestSim(String name, int tickMillis, Object[] chData, String configFile) {
        super(name, tickMillis, configFile);
        this.nChan = chData.length;
        this.chanData = new ChannelSim[this.nChan];
        this.chanDataSim = (ChannelSim[])this.chanData;
        int j = 0;
        while (j < this.nChan) {
            this.chanDataSim[j] = (ChannelSim)chData[j];
            if (this.chanDataSim[j].name.equals("LoadPower")) {
                this.loadPwrId = j;
            }
            if (this.chanDataSim[j].name.equals("LoadTmp")) {
                this.loadTmpId = j;
            }
            ++j;
        }
    }

    public void setLoadFract(double fract) {
        this.loadFract = (float)fract;
        this.setLoadPower();
    }

    public double getLoadFract() {
        return this.loadFract;
    }

    @Override
    void initSensors() {
        int j = 0;
        while (j < this.nChan) {
            ChannelSim ch = this.chanDataSim[j];
            if (j == this.loadPwrId) {
                ch.onTime = 0.0f;
                ch.offValue = 0.0f;
                ch.offTime = 0.0f;
            }
            ch.endValue = ch.offValue;
            ch.value = ch.offValue;
            ++j;
        }
    }

    @Override
    void readSensors() {
        long thisTime = System.currentTimeMillis();
        double intvl = (double)(thisTime - this.currTime) / 1000.0;
        this.currTime = thisTime;
        int j = 0;
        while (j < this.nChan) {
            ChannelSim ch = this.chanDataSim[j];
            ch.value = (float)((double)ch.value + (double)ch.rate * intvl);
            if (ch.negative) {
                if (ch.value < ch.endValue) {
                    ch.value = ch.endValue;
                }
            } else if (ch.value > ch.endValue) {
                ch.value = ch.endValue;
            }
            ++j;
        }
    }

    @Override
    void setMainPower() {
        this.currTime = System.currentTimeMillis();
        int j = 0;
        while (j < this.nChan) {
            if (j != this.loadPwrId) {
                ChannelSim ch = this.chanDataSim[j];
                ch.rate = 0.0f;
                if ((this.setState & 0x10000) != 0) {
                    ch.endValue = ch.onValue;
                    if (ch.onTime != 0.0f) {
                        ch.rate = (ch.onValue - ch.offValue) / ch.onTime;
                    }
                } else {
                    ch.endValue = ch.offValue;
                    if (ch.offTime != 0.0f) {
                        ch.rate = (ch.offValue - ch.onValue) / ch.offTime;
                    }
                }
                if (ch.rate == 0.0f) {
                    ch.value = ch.endValue;
                }
                ch.negative = ch.rate < 0.0f;
            }
            ++j;
        }
        this.setLoadPower();
    }

    @Override
    void setLoadPower() {
        ChannelSim pc = this.chanDataSim[this.loadPwrId];
        pc.endValue = 0.0f;
        if ((this.setState & 0x10000) != 0) {
            if ((this.chanState & 0x40000) != 0) {
                pc.endValue = (float)(this.loadFract * (double)pc.onValue);
            }
            ChannelSim tc = this.chanDataSim[this.loadTmpId];
            if (tc.onTime != 0.0f) {
                tc.rate = (tc.onValue - tc.offValue) / tc.onTime + 6.667E-4f * pc.endValue;
            }
        }
        pc.value = pc.endValue;
    }

    @Override
    void setDisplay() {
    }

    public static class ChannelSim
    extends RefrigTest.Channel
    implements Serializable {
        float onValue;
        float onTime;
        float offValue;
        float offTime;
        float endValue;
        float rate;
        boolean negative;

        public ChannelSim(String name, String desc, String units, String loCheck, String hiCheck, float deadbandLo, float deadbandHi, float onValue, float onTime, float offValue, float offTime) {
            super(name, desc, units, loCheck, hiCheck, deadbandLo, deadbandHi);
            this.onValue = onValue;
            this.onTime = onTime;
            this.offValue = offValue;
            this.offTime = offTime;
            this.endValue = 0.0f;
            this.rate = 0.0f;
            this.negative = false;
        }

        public String toString() {
            return "[" + this.name + ",\"" + this.description + "\"," + this.units + "," + this.loCheckS + "," + this.hiCheckS + "," + this.deadbandLo + "," + this.deadbandHi + "," + this.onValue + "," + this.onTime + "," + this.offValue + "," + this.offTime + "]";
        }
    }
}

