/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.util.HashMap;
import javax.usb.UsbException;
import org.lsst.ccs.drivers.mcc.MccUsb;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.subsystem.refrig.RefrigTest;
import org.lsst.ccs.utilities.conv.Convert;

public class RefrigTestHdw
extends RefrigTest
implements WattsUp.Listener {
    private static final int MCC_DEV_TC_AI = 0;
    private static final int MCC_DEV_TC = 1;
    private static final int MCC_DEV_TEMP = 2;
    private static final int N_MCC_DEVS = 3;
    private static final int N_MCC_DEV_CHANS = 8;
    private static final int N_MCC_CHANS = 24;
    private static final int TC_CHAN_MASK = 0xFFFF0F;
    private static final int RT_CHAN_MASK = 0xFF0000;
    private static final int V_CHAN_MASK = 240;
    private static final int N_ALARMS = 6;
    private static final int MAIN_POWER_DEV = 0;
    private static final int MAIN_POWER_BIT = 7;
    private static final int LOAD_POWER_DEV = 0;
    private static final int LOAD_POWER_DEV2 = 1;
    private static final int LOAD_POWER_BIT = 6;
    private static final int ALARMS_MASK = 63;
    private static final int LEDS_MASK = 127;
    private static final int LOAD_POWER_CHAN = 0;
    private static final int CMPR_POWER_CHAN = 1;
    private static final int CMPR_VOLTS_CHAN = 2;
    private static final int CHAN_TYPE_UNKNOWN = -1;
    private static final int CHAN_TYPE_TEMP = 0;
    private static final int CHAN_TYPE_VOLTS = 1;
    private static final int CHAN_TYPE_POWER = 2;
    private static final int CHAN_TYPE_SWITCH = 3;
    private static final int CHAN_TYPE_DIFF = 4;
    private static final float[] RTD_COEFFS = new float[]{100.0f, 0.003908f, -5.8019E-7f, -4.2735E-12f};
    private static final String[] DEV_NAMES = new String[3];
    private static final int[] DEV_DIDS;
    private final ChannelHdw[] chanDataHdw;
    private MccUsb[] mcc = new MccUsb[3];
    private WattsUp wtu;
    private float[] power = new float[]{-1.0f, -1.0f, -1.0f};
    private boolean[] mccInited = new boolean[3];
    private boolean wattsInited;

    static {
        RefrigTestHdw.DEV_NAMES[0] = "USB_TC_AI";
        RefrigTestHdw.DEV_NAMES[1] = "USB_TC";
        RefrigTestHdw.DEV_NAMES[2] = "USB_TEMP";
        DEV_DIDS = new int[3];
        RefrigTestHdw.DEV_DIDS[0] = 0;
        RefrigTestHdw.DEV_DIDS[1] = 1;
        RefrigTestHdw.DEV_DIDS[2] = 2;
    }

    public RefrigTestHdw(String name, int tickMillis, Object[] chData, String configFile) {
        super(name, tickMillis, configFile);
        this.nChan = chData.length;
        this.chanData = new ChannelHdw[this.nChan];
        this.chanDataHdw = (ChannelHdw[])this.chanData;
        int j = 0;
        while (j < this.nChan) {
            this.chanDataHdw[j] = (ChannelHdw)chData[j];
            ++j;
        }
        j = 0;
        while (j < this.nChan) {
            ChannelHdw ch = this.chanDataHdw[j];
            if (ch.type == 4) {
                String[] names = ch.subtypeS.split(":", -1);
                boolean okay = false;
                if (names.length == 2) {
                    int indx0 = this.findChannel(names[0]);
                    int indx1 = this.findChannel(names[1]);
                    if (indx0 >= 0 && indx1 >= 0) {
                        ch.subtype = indx0 << 16 | indx1;
                        okay = true;
                    }
                }
                if (!okay) {
                    log.error((Object)("Invalid subtype (" + ch.subtypeS + ") for " + ch.name));
                    ch.type = -1;
                }
            }
            ++j;
        }
    }

    private int findChannel(String name) {
        int j = 0;
        while (j < this.nChan) {
            ChannelHdw ch = this.chanDataHdw[j];
            if (name.equals(ch.name)) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    @Override
    void initSensors() {
        int dev = 0;
        while (dev < 3) {
            try {
                this.mcc[dev] = new MccUsb();
                this.mcc[dev].open(DEV_DIDS[dev], null, true);
                this.mcc[dev].blink();
                this.mcc[dev].dioConfig(0);
                this.mcc[dev].dioOut(0);
                if (dev == 0) {
                    int j = 0;
                    while (j < 6) {
                        this.mcc[dev].configAlarm(j, 0, 0, 0.0f, 0.0f);
                        ++j;
                    }
                } else if (dev == 2) {
                    int j = 0;
                    while (j < 8) {
                        this.mcc[dev].setSensorType(j, 4);
                        j += 2;
                    }
                }
                this.mccInited[dev] = true;
            }
            catch (UsbException e) {
                log.error((Object)("Error initializing " + DEV_NAMES[dev] + " module: " + (Object)((Object)e)));
            }
            ++dev;
        }
        try {
            this.wtu = new WattsUp();
            this.wtu.addListener((WattsUp.Listener)this);
            this.wtu.open();
            this.wattsInited = true;
            this.power[0] = 0.0f;
        }
        catch (Exception e) {
            log.error((Object)("Cannot access WattsUp meter: " + e));
        }
        int j = 0;
        while (j < this.nChan) {
            ChannelHdw ch = this.chanDataHdw[j];
            int dev2 = ch.chan / 8;
            if (this.mccInited[dev2]) {
                int chan = ch.chan % 8;
                try {
                    if (ch.type == 0) {
                        int sType = ch.subtype & 0xFF;
                        int tType = ch.subtype >> 8;
                        this.mcc[dev2].setSensorType(chan, sType);
                        if (sType == 0) {
                            this.mcc[dev2].setThermConnType(chan, tType);
                            this.mcc[dev2].setExcitation(chan, 2);
                            this.mcc[dev2].setGain(chan, 2);
                            int k = 0;
                            while (k < RTD_COEFFS.length) {
                                this.mcc[dev2].setCoefficient(chan, k, RTD_COEFFS[k]);
                                ++k;
                            }
                        } else {
                            this.mcc[dev2].setTCType(chan, tType);
                        }
                    } else if (ch.type == 1) {
                        this.mcc[dev2].setGain(chan, ch.subtype);
                        this.mcc[dev2].setVoltageConnType(chan, 0);
                    } else if (ch.type == 3) {
                        this.mcc[dev2].dioConfigBit(chan, 1);
                    }
                }
                catch (UsbException e) {
                    log.error((Object)("Error configuring " + DEV_NAMES[dev2] + " module: " + (Object)((Object)e)));
                    this.mccInited[dev2] = false;
                }
            }
            ++j;
        }
        new RemotePower().start();
    }

    @Override
    void readSensors() {
        ChannelHdw ch;
        int j = 0;
        while (j < this.nChan) {
            block12: {
                ch = this.chanDataHdw[j];
                if (ch.type == 2) {
                    ch.value = this.power[ch.chan];
                } else if (ch.type == 3 || ch.type == 0 || ch.type == 1) {
                    int dev = ch.chan / 8;
                    int chan = ch.chan % 8;
                    if (ch.type == 3) {
                        try {
                            ch.value = this.mcc[dev].dioInBit(chan);
                        }
                        catch (UsbException e) {
                            if (this.mccInited[dev]) {
                                log.error((Object)("Error reading DIO line: " + (Object)((Object)e)));
                            }
                            break block12;
                        }
                    }
                    try {
                        ch.value = ch.offset + ch.scale * this.mcc[dev].adcIn(chan, 0);
                    }
                    catch (UsbException e) {
                        if (!this.mccInited[dev]) break block12;
                        log.error((Object)("Error reading ADC: " + (Object)((Object)e)));
                    }
                }
            }
            ++j;
        }
        j = 0;
        while (j < this.nChan) {
            ch = this.chanDataHdw[j];
            if (ch.type == 4) {
                ch.value = this.chanDataHdw[ch.subtype >> 16].value - this.chanDataHdw[ch.subtype & 0xFFFF].value;
            }
            ++j;
        }
    }

    @Override
    void setMainPower() {
        block2: {
            try {
                int on = this.setState >> 16 & 1;
                this.mcc[0].dioOutBit(7, on);
            }
            catch (UsbException e) {
                if (!this.mccInited[0]) break block2;
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
            }
        }
    }

    @Override
    void setLoadPower() {
        block5: {
            int on;
            block4: {
                on = this.chanState >> 18 & 1;
                try {
                    this.mcc[0].dioOutBit(6, on);
                }
                catch (UsbException e) {
                    if (!this.mccInited[0]) break block4;
                    log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
                }
            }
            try {
                this.mcc[1].dioOutBit(6, on ^ 1);
            }
            catch (UsbException e) {
                if (!this.mccInited[1]) break block5;
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
            }
        }
    }

    @Override
    void setDisplay() {
        int j = 0;
        while (j < this.nChan) {
            block7: {
                ChannelHdw ch = this.chanDataHdw[j];
                if (ch.alarm >= 0) {
                    int good;
                    block6: {
                        good = this.chanState >> j & 1;
                        try {
                            this.mcc[0].dioOutBit(ch.alarm, good ^ 1);
                        }
                        catch (UsbException e) {
                            if (!this.mccInited[0]) break block6;
                            log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
                        }
                    }
                    try {
                        this.mcc[1].dioOutBit(ch.alarm, good);
                    }
                    catch (UsbException e) {
                        if (!this.mccInited[1]) break block7;
                        log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
                    }
                }
            }
            ++j;
        }
    }

    public void setPowered(boolean on) {
        if (on) {
            try {
                this.wtu.setLoggedFields(1);
                this.wtu.setExternalLogging(1);
            }
            catch (Exception e) {
                log.error((Object)("Cannot initialize WattsUp meter: " + e));
            }
        } else {
            this.power[0] = 0.0f;
        }
    }

    public void setClosed() {
        this.power[0] = -1.0f;
        this.wattsInited = false;
    }

    public void processData(float[] data) {
        this.power[0] = data[0];
    }

    public static class ChannelHdw
    extends RefrigTest.Channel
    implements Serializable {
        String typeS;
        String subtypeS;
        int chan;
        int alarm;
        float offset;
        float scale;
        int type;
        int subtype;
        private static final HashMap<String, Integer> typeMap = new HashMap();
        private static final HashMap<String, Integer> tSubtypeMap;
        private static final HashMap<String, Integer> tcSubtypeMap;
        private static final HashMap<String, Integer> rtSubtypeMap;
        private static final HashMap<String, Integer> vSubtypeMap;

        static {
            typeMap.put("TEMP", 0);
            typeMap.put("VOLTS", 1);
            typeMap.put("POWER", 2);
            typeMap.put("SWITCH", 3);
            typeMap.put("DIFF", 4);
            tSubtypeMap = new HashMap();
            tSubtypeMap.put("TC", 2);
            tSubtypeMap.put("RTD", 0);
            tcSubtypeMap = new HashMap();
            tcSubtypeMap.put("J", 0);
            tcSubtypeMap.put("K", 1);
            tcSubtypeMap.put("T", 2);
            tcSubtypeMap.put("E", 3);
            tcSubtypeMap.put("R", 4);
            tcSubtypeMap.put("S", 5);
            tcSubtypeMap.put("B", 6);
            tcSubtypeMap.put("N", 7);
            rtSubtypeMap = new HashMap();
            rtSubtypeMap.put("2WIRE1", 0);
            rtSubtypeMap.put("2WIRE2", 1);
            rtSubtypeMap.put("3WIRE", 2);
            rtSubtypeMap.put("4WIRE", 3);
            vSubtypeMap = new HashMap();
            vSubtypeMap.put("10V", 2);
            vSubtypeMap.put("5V", 3);
            vSubtypeMap.put("2.5V", 4);
            vSubtypeMap.put("1.25V", 5);
        }

        public ChannelHdw(String name, String desc, String units, String loCheck, String hiCheck, float deadbandLo, float deadbandHi, String type, String subtype, int chan, int alarm, float offset, float scale) {
            super(name, desc, units, loCheck, hiCheck, deadbandLo, deadbandHi);
            int iType = -1;
            int iSubtype = -1;
            int iChan = -1;
            int iAlarm = -1;
            try {
                Integer iTyp = typeMap.get(type.toUpperCase());
                if (iTyp == null) {
                    RefrigTestHdw.reportError(name, "type", type);
                }
                iType = iTyp;
                String sbtype = subtype.toUpperCase();
                if (iType == 0) {
                    Integer iStp;
                    String[] sbtypes = sbtype.split(":", -1);
                    if (sbtypes.length < 2) {
                        RefrigTestHdw.reportError(name, "subtype", subtype);
                    }
                    if ((iStp = tSubtypeMap.get(sbtypes[0])) == null) {
                        RefrigTestHdw.reportError(name, "subtype", subtype);
                    }
                    iSubtype = iStp;
                    if ((iStp = iStp == 0 ? rtSubtypeMap.get(sbtypes[1]) : tcSubtypeMap.get(sbtypes[1])) == null) {
                        RefrigTestHdw.reportError(name, "subtype", subtype);
                    }
                    iSubtype |= iStp << 8;
                } else if (iType == 1) {
                    Integer iStp = vSubtypeMap.get(sbtype);
                    if (iStp == null) {
                        RefrigTestHdw.reportError(name, "subtype", subtype);
                    }
                    iSubtype = iStp;
                }
                if (iType == 0) {
                    int mask;
                    int n = mask = (iSubtype & 0xFF) == 0 ? 0xFF0000 : 0xFFFF0F;
                    if ((1 << chan & mask) == 0) {
                        RefrigTestHdw.reportError(name, "hw channel number", chan);
                    }
                } else if (iType == 1) {
                    if ((1 << chan & 0xF0) == 0) {
                        RefrigTestHdw.reportError(name, "hw channel number", chan);
                    }
                } else if (iType == 3 && (chan < 0 || chan >= 24)) {
                    RefrigTestHdw.reportError(name, "hw channel number", chan);
                }
                iChan = chan;
                if (alarm >= 6) {
                    RefrigTestHdw.reportError(name, "alarm number", alarm);
                }
                iAlarm = alarm;
            }
            catch (Exception exception) {}
            this.typeS = type;
            this.subtypeS = subtype;
            this.type = iType;
            this.subtype = iSubtype;
            this.chan = iChan;
            this.alarm = iAlarm;
            this.offset = offset;
            this.scale = scale;
        }

        public String toString() {
            return "[" + this.name + ",\"" + this.description + "\"," + this.units + "," + this.loCheckS + "," + this.hiCheckS + "," + this.deadbandLo + "," + this.deadbandHi + "," + this.typeS + "," + this.subtypeS + "," + this.chan + "," + this.alarm + "," + this.offset + "," + this.scale + "]";
        }
    }

    private class RemotePower
    extends Thread {
        private RemotePower() {
        }

        @Override
        public void run() {
            ServerSocket server;
            try {
                server = new ServerSocket(7070, 1);
            }
            catch (IOException e) {
                log.error((Object)("Error creating remote power listener: " + e));
                return;
            }
            byte[] data = new byte[12];
            block8: while (true) {
                InputStream netInp;
                try {
                    netInp = server.accept().getInputStream();
                }
                catch (IOException e) {
                    log.error((Object)("Error creating remote power socket: " + e));
                    continue;
                }
                while (true) {
                    int nRead;
                    try {
                        nRead = netInp.read(data);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error reading remote power data: " + e));
                        nRead = -2;
                    }
                    if (nRead < 0) {
                        try {
                            netInp.close();
                        }
                        catch (IOException iOException) {}
                        ((RefrigTestHdw)RefrigTestHdw.this).power[1] = -1.0f;
                        ((RefrigTestHdw)RefrigTestHdw.this).power[2] = -1.0f;
                        continue block8;
                    }
                    if (nRead < data.length || Convert.bytesToInt((byte[])data, (int)0) != 13572468) continue;
                    ((RefrigTestHdw)RefrigTestHdw.this).power[1] = Convert.bytesToFloat((byte[])data, (int)4);
                    ((RefrigTestHdw)RefrigTestHdw.this).power[2] = Convert.bytesToFloat((byte[])data, (int)8);
                }
                break;
            }
        }
    }
}

