/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.refrig.data.RefrigChannel;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.status.RefrigStateStatus;

public abstract class RefrigTest
extends Module {
    static final int MAX_CHANS = 16;
    static final String PREFIX = "org.lsst.ccs.refrig.";
    static final long UPDATE_PERIOD = 1000L;
    String configFile = "config.properties";
    Properties config;
    Channel[] chanData;
    int nChan;
    int loLimChange = 0;
    int hiLimChange = 0;
    int setState = 0;
    int chanState = 0;
    boolean running = false;

    public RefrigTest(String name, int tickMillis, String configFile) {
        this.setName(name);
        this.tickMillis = tickMillis;
        this.configFile = configFile;
    }

    public void initModule() {
        this.initConfiguration();
        this.initSensors();
        new Timer().schedule((TimerTask)new UpdateState(), 0L, 1000L);
    }

    public void tick() {
        if (!this.running) {
            System.out.println("Refrigeration test system started");
            this.publishState();
            this.publishLimits();
            this.running = true;
        }
        long timeStamp = System.currentTimeMillis();
        ArrayList<ValueNotification> trendingValues = new ArrayList<ValueNotification>();
        int j = 0;
        while (j < this.nChan) {
            Channel chan = this.chanData[j];
            trendingValues.add(new ValueNotification(chan.name, (Object)Float.valueOf(chan.value), timeStamp));
            ++j;
        }
        trendingValues.add(new ValueNotification("state", (Object)this.getState(), timeStamp));
        this.publishData(trendingValues);
    }

    public void setTickMillis(int value) {
        super.setTickMillis(value);
        if (this.running) {
            this.publishState();
        }
    }

    public void setMainPowerEnable(int value) {
        this.setMainPowerEnable(value, true);
    }

    public void setMainPowerEnable(int value, boolean publish) {
        if (value != 0) {
            if ((this.chanState & 0x20000) == 0) {
                this.setState |= 0x10000;
            }
        } else {
            this.setState &= 0xFFFEFFFF;
        }
        this.setMainPower();
        if (publish) {
            this.publishState();
        }
    }

    public void setLoadTripEnable(int value) {
        this.setState = value != 0 ? (this.setState |= 0x80000) : (this.setState &= 0xFFF7FFFF);
        this.publishState();
    }

    public int getState() {
        return this.setState | this.chanState;
    }

    public void setLowLimit(int id, double limit) {
        Channel chan = this.chanData[id];
        float fLimit = (float)limit;
        if (fLimit == chan.limitLo) {
            return;
        }
        chan.limitLo = fLimit;
        String sLimit = String.valueOf(fLimit);
        this.config.setProperty(PREFIX + chan.limitLoName, sLimit);
        this.loLimChange |= 1 << id;
        this.publishState();
        this.getSubsystem().publishMetaData(chan.name, "alarmLow", sLimit);
    }

    public void setHighLimit(int id, double limit) {
        Channel chan = this.chanData[id];
        float fLimit = (float)limit;
        if (fLimit == chan.limitHi) {
            return;
        }
        chan.limitHi = fLimit;
        String sLimit = String.valueOf(fLimit);
        this.config.setProperty(PREFIX + chan.limitHiName, sLimit);
        this.hiLimChange |= 1 << id;
        this.publishState();
        this.getSubsystem().publishMetaData(chan.name, "alarmHigh", sLimit);
    }

    public void saveConfiguration() {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.configFile);
        }
        catch (IOException e) {
            log.error((Object)("Error opening configuration file: " + e));
        }
        if (writer != null) {
            try {
                this.config.store(writer, "Refrigeration long lines test configuration");
                this.hiLimChange = 0;
                this.loLimChange = 0;
            }
            catch (IOException e) {
                log.error((Object)("Error writing configuration: " + e));
            }
            try {
                writer.close();
            }
            catch (IOException e) {
                log.error((Object)("Error closing configuration file: " + e));
            }
        }
        this.publishState();
    }

    public RefrigFullState getFullState() {
        RefrigFullState status = new RefrigFullState();
        int i = 0;
        while (i < this.nChan) {
            Channel c = this.chanData[i];
            status.addChannel(new RefrigChannel(c.name, c.description, c.units, (double)c.limitLo, (double)c.limitHi, c.value));
            ++i;
        }
        status.setRefrigState(new RefrigState(this.getState(), this.loLimChange, this.hiLimChange, this.getTickMillis()));
        return status;
    }

    void publishState() {
        RefrigState refrigState = new RefrigState(this.getState(), this.loLimChange, this.hiLimChange, this.getTickMillis());
        this.sendToStatus((Status)new RefrigStateStatus(refrigState));
    }

    void publishLimits() {
        int i = 0;
        while (i < this.nChan) {
            Channel c = this.chanData[i];
            this.getSubsystem().publishMetaData(c.name, "alarmLow", String.valueOf(c.limitLo));
            this.getSubsystem().publishMetaData(c.name, "alarmHigh", String.valueOf(c.limitHi));
            ++i;
        }
    }

    void checkLimits() {
        int cState = 262144;
        int j = 0;
        while (j < this.nChan) {
            Channel ch = this.chanData[j];
            boolean ok = true;
            if (ch.value < ch.limitLo) {
                ok = false;
                if (ch.loCheck == 0) {
                    ok = true;
                } else if (ch.loCheck == 2) {
                    cState |= 0x20000;
                } else if (ch.loCheck == 3 && (this.setState & 0x80000) != 0) {
                    cState &= 0xFFFBFFFF;
                    ch.trippedLo = true;
                }
            } else if (ch.value > ch.limitHi) {
                ok = false;
                if (ch.hiCheck == 0) {
                    ok = true;
                } else if (ch.hiCheck == 2) {
                    cState |= 0x20000;
                } else if (ch.hiCheck == 3 && (this.setState & 0x80000) != 0) {
                    cState &= 0xFFFBFFFF;
                    ch.trippedHi = true;
                }
            } else {
                boolean tripped;
                if (ch.loCheck == 3) {
                    tripped = false;
                    if ((this.setState & 0x80000) != 0 && ch.trippedLo && ch.value < ch.limitLo + ch.deadbandLo) {
                        cState &= 0xFFFBFFFF;
                        tripped = true;
                    }
                    ch.trippedLo = tripped;
                }
                if (ch.hiCheck == 3) {
                    tripped = false;
                    if ((this.setState & 0x80000) != 0 && ch.trippedHi && ch.value > ch.limitHi - ch.deadbandHi) {
                        cState &= 0xFFFBFFFF;
                        tripped = true;
                    }
                    ch.trippedHi = tripped;
                }
            }
            if (ok) {
                cState |= 1 << j;
            }
            ++j;
        }
        this.chanState ^= (cState ^= this.chanState);
        if (cState != 0) {
            int tr;
            if ((cState & 0x20000) != 0 && (tr = this.chanState >> 17 & 1) != 0) {
                this.setMainPowerEnable(0, false);
            }
            if ((cState & 0x40000) != 0) {
                this.setLoadPower();
            }
            if (this.running) {
                this.publishState();
                this.tick();
            }
        }
    }

    static void reportError(String cName, String pName, Object pValue) throws Exception {
        log.error((Object)("Invalid " + pName + " (" + pValue + ") for " + cName));
        throw new Exception();
    }

    private void initConfiguration() {
        Channel chan;
        Properties dfltConfig = new Properties();
        int j = 0;
        while (j < this.nChan) {
            chan = this.chanData[j];
            dfltConfig.setProperty(PREFIX + chan.limitLoName, "0.0");
            dfltConfig.setProperty(PREFIX + chan.limitHiName, "0.0");
            ++j;
        }
        this.config = this.loadProperties(this.configFile, dfltConfig);
        j = 0;
        while (j < this.nChan) {
            chan = this.chanData[j];
            chan.limitLo = Float.valueOf(this.config.getProperty(PREFIX + chan.limitLoName)).floatValue();
            chan.limitHi = Float.valueOf(this.config.getProperty(PREFIX + chan.limitHiName)).floatValue();
            ++j;
        }
    }

    private Properties loadProperties(String file, Properties dflt) {
        Properties propList = dflt == null ? new Properties() : new Properties(dflt);
        FileReader reader = null;
        try {
            reader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error opening properties file: " + e));
        }
        try {
            propList.load(reader);
        }
        catch (IOException e) {
            log.error((Object)("Error reading properties file: " + e));
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            log.error((Object)("Error closing properties file: " + e));
        }
        return propList;
    }

    abstract void initSensors();

    abstract void readSensors();

    abstract void setMainPower();

    abstract void setLoadPower();

    abstract void setDisplay();

    public static class Channel
    implements Serializable {
        String name;
        String description;
        String units;
        String loCheckS;
        String hiCheckS;
        int loCheck;
        int hiCheck;
        float deadbandLo;
        float deadbandHi;
        float limitLo;
        float limitHi;
        String limitLoName;
        String limitHiName;
        float value;
        boolean trippedLo;
        boolean trippedHi;
        static final int LIMIT_CHECK_NONE = 0;
        static final int LIMIT_CHECK_FLAG = 1;
        static final int LIMIT_CHECK_MAIN_TRIP = 2;
        static final int LIMIT_CHECK_LOAD_TRIP = 3;
        private static final HashMap<String, Integer> checkMap = new HashMap();

        static {
            checkMap.put("NONE", 0);
            checkMap.put("FLAG", 1);
            checkMap.put("MTRIP", 2);
            checkMap.put("LTRIP", 3);
        }

        public Channel(String name, String desc, String units, String loCheck, String hiCheck, float deadbandLo, float deadbandHi) {
            int iLoCheck = 1;
            int iHiCheck = 1;
            try {
                Integer iCheck = checkMap.get(loCheck.toUpperCase());
                if (iCheck == null) {
                    RefrigTest.reportError(name, "locheck", loCheck);
                }
                iLoCheck = iCheck;
                iCheck = checkMap.get(hiCheck.toUpperCase());
                if (iCheck == null) {
                    RefrigTest.reportError(name, "hicheck", hiCheck);
                }
                iHiCheck = iCheck;
            }
            catch (Exception exception) {}
            this.name = name;
            this.description = desc;
            this.units = units;
            this.loCheckS = loCheck;
            this.hiCheckS = hiCheck;
            this.loCheck = iLoCheck;
            this.hiCheck = iHiCheck;
            this.deadbandLo = deadbandLo;
            this.deadbandHi = deadbandHi;
            this.limitLoName = String.valueOf(name) + "LoLim";
            this.limitHiName = String.valueOf(name) + "HiLim";
        }
    }

    private class UpdateState
    extends TimerTask {
        private UpdateState() {
        }

        @Override
        public void run() {
            RefrigTest.this.readSensors();
            RefrigTest.this.checkLimits();
            RefrigTest.this.setDisplay();
        }
    }
}

